/* Copyright (C) 2021-2025 Artifex Software, Inc.
   All Rights Reserved.

   This software is provided AS-IS with no warranty, either express or
   implied.

   This software is distributed under license and may not be copied,
   modified or distributed except as expressly authorized under the terms
   of the license contained in the file LICENSE in this distribution.

   Refer to licensing information at http://www.artifex.com or contact
   Artifex Software, Inc.,  39 Mesa Street, Suite 108A, San Francisco,
   CA 94129, USA, for further information.
*/
#include "ghostpdf.h"
#include "pdf_types.h"
#include "pdf_font.h"

#ifdef UFST_BRIDGE

static const pdfi_font_decoding_t FCO_Dingbats = {
  "FCO_Dingbats",
  12,
  202,
  {
    {"a1", 2, 61473},
    {"a10", 3, 61505},
    {"a100", 4, 61566},
    {"a101", 4, 61601},
    {"a102", 4, 61602},
    {"a103", 4, 61603},
    {"a104", 4, 61604},
    {"a105", 4, 61488},
    {"a106", 4, 61605},
    {"a107", 4, 61606},
    {"a108", 4, 61607},
    {"a109", 4, 61611},
    {"a11", 3, 61482},
    {"a110", 4, 61610},
    {"a111", 4, 61609},
    {"a112", 4, 61608},
    {"a117", 4, 61481},
    {"a118", 4, 61480},
    {"a119", 4, 61479},
    {"a12", 3, 61483},
    {"a120", 4, 61612},
    {"a121", 4, 61613},
    {"a122", 4, 61614},
    {"a123", 4, 61615},
    {"a124", 4, 61616},
    {"a125", 4, 61617},
    {"a126", 4, 61618},
    {"a127", 4, 61619},
    {"a128", 4, 61620},
    {"a129", 4, 61621},
    {"a13", 3, 61484},
    {"a130", 4, 61622},
    {"a131", 4, 61623},
    {"a132", 4, 61624},
    {"a133", 4, 61625},
    {"a134", 4, 61626},
    {"a135", 4, 61627},
    {"a136", 4, 61628},
    {"a137", 4, 61629},
    {"a138", 4, 61630},
    {"a139", 4, 61631},
    {"a14", 3, 61485},
    {"a140", 4, 61632},
    {"a141", 4, 61633},
    {"a142", 4, 61634},
    {"a143", 4, 61635},
    {"a144", 4, 61636},
    {"a145", 4, 61637},
    {"a146", 4, 61638},
    {"a147", 4, 61639},
    {"a148", 4, 61640},
    {"a149", 4, 61641},
    {"a15", 3, 61486},
    {"a150", 4, 61642},
    {"a151", 4, 61643},
    {"a152", 4, 61644},
    {"a153", 4, 61645},
    {"a154", 4, 61646},
    {"a155", 4, 61647},
    {"a156", 4, 61648},
    {"a157", 4, 61649},
    {"a158", 4, 61650},
    {"a159", 4, 61651},
    {"a16", 3, 61487},
    {"a160", 4, 61652},
    {"a161", 4, 61653},
    {"a162", 4, 61667},
    {"a163", 4, 61654},
    {"a164", 4, 61655},
    {"a165", 4, 61657},
    {"a166", 4, 61659},
    {"a167", 4, 61660},
    {"a168", 4, 61661},
    {"a169", 4, 61662},
    {"a17", 3, 61489},
    {"a170", 4, 61663},
    {"a171", 4, 61664},
    {"a172", 4, 61665},
    {"a173", 4, 61666},
    {"a174", 4, 61668},
    {"a175", 4, 61669},
    {"a176", 4, 61670},
    {"a177", 4, 61671},
    {"a178", 4, 61672},
    {"a179", 4, 61673},
    {"a18", 3, 61490},
    {"a180", 4, 61675},
    {"a181", 4, 61677},
    {"a182", 4, 61679},
    {"a183", 4, 61682},
    {"a184", 4, 61683},
    {"a185", 4, 61685},
    {"a186", 4, 61688},
    {"a187", 4, 61690},
    {"a188", 4, 61691},
    {"a189", 4, 61692},
    {"a19", 3, 61491},
    {"a190", 4, 61693},
    {"a191", 4, 61694},
    {"a192", 4, 61658},
    {"a193", 4, 61674},
    {"a194", 4, 61686},
    {"a195", 4, 61689},
    {"a196", 4, 61656},
    {"a197", 4, 61684},
    {"a198", 4, 61687},
    {"a199", 4, 61676},
    {"a2", 2, 61474},
    {"a20", 3, 61492},
    {"a200", 4, 61678},
    {"a201", 4, 61681},
    {"a202", 4, 61475},
    {"a203", 4, 61552},
    {"a204", 4, 61554},
    {"a205", 4, 61574},
    {"a206", 4, 61576},
    {"a21", 3, 61493},
    {"a22", 3, 61494},
    {"a23", 3, 61495},
    {"a24", 3, 61496},
    {"a25", 3, 61497},
    {"a26", 3, 61498},
    {"a27", 3, 61499},
    {"a28", 3, 61500},
    {"a29", 3, 61506},
    {"a3", 2, 61476},
    {"a30", 3, 61507},
    {"a31", 3, 61508},
    {"a32", 3, 61509},
    {"a33", 3, 61510},
    {"a34", 3, 61511},
    {"a35", 3, 61512},
    {"a36", 3, 61513},
    {"a37", 3, 61514},
    {"a38", 3, 61515},
    {"a39", 3, 61516},
    {"a4", 2, 61477},
    {"a40", 3, 61517},
    {"a41", 3, 61518},
    {"a42", 3, 61519},
    {"a43", 3, 61520},
    {"a44", 3, 61521},
    {"a45", 3, 61522},
    {"a46", 3, 61523},
    {"a47", 3, 61524},
    {"a48", 3, 61525},
    {"a49", 3, 61526},
    {"a5", 2, 61478},
    {"a50", 3, 61527},
    {"a51", 3, 61528},
    {"a52", 3, 61529},
    {"a53", 3, 61530},
    {"a54", 3, 61531},
    {"a55", 3, 61532},
    {"a56", 3, 61533},
    {"a57", 3, 61534},
    {"a58", 3, 61535},
    {"a59", 3, 61536},
    {"a6", 2, 61501},
    {"a60", 3, 61537},
    {"a61", 3, 61538},
    {"a62", 3, 61539},
    {"a63", 3, 61540},
    {"a64", 3, 61541},
    {"a65", 3, 61542},
    {"a66", 3, 61543},
    {"a67", 3, 61544},
    {"a68", 3, 61545},
    {"a69", 3, 61546},
    {"a7", 2, 61502},
    {"a70", 3, 61547},
    {"a71", 3, 61548},
    {"a72", 3, 61549},
    {"a73", 3, 61550},
    {"a74", 3, 61551},
    {"a75", 3, 61553},
    {"a76", 3, 61555},
    {"a77", 3, 61556},
    {"a78", 3, 61557},
    {"a79", 3, 61558},
    {"a8", 2, 61503},
    {"a81", 3, 61559},
    {"a82", 3, 61560},
    {"a83", 3, 61561},
    {"a84", 3, 61562},
    {"a85", 3, 61575},
    {"a86", 3, 61577},
    {"a87", 3, 61578},
    {"a88", 3, 61579},
    {"a89", 3, 61568},
    {"a9", 2, 61504},
    {"a90", 3, 61569},
    {"a91", 3, 61572},
    {"a92", 3, 61573},
    {"a93", 3, 61570},
    {"a94", 3, 61571},
    {"a95", 3, 61580},
    {"a96", 3, 61581},
    {"a97", 3, 61563},
    {"a98", 3, 61564},
    {"a99", 3, 61565},
    {"space", 5, 32},
  }
};
static const pdfi_font_decoding_t FCO_Symbol = {
  "FCO_Symbol",
  10,
  189,
  {
    {"Alpha", 5, 61505},
    {"Beta", 4, 61506},
    {"Chi", 3, 61507},
    {"Delta", 5, 61508},
    {"Epsilon", 7, 61509},
    {"Eta", 3, 61512},
    {"Euro", 4, 61600},
    {"Gamma", 5, 61511},
    {"Ifraktur", 8, 61633},
    {"Iota", 4, 61513},
    {"Kappa", 5, 61515},
    {"Lambda", 6, 61516},
    {"Mu", 2, 61517},
    {"Nu", 2, 61518},
    {"Omega", 5, 61527},
    {"Omicron", 7, 61519},
    {"Phi", 3, 61510},
    {"Pi", 2, 61520},
    {"Psi", 3, 61529},
    {"Rfraktur", 8, 61634},
    {"Rho", 3, 61522},
    {"Sigma", 5, 61523},
    {"Tau", 3, 61524},
    {"Theta", 5, 61521},
    {"Upsilon", 7, 61525},
    {"Upsilon1", 8, 61601},
    {"Xi", 2, 61528},
    {"Zeta", 4, 61530},
    {"aleph", 5, 61632},
    {"alpha", 5, 61537},
    {"ampersand", 9, 61478},
    {"angle", 5, 61648},
    {"angleleft", 9, 61665},
    {"angleright", 10, 61681},
    {"approxequal", 11, 61627},
    {"arrowboth", 9, 61611},
    {"arrowdblboth", 12, 61659},
    {"arrowdbldown", 12, 61663},
    {"arrowdblleft", 12, 61660},
    {"arrowdblright", 13, 61662},
    {"arrowdblup", 10, 61661},
    {"arrowdown", 9, 61615},
    {"arrowhorizex", 12, 61630},
    {"arrowleft", 9, 61612},
    {"arrowright", 10, 61614},
    {"arrowup", 7, 61613},
    {"arrowvertex", 11, 61629},
    {"asteriskmath", 12, 61482},
    {"bar", 3, 61564},
    {"beta", 4, 61538},
    {"braceex", 7, 61679},
    {"braceleft", 9, 61563},
    {"braceleftbt", 11, 61678},
    {"braceleftmid", 12, 61677},
    {"bracelefttp", 11, 61676},
    {"braceright", 10, 61565},
    {"bracerightbt", 12, 61694},
    {"bracerightmid", 13, 61693},
    {"bracerighttp", 12, 61692},
    {"bracketleft", 11, 61531},
    {"bracketleftbt", 13, 61675},
    {"bracketleftex", 13, 61674},
    {"bracketlefttp", 13, 61673},
    {"bracketright", 12, 61533},
    {"bracketrightbt", 14, 61691},
    {"bracketrightex", 14, 61690},
    {"bracketrighttp", 14, 61689},
    {"bullet", 6, 61623},
    {"carriagereturn", 14, 61631},
    {"chi", 3, 61539},
    {"circlemultiply", 14, 61636},
    {"circleplus", 10, 61637},
    {"club", 4, 61607},
    {"colon", 5, 61498},
    {"comma", 5, 61484},
    {"congruent", 9, 61504},
    {"copyrightsans", 13, 61667},
    {"copyrightserif", 14, 61651},
    {"degree", 6, 61616},
    {"delta", 5, 61540},
    {"diamond", 7, 61608},
    {"divide", 6, 61624},
    {"dotmath", 7, 61655},
    {"eight", 5, 61496},
    {"element", 7, 61646},
    {"ellipsis", 8, 61628},
    {"emptyset", 8, 61638},
    {"epsilon", 7, 61541},
    {"equal", 5, 61501},
    {"equivalence", 11, 61626},
    {"eta", 3, 61544},
    {"exclam", 6, 61473},
    {"existential", 11, 61476},
    {"five", 4, 61493},
    {"florin", 6, 61606},
    {"four", 4, 61492},
    {"fraction", 8, 61604},
    {"gamma", 5, 61543},
    {"gradient", 8, 61649},
    {"greater", 7, 61502},
    {"greaterequal", 12, 61619},
    {"heart", 5, 61609},
    {"infinity", 8, 61605},
    {"integral", 8, 61682},
    {"integralbt", 10, 61685},
    {"integralex", 10, 61684},
    {"integraltp", 10, 61683},
    {"intersection", 12, 61639},
    {"iota", 4, 61545},
    {"kappa", 5, 61547},
    {"lambda", 6, 61548},
    {"less", 4, 61500},
    {"lessequal", 9, 61603},
    {"logicaland", 10, 61657},
    {"logicalnot", 10, 61656},
    {"logicalor", 9, 61658},
    {"lozenge", 7, 61664},
    {"minus", 5, 61485},
    {"minute", 6, 61602},
    {"mu", 2, 61549},
    {"multiply", 8, 61620},
    {"nine", 4, 61497},
    {"notelement", 10, 61647},
    {"notequal", 8, 61625},
    {"notsubset", 9, 61643},
    {"nu", 2, 61550},
    {"numbersign", 10, 61475},
    {"omega", 5, 61559},
    {"omega1", 6, 61558},
    {"omicron", 7, 61551},
    {"one", 3, 61489},
    {"parenleft", 9, 61480},
    {"parenleftbt", 11, 61672},
    {"parenleftex", 11, 61671},
    {"parenlefttp", 11, 61670},
    {"parenright", 10, 61481},
    {"parenrightbt", 12, 61688},
    {"parenrightex", 12, 61687},
    {"parenrighttp", 12, 61686},
    {"partialdiff", 11, 61622},
    {"percent", 7, 61477},
    {"period", 6, 61486},
    {"perpendicular", 13, 61534},
    {"phi", 3, 61542},
    {"phi1", 4, 61546},
    {"pi", 2, 61552},
    {"plus", 4, 61483},
    {"plusminus", 9, 61617},
    {"product", 7, 61653},
    {"propersubset", 12, 61644},
    {"propersuperset", 14, 61641},
    {"proportional", 12, 61621},
    {"psi", 3, 61561},
    {"question", 8, 61503},
    {"radical", 7, 61654},
    {"radicalex", 9, 61536},
    {"reflexsubset", 12, 61645},
    {"reflexsuperset", 14, 61642},
    {"registersans", 12, 61666},
    {"registerserif", 13, 61650},
    {"rho", 3, 61554},
    {"second", 6, 61618},
    {"semicolon", 9, 61499},
    {"seven", 5, 61495},
    {"sigma", 5, 61555},
    {"sigma1", 6, 61526},
    {"similar", 7, 61566},
    {"six", 3, 61494},
    {"slash", 5, 61487},
    {"space", 5, 32},
    {"spade", 5, 61610},
    {"suchthat", 8, 61479},
    {"summation", 9, 61669},
    {"tau", 3, 61556},
    {"therefore", 9, 61532},
    {"theta", 5, 61553},
    {"theta1", 6, 61514},
    {"three", 5, 61491},
    {"trademarksans", 13, 61668},
    {"trademarkserif", 14, 61652},
    {"two", 3, 61490},
    {"underscore", 10, 61535},
    {"union", 5, 61640},
    {"universal", 9, 61474},
    {"upsilon", 7, 61557},
    {"weierstrass", 11, 61635},
    {"xi", 2, 61560},
    {"zero", 4, 61488},
    {"zeta", 4, 61562},
  }
};
static const pdfi_font_decoding_t FCO_Unicode = {
  "FCO_Unicode",
  11,
  3375,
  {
    {".null", 5, 0},
    {"0.0", 3, 3584},
    {"0script", 7, 8500},
    {"250a", 4, 9482},
    {"250b", 4, 9483},
    {"250c", 4, 9484},
    {"250d", 4, 9485},
    {"250e", 4, 9486},
    {"250f", 4, 9487},
    {"251a", 4, 9498},
    {"251b", 4, 9499},
    {"251c", 4, 9500},
    {"251d", 4, 9501},
    {"251e", 4, 9502},
    {"251f", 4, 9503},
    {"252a", 4, 9514},
    {"252b", 4, 9515},
    {"252c", 4, 9516},
    {"252d", 4, 9517},
    {"252e", 4, 9518},
    {"252f", 4, 9519},
    {"253a", 4, 9530},
    {"253b", 4, 9531},
    {"253c", 4, 9532},
    {"253d", 4, 9533},
    {"253e", 4, 9534},
    {"253f", 4, 9535},
    {"254a", 4, 9546},
    {"254b", 4, 9547},
    {"254c", 4, 9548},
    {"254d", 4, 9549},
    {"254e", 4, 9550},
    {"254f", 4, 9551},
    {"255a", 4, 9562},
    {"255b", 4, 9563},
    {"255c", 4, 9564},
    {"255d", 4, 9565},
    {"255e", 4, 9566},
    {"255f", 4, 9567},
    {"256a", 4, 9578},
    {"256b", 4, 9579},
    {"256c", 4, 9580},
    {"256d", 4, 9581},
    {"256e", 4, 9582},
    {"256f", 4, 9583},
    {"257a", 4, 9594},
    {"257b", 4, 9595},
    {"257c", 4, 9596},
    {"257d", 4, 9597},
    {"257e", 4, 9598},
    {"257f", 4, 9599},
    {"2bar", 4, 411},
    {"A", 1, 65},
    {"ACK", 3, 6},
    {"AE", 2, 198},
    {"AEacute", 7, 508},
    {"AEmacron", 8, 482},
    {"AEsmall", 7, 63462},
    {"Aacute", 6, 193},
    {"Aacutering", 10, 474},
    {"Aacutesmall", 11, 63457},
    {"Abreve", 6, 258},
    {"Acircumflex", 11, 194},
    {"Acircumflexsmall", 16, 63458},
    {"Acute", 5, 63177},
    {"Acutesmall", 10, 63412},
    {"Acyril", 6, 1040},
    {"Adieresis", 9, 196},
    {"Adieresismacron", 15, 478},
    {"Adieresissmall", 14, 63460},
    {"Adotmacron", 10, 480},
    {"Agrave", 6, 192},
    {"Agravesmall", 11, 63456},
    {"Ahacek", 6, 429},
    {"Alpha", 5, 913},
    {"Alphatonos", 10, 902},
    {"Amacron", 7, 256},
    {"Aogonek", 7, 260},
    {"Aring", 5, 197},
    {"Aringacute", 10, 506},
    {"Aringsmall", 10, 63461},
    {"Asmall", 6, 63329},
    {"Atilde", 6, 195},
    {"Atildesmall", 11, 63459},
    {"B", 1, 66},
    {"BEL", 3, 7},
    {"BS", 2, 8},
    {"Be", 2, 1041},
    {"Beta", 4, 914},
    {"Bhook", 5, 385},
    {"Brevesmall", 10, 63220},
    {"Bscript", 7, 8492},
    {"Bsmall", 6, 63330},
    {"Bsmallcap", 9, 553},
    {"Btopbar", 7, 386},
    {"C", 1, 67},
    {"CAN", 3, 24},
    {"CL", 2, 8452},
    {"CR", 2, 13},
    {"Cacute", 6, 262},
    {"Caron", 5, 63178},
    {"Caronsmall", 10, 63221},
    {"Cbb", 3, 8450},
    {"Cblackletter", 12, 8493},
    {"Ccaron", 6, 268},
    {"Ccedilla", 8, 199},
    {"Ccedillasmall", 13, 63463},
    {"Ccircumflex", 11, 264},
    {"Cdblstruck", 10, 8450},
    {"Cdot", 4, 266},
    {"Cdotaccent", 10, 266},
    {"Cedillasmall", 12, 63416},
    {"Cfractur", 8, 8493},
    {"Cfraktur", 8, 8493},
    {"Che", 3, 1063},
    {"Chertdes", 8, 1010},
    {"Chevertbar", 10, 1012},
    {"Chi", 3, 935},
    {"Chook", 5, 391},
    {"Circumflexsmall", 15, 63222},
    {"Colonmonetary", 13, 8353},
    {"Csmall", 6, 63331},
    {"D", 1, 68},
    {"DC0", 3, 16},
    {"DC1", 3, 17},
    {"DC2", 3, 18},
    {"DC3", 3, 19},
    {"DC4", 3, 20},
    {"DEL", 3, 127},
    {"DLE", 3, 16},
    {"DZ", 2, 497},
    {"DZhacek", 7, 420},
    {"Dbar", 4, 240},
    {"Dbar1", 5, 361},
    {"Dcaron", 6, 270},
    {"Dcaron1", 7, 63504},
    {"Dcroat", 6, 272},
    {"De", 2, 1044},
    {"Dei", 3, 823},
    {"Delta", 5, 916},
    {"Dhook", 5, 394},
    {"Dieresis", 8, 63179},
    {"DieresisAcute", 13, 63180},
    {"DieresisGrave", 13, 63181},
    {"Dieresissmall", 13, 63400},
    {"Digamma", 7, 805},
    {"Dje", 3, 1026},
    {"Dmacron", 7, 240},
    {"Dotaccentsmall", 14, 63223},
    {"Dslash", 6, 272},
    {"Dsmall", 6, 63332},
    {"Dtopbar", 7, 395},
    {"Dz", 2, 498},
    {"Dze", 3, 1029},
    {"Dzhacek", 7, 421},
    {"Dzhe", 4, 1039},
    {"E", 1, 69},
    {"EM", 2, 25},
    {"ENQ", 3, 5},
    {"EOF", 3, 26},
    {"EOT", 3, 4},
    {"ESC", 3, 27},
    {"ETB", 3, 23},
    {"ETX", 3, 3},
    {"Eacute", 6, 201},
    {"Eacutesmall", 11, 63465},
    {"Ebreve", 6, 276},
    {"Ecaron", 6, 282},
    {"Ecircumflex", 11, 202},
    {"Ecircumflexsmall", 16, 63466},
    {"Ecyril", 6, 1028},
    {"Ecyrilrev", 9, 1069},
    {"Edieresis", 9, 203},
    {"Edieresissmall", 14, 63467},
    {"Edot", 4, 278},
    {"Edotaccent", 10, 278},
    {"Ef", 2, 1060},
    {"Egrave", 6, 200},
    {"Egravesmall", 11, 63464},
    {"El", 2, 1051},
    {"Em", 2, 1052},
    {"Emacron", 7, 274},
    {"En", 2, 1053},
    {"EnGe", 4, 992},
    {"Eng", 3, 330},
    {"Enrtdes", 7, 990},
    {"Eogonek", 7, 280},
    {"Epsilon", 7, 917},
    {"Epsilon1", 8, 368},
    {"Epsilontonos", 12, 904},
    {"Er", 2, 1056},
    {"Es", 2, 1057},
    {"Escedilla", 9, 998},
    {"Escript", 7, 8496},
    {"Esh", 3, 425},
    {"Esmall", 6, 63333},
    {"Eta", 3, 919},
    {"Etatonos", 8, 905},
    {"Eth", 3, 208},
    {"Ethsmall", 8, 63472},
    {"Eturn", 5, 366},
    {"Euler", 5, 8455},
    {"Euro", 4, 8364},
    {"F", 1, 70},
    {"FF", 2, 12},
    {"FS", 2, 28},
    {"Fhook", 5, 401},
    {"Fscript", 7, 8497},
    {"Fsmall", 6, 63334},
    {"Fturn", 5, 8498},
    {"G", 1, 71},
    {"GA010000", 8, 762},
    {"GA020000", 8, 730},
    {"GB010000", 8, 763},
    {"GB020000", 8, 731},
    {"GD010000", 8, 765},
    {"GD020000", 8, 733},
    {"GE010000", 8, 766},
    {"GE020000", 8, 734},
    {"GF010000", 8, 783},
    {"GF020000", 8, 751},
    {"GG010000", 8, 764},
    {"GG020000", 8, 732},
    {"GO310000", 8, 786},
    {"GO320000", 8, 754},
    {"GP010000", 8, 777},
    {"GP020000", 8, 745},
    {"GS", 2, 29},
    {"GS010000", 8, 780},
    {"GS020000", 8, 748},
    {"GT010000", 8, 781},
    {"GT020000", 8, 749},
    {"GT610000", 8, 769},
    {"GT620000", 8, 737},
    {"Gacute", 6, 500},
    {"Gamma", 5, 915},
    {"Gamma1", 6, 372},
    {"Gbar", 4, 452},
    {"Gbreve", 6, 286},
    {"Gcaron", 6, 486},
    {"Gcedilla", 8, 290},
    {"Gcircumflex", 11, 284},
    {"Gcommaaccent", 12, 290},
    {"Gdot", 4, 288},
    {"Gdotaccent", 10, 288},
    {"Ge", 2, 1043},
    {"GeKarev", 7, 988},
    {"Gebar", 5, 974},
    {"Gehook", 6, 976},
    {"Geupturn", 8, 1168},
    {"Ghacek", 6, 454},
    {"Ghook", 5, 403},
    {"Gje", 3, 1027},
    {"Grave", 5, 63182},
    {"Gravesmall", 10, 63328},
    {"Gsmall", 6, 63335},
    {"Gsmallcap", 9, 498},
    {"Gsmallcaphook", 13, 555},
    {"H", 1, 72},
    {"H18533", 6, 9679},
    {"H18543", 6, 9642},
    {"H18551", 6, 9643},
    {"H22073", 6, 9633},
    {"HT", 2, 9},
    {"Hard", 4, 1066},
    {"Hbar", 4, 294},
    {"Hbb", 3, 8461},
    {"Hblackletter", 12, 8460},
    {"Hcircumflex", 11, 292},
    {"Hcyril", 6, 1014},
    {"Hdblstruck", 10, 8461},
    {"Hfractur", 8, 8460},
    {"Hfraktur", 8, 8460},
    {"Hmacron", 7, 262},
    {"Hscript", 7, 8459},
    {"Hsmall", 6, 63336},
    {"Hsmallcap", 9, 556},
    {"Hungarumlaut", 12, 63183},
    {"Hungarumlautsmall", 17, 63224},
    {"I", 1, 73},
    {"IFS", 3, 28},
    {"IGS", 3, 29},
    {"IJ", 2, 306},
    {"IRS", 3, 30},
    {"IUS", 3, 31},
    {"Ia", 2, 1071},
    {"Iacute", 6, 205},
    {"Iacutesmall", 11, 63469},
    {"Ibar", 4, 375},
    {"Iblackletter", 12, 8465},
    {"Ibreve", 6, 300},
    {"Icircumflex", 11, 206},
    {"Icircumflexsmall", 16, 63470},
    {"Icyril", 6, 1030},
    {"Icyril1", 7, 1020},
    {"Idieresis", 9, 207},
    {"Idieresissmall", 14, 63471},
    {"Idot", 4, 304},
    {"Idotaccent", 10, 304},
    {"Ie", 2, 1045},
    {"Iehook", 6, 1016},
    {"Iehookogonek", 12, 1018},
    {"Ifractur", 8, 8465},
    {"Ifraktur", 8, 8465},
    {"Igrave", 6, 204},
    {"Igravesmall", 11, 63468},
    {"Ihacek", 6, 431},
    {"Ii", 2, 1048},
    {"Iibreve", 7, 1049},
    {"Imacron", 7, 298},
    {"Inodot", 6, 73},
    {"Io", 2, 1025},
    {"Iogonek", 7, 302},
    {"Iota", 4, 921},
    {"Iota1", 5, 374},
    {"Iotadiaeresis", 13, 755},
    {"Iotadieresis", 12, 938},
    {"Iotatonos", 9, 906},
    {"Iscript", 7, 8464},
    {"Ismall", 6, 63337},
    {"Ismallcap", 9, 506},
    {"Itilde", 6, 296},
    {"Iu", 2, 1070},
    {"J", 1, 74},
    {"Jcircumflex", 11, 308},
    {"Je", 2, 1032},
    {"Jsmall", 6, 63338},
    {"K", 1, 75},
    {"Ka", 2, 1050},
    {"Kabar", 5, 986},
    {"Kahook", 6, 1023},
    {"Kappa", 5, 922},
    {"Kartdes", 7, 982},
    {"Kavertbar", 9, 984},
    {"Kcedilla", 8, 310},
    {"Kcedilla1", 9, 63512},
    {"Kcommaaccent", 12, 310},
    {"Kha", 3, 1061},
    {"Khacek", 6, 456},
    {"Khartdes", 8, 1006},
    {"Khook", 5, 408},
    {"Kje", 3, 1036},
    {"Koppa", 5, 807},
    {"Ksmall", 6, 63339},
    {"L", 1, 76},
    {"LA010000", 8, 97},
    {"LA020000", 8, 65},
    {"LA110000", 8, 193},
    {"LA120000", 8, 161},
    {"LA130000", 8, 192},
    {"LA140000", 8, 160},
    {"LA150000", 8, 194},
    {"LA160000", 8, 162},
    {"LA170000", 8, 196},
    {"LA180000", 8, 164},
    {"LA190000", 8, 195},
    {"LA200000", 8, 163},
    {"LA230000", 8, 227},
    {"LA240000", 8, 226},
    {"LA270000", 8, 197},
    {"LA280000", 8, 165},
    {"LA430000", 8, 229},
    {"LA440000", 8, 228},
    {"LA510000", 8, 198},
    {"LA520000", 8, 166},
    {"LA610000", 8, 225},
    {"LA620000", 8, 224},
    {"LB010000", 8, 98},
    {"LB020000", 8, 66},
    {"LC010000", 8, 99},
    {"LC020000", 8, 67},
    {"LC110000", 8, 231},
    {"LC120000", 8, 230},
    {"LC150000", 8, 233},
    {"LC160000", 8, 232},
    {"LC210000", 8, 237},
    {"LC220000", 8, 236},
    {"LC290000", 8, 235},
    {"LC300000", 8, 234},
    {"LC410000", 8, 199},
    {"LC420000", 8, 167},
    {"LD010000", 8, 100},
    {"LD020000", 8, 68},
    {"LD210000", 8, 239},
    {"LD220000", 8, 238},
    {"LD610000", 8, 241},
    {"LD620000", 8, 240},
    {"LD630000", 8, 208},
    {"LE010000", 8, 101},
    {"LE020000", 8, 69},
    {"LE110000", 8, 201},
    {"LE120000", 8, 169},
    {"LE130000", 8, 200},
    {"LE140000", 8, 168},
    {"LE150000", 8, 202},
    {"LE160000", 8, 170},
    {"LE170000", 8, 203},
    {"LE180000", 8, 171},
    {"LE210000", 8, 251},
    {"LE220000", 8, 250},
    {"LE230000", 8, 245},
    {"LE240000", 8, 244},
    {"LE290000", 8, 247},
    {"LE300000", 8, 246},
    {"LE430000", 8, 249},
    {"LE440000", 8, 248},
    {"LE610000", 8, 243},
    {"LE620000", 8, 242},
    {"LF", 2, 10},
    {"LF010000", 8, 102},
    {"LF020000", 8, 70},
    {"LG010000", 8, 103},
    {"LG020000", 8, 71},
    {"LG110000", 8, 259},
    {"LG150000", 8, 253},
    {"LG160000", 8, 252},
    {"LG230000", 8, 255},
    {"LG240000", 8, 254},
    {"LG290000", 8, 257},
    {"LG300000", 8, 256},
    {"LG420000", 8, 258},
    {"LH010000", 8, 104},
    {"LH020000", 8, 72},
    {"LH150000", 8, 261},
    {"LH160000", 8, 260},
    {"LH610000", 8, 263},
    {"LH620000", 8, 262},
    {"LI010000", 8, 105},
    {"LI020000", 8, 73},
    {"LI110000", 8, 205},
    {"LI120000", 8, 173},
    {"LI130000", 8, 204},
    {"LI140000", 8, 172},
    {"LI150000", 8, 206},
    {"LI160000", 8, 174},
    {"LI170000", 8, 207},
    {"LI180000", 8, 175},
    {"LI190000", 8, 265},
    {"LI200000", 8, 264},
    {"LI230000", 8, 269},
    {"LI240000", 8, 268},
    {"LI300000", 8, 272},
    {"LI430000", 8, 271},
    {"LI440000", 8, 270},
    {"LI610000", 8, 273},
    {"LI620000", 8, 266},
    {"LJ", 2, 455},
    {"LJ010000", 8, 106},
    {"LJ020000", 8, 74},
    {"LJ150000", 8, 277},
    {"LJ160000", 8, 276},
    {"LK010000", 8, 107},
    {"LK020000", 8, 75},
    {"LK410000", 8, 279},
    {"LK420000", 8, 278},
    {"LL", 2, 63167},
    {"LL010000", 8, 108},
    {"LL020000", 8, 76},
    {"LL110000", 8, 282},
    {"LL120000", 8, 281},
    {"LL210000", 8, 286},
    {"LL220000", 8, 285},
    {"LL410000", 8, 284},
    {"LL420000", 8, 283},
    {"LL610000", 8, 290},
    {"LL620000", 8, 289},
    {"LL630000", 8, 288},
    {"LL640000", 8, 287},
    {"LM010000", 8, 109},
    {"LM020000", 8, 77},
    {"LN010000", 8, 110},
    {"LN011000", 8, 8319},
    {"LN020000", 8, 78},
    {"LN110000", 8, 292},
    {"LN120000", 8, 291},
    {"LN190000", 8, 209},
    {"LN200000", 8, 177},
    {"LN210000", 8, 296},
    {"LN220000", 8, 295},
    {"LN410000", 8, 294},
    {"LN420000", 8, 293},
    {"LO010000", 8, 111},
    {"LO020000", 8, 79},
    {"LO110000", 8, 211},
    {"LO120000", 8, 179},
    {"LO130000", 8, 210},
    {"LO140000", 8, 178},
    {"LO150000", 8, 212},
    {"LO160000", 8, 180},
    {"LO170000", 8, 214},
    {"LO180000", 8, 182},
    {"LO190000", 8, 213},
    {"LO200000", 8, 181},
    {"LO230000", 8, 303},
    {"LO240000", 8, 302},
    {"LO250000", 8, 305},
    {"LO260000", 8, 304},
    {"LO510000", 8, 307},
    {"LO520000", 8, 306},
    {"LO610000", 8, 301},
    {"LO620000", 8, 300},
    {"LP010000", 8, 112},
    {"LP020000", 8, 80},
    {"LQ010000", 8, 113},
    {"LQ020000", 8, 81},
    {"LR010000", 8, 114},
    {"LR020000", 8, 82},
    {"LR110000", 8, 309},
    {"LR120000", 8, 308},
    {"LR210000", 8, 313},
    {"LR220000", 8, 312},
    {"LR410000", 8, 311},
    {"LR420000", 8, 310},
    {"LS010000", 8, 115},
    {"LS020000", 8, 83},
    {"LS110000", 8, 315},
    {"LS120000", 8, 314},
    {"LS150000", 8, 317},
    {"LS160000", 8, 316},
    {"LS210000", 8, 321},
    {"LS220000", 8, 320},
    {"LS410000", 8, 319},
    {"LS420000", 8, 318},
    {"LS610000", 8, 191},
    {"LT010000", 8, 116},
    {"LT020000", 8, 84},
    {"LT210000", 8, 325},
    {"LT220000", 8, 324},
    {"LT410000", 8, 323},
    {"LT420000", 8, 322},
    {"LT610000", 8, 327},
    {"LT620000", 8, 326},
    {"LT630000", 8, 222},
    {"LT640000", 8, 190},
    {"LU010000", 8, 117},
    {"LU020000", 8, 85},
    {"LU110000", 8, 218},
    {"LU120000", 8, 186},
    {"LU130000", 8, 217},
    {"LU140000", 8, 185},
    {"LU150000", 8, 219},
    {"LU160000", 8, 187},
    {"LU170000", 8, 220},
    {"LU180000", 8, 188},
    {"LU190000", 8, 329},
    {"LU200000", 8, 328},
    {"LU230000", 8, 333},
    {"LU240000", 8, 332},
    {"LU250000", 8, 337},
    {"LU260000", 8, 336},
    {"LU270000", 8, 335},
    {"LU280000", 8, 334},
    {"LU430000", 8, 339},
    {"LU440000", 8, 338},
    {"LU610000", 8, 331},
    {"LU620000", 8, 330},
    {"LV010000", 8, 118},
    {"LV020000", 8, 86},
    {"LW010000", 8, 119},
    {"LW020000", 8, 87},
    {"LW150000", 8, 341},
    {"LW160000", 8, 340},
    {"LX010000", 8, 120},
    {"LX020000", 8, 88},
    {"LY010000", 8, 121},
    {"LY020000", 8, 89},
    {"LY110000", 8, 221},
    {"LY120000", 8, 189},
    {"LY150000", 8, 343},
    {"LY160000", 8, 342},
    {"LY170000", 8, 223},
    {"LY180000", 8, 344},
    {"LZ010000", 8, 122},
    {"LZ020000", 8, 90},
    {"LZ110000", 8, 346},
    {"LZ120000", 8, 345},
    {"LZ210000", 8, 350},
    {"LZ220000", 8, 349},
    {"LZ290000", 8, 348},
    {"LZ300000", 8, 347},
    {"Lacute", 6, 313},
    {"Lambda", 6, 923},
    {"Lcaron", 6, 317},
    {"Lcaron1", 7, 63506},
    {"Lcedilla", 8, 315},
    {"Lcedilla1", 9, 63514},
    {"Lcircumflex", 11, 1205},
    {"Lcommaaccent", 12, 315},
    {"Ldot", 4, 319},
    {"Ldotaccent", 10, 319},
    {"Lj", 2, 456},
    {"Lje", 3, 1033},
    {"Lscript", 7, 8466},
    {"Lslash", 6, 321},
    {"Lslashsmall", 11, 63225},
    {"Lsmall", 6, 63340},
    {"Lsmallcap", 9, 559},
    {"M", 1, 77},
    {"Macron", 6, 63184},
    {"Macronsmall", 11, 63407},
    {"Mscript", 7, 8499},
    {"Msmall", 6, 63341},
    {"Mu", 2, 924},
    {"N", 1, 78},
    {"NAK", 3, 21},
    {"ND010000", 8, 49},
    {"ND011000", 8, 153},
    {"ND020000", 8, 50},
    {"ND021000", 8, 146},
    {"ND030000", 8, 51},
    {"ND031000", 8, 147},
    {"ND040000", 8, 52},
    {"ND050000", 8, 53},
    {"ND060000", 8, 54},
    {"ND070000", 8, 55},
    {"ND080000", 8, 56},
    {"ND090000", 8, 57},
    {"ND100000", 8, 48},
    {"NF010000", 8, 157},
    {"NF040000", 8, 156},
    {"NF050000", 8, 158},
    {"NJ", 2, 458},
    {"NUL", 3, 0},
    {"Nacute", 6, 323},
    {"Nbb", 3, 8469},
    {"Ncaron", 6, 327},
    {"Ncedilla", 8, 325},
    {"Ncedilla1", 9, 63516},
    {"Ncommaaccent", 12, 325},
    {"Ndblstruck", 10, 8469},
    {"Nhook", 5, 381},
    {"Nj", 2, 459},
    {"Nje", 3, 1034},
    {"Nsmall", 6, 63342},
    {"Nsmallcap", 9, 516},
    {"Ntilde", 6, 209},
    {"Ntildesmall", 11, 63473},
    {"Nu", 2, 925},
    {"O", 1, 79},
    {"OE", 2, 338},
    {"OEsmall", 7, 63226},
    {"OEsmallcap", 10, 518},
    {"OI", 2, 386},
    {"Oacute", 6, 211},
    {"Oacutesmall", 11, 63475},
    {"Obar", 4, 383},
    {"Obreve", 6, 334},
    {"Ocircumflex", 11, 212},
    {"Ocircumflexsmall", 16, 63476},
    {"Ocyril", 6, 1054},
    {"Odblacute", 9, 336},
    {"Odieresis", 9, 214},
    {"Odieresissmall", 14, 63478},
    {"Ogoneksmall", 11, 63227},
    {"Ograve", 6, 210},
    {"Ogravesmall", 11, 63474},
    {"Ohacek", 6, 433},
    {"Ohook", 5, 996},
    {"Ohorn", 5, 416},
    {"Ohungarumlaut", 13, 336},
    {"Omacron", 7, 332},
    {"Omega", 5, 937},
    {"Omegainv", 8, 8487},
    {"Omegatonos", 10, 911},
    {"Omicron", 7, 927},
    {"Omicrontonos", 12, 908},
    {"Oogonek", 7, 490},
    {"Oogonekmacron", 13, 492},
    {"Oopen", 5, 390},
    {"Oslash", 6, 216},
    {"Oslashacute", 11, 510},
    {"Oslashsmall", 11, 63480},
    {"Osmall", 6, 63343},
    {"Otilde", 6, 213},
    {"Otildesmall", 11, 63477},
    {"P", 1, 80},
    {"Pbb", 3, 8473},
    {"Pdblstruck", 10, 8473},
    {"Pecyril", 7, 1055},
    {"Pehook", 6, 994},
    {"Phi", 3, 934},
    {"Phook", 5, 420},
    {"Pi", 2, 928},
    {"Pscript", 7, 8472},
    {"Psi", 3, 936},
    {"Psmall", 6, 63344},
    {"Pts", 3, 8359},
    {"Q", 1, 81},
    {"Qbb", 3, 8474},
    {"Qdblstruck", 10, 8474},
    {"Qsmall", 6, 63345},
    {"R", 1, 82},
    {"RS", 2, 30},
    {"Racute", 6, 340},
    {"Rbb", 3, 8477},
    {"Rblackletter", 12, 8476},
    {"Rcaron", 6, 344},
    {"Rcedilla", 8, 342},
    {"Rcedilla1", 9, 63518},
    {"Rcircumflex", 11, 63537},
    {"Rcommaaccent", 12, 342},
    {"Rdblstruck", 10, 8477},
    {"Rfractur", 8, 8476},
    {"Rfraktur", 8, 8476},
    {"Rho", 3, 929},
    {"Ringsmall", 9, 63228},
    {"Rscript", 7, 8475},
    {"Rsmall", 6, 63346},
    {"Rsmallcap", 9, 528},
    {"Rsmallcapinv", 12, 529},
    {"Rturnsuper", 10, 575},
    {"Rx", 2, 8478},
    {"S", 1, 83},
    {"SA010000", 8, 43},
    {"SA020000", 8, 145},
    {"SA030000", 8, 60},
    {"SA040000", 8, 61},
    {"SA050000", 8, 62},
    {"SA060000", 8, 215},
    {"SA070000", 8, 183},
    {"SA660000", 8, 9674},
    {"SC010000", 8, 132},
    {"SC020000", 8, 131},
    {"SC030000", 8, 36},
    {"SC040000", 8, 130},
    {"SC050000", 8, 133},
    {"SC060000", 8, 8359},
    {"SC070000", 8, 370},
    {"SD110000", 8, 148},
    {"SD130000", 8, 96},
    {"SD150000", 8, 94},
    {"SD150100", 8, 591},
    {"SD170000", 8, 136},
    {"SD190000", 8, 126},
    {"SD190100", 8, 613},
    {"SD210000", 8, 592},
    {"SD230000", 8, 609},
    {"SD250000", 8, 614},
    {"SD270000", 8, 611},
    {"SD290000", 8, 610},
    {"SD310000", 8, 594},
    {"SD410000", 8, 152},
    {"SD430000", 8, 612},
    {"SD630000", 8, 151},
    {"SF010000", 8, 9484},
    {"SF020000", 8, 9492},
    {"SF030000", 8, 9488},
    {"SF040000", 8, 9496},
    {"SF050000", 8, 9532},
    {"SF060000", 8, 9516},
    {"SF070000", 8, 9524},
    {"SF080000", 8, 9500},
    {"SF090000", 8, 9508},
    {"SF100000", 8, 9472},
    {"SF110000", 8, 9474},
    {"SF140000", 8, 9617},
    {"SF150000", 8, 9618},
    {"SF160000", 8, 9619},
    {"SF190000", 8, 9569},
    {"SF200000", 8, 9570},
    {"SF210000", 8, 9558},
    {"SF220000", 8, 9557},
    {"SF230000", 8, 9571},
    {"SF240000", 8, 9553},
    {"SF250000", 8, 9559},
    {"SF260000", 8, 9565},
    {"SF270000", 8, 9564},
    {"SF280000", 8, 9563},
    {"SF360000", 8, 9566},
    {"SF370000", 8, 9567},
    {"SF380000", 8, 9562},
    {"SF390000", 8, 9556},
    {"SF400000", 8, 9577},
    {"SF410000", 8, 9574},
    {"SF420000", 8, 9568},
    {"SF430000", 8, 9552},
    {"SF440000", 8, 9580},
    {"SF450000", 8, 9575},
    {"SF460000", 8, 9576},
    {"SF470000", 8, 9572},
    {"SF480000", 8, 9573},
    {"SF490000", 8, 9561},
    {"SF500000", 8, 9560},
    {"SF510000", 8, 9554},
    {"SF520000", 8, 9555},
    {"SF530000", 8, 9579},
    {"SF540000", 8, 9578},
    {"SF570000", 8, 9604},
    {"SF580000", 8, 9612},
    {"SF590000", 8, 9616},
    {"SF600000", 8, 9600},
    {"SF610000", 8, 9608},
    {"SI", 2, 15},
    {"SM010000", 8, 35},
    {"SM020000", 8, 37},
    {"SM030000", 8, 38},
    {"SM040000", 8, 42},
    {"SM050000", 8, 64},
    {"SM060000", 8, 91},
    {"SM070000", 8, 92},
    {"SM080000", 8, 93},
    {"SM100000", 8, 8215},
    {"SM110000", 8, 123},
    {"SM130000", 8, 124},
    {"SM140000", 8, 125},
    {"SM150000", 8, 143},
    {"SM170000", 8, 149},
    {"SM190000", 8, 144},
    {"SM200000", 8, 154},
    {"SM210000", 8, 138},
    {"SM240000", 8, 135},
    {"SM250000", 8, 150},
    {"SM280000", 8, 9794},
    {"SM290000", 8, 9792},
    {"SM300000", 8, 1401},
    {"SM310000", 8, 1403},
    {"SM320000", 8, 1402},
    {"SM330000", 8, 1404},
    {"SM340000", 8, 8224},
    {"SM350000", 8, 8225},
    {"SM470000", 8, 9632},
    {"SM520000", 8, 137},
    {"SM530000", 8, 142},
    {"SM540000", 8, 8482},
    {"SM560000", 8, 8240},
    {"SM570000", 8, 8226},
    {"SM570001", 8, 9688},
    {"SM580000", 8, 9679},
    {"SM590000", 8, 9658},
    {"SM600000", 8, 9650},
    {"SM630000", 8, 9668},
    {"SM650000", 8, 134},
    {"SM660000", 8, 140},
    {"SM690000", 8, 9788},
    {"SM700000", 8, 9644},
    {"SM750000", 8, 9675},
    {"SM750002", 8, 9689},
    {"SM760000", 8, 1406},
    {"SM770000", 8, 1425},
    {"SM780000", 8, 1405},
    {"SM790000", 8, 8962},
    {"SM900000", 8, 8212},
    {"SM910000", 8, 9835},
    {"SM930000", 8, 9834},
    {"SO", 2, 14},
    {"SOH", 3, 1},
    {"SP010000", 8, 32},
    {"SP020000", 8, 33},
    {"SP030000", 8, 129},
    {"SP040000", 8, 34},
    {"SP050000", 8, 39},
    {"SP060000", 8, 40},
    {"SP070000", 8, 41},
    {"SP080000", 8, 44},
    {"SP090000", 8, 95},
    {"SP100000", 8, 45},
    {"SP110000", 8, 46},
    {"SP120000", 8, 47},
    {"SP130000", 8, 58},
    {"SP140000", 8, 59},
    {"SP150000", 8, 63},
    {"SP160000", 8, 159},
    {"SP170000", 8, 139},
    {"SP180000", 8, 155},
    {"SP190000", 8, 8216},
    {"SP200000", 8, 8217},
    {"SP210000", 8, 8220},
    {"SP220000", 8, 8221},
    {"SP230000", 8, 8222},
    {"SP260000", 8, 8218},
    {"SP270000", 8, 8249},
    {"SP280000", 8, 8250},
    {"SP300000", 8, 128},
    {"SP320000", 8, 141},
    {"SP330000", 8, 8252},
    {"SS000000", 8, 9786},
    {"SS010000", 8, 9787},
    {"SS020000", 8, 9829},
    {"SS030000", 8, 9830},
    {"SS040000", 8, 9827},
    {"SS050000", 8, 9824},
    {"SS260000", 8, 8992},
    {"SS270000", 8, 8993},
    {"SS680000", 8, 8211},
    {"STX", 3, 2},
    {"SUB", 3, 26},
    {"SV040000", 8, 9660},
    {"SV520000", 8, 8230},
    {"SYN", 3, 22},
    {"Sacute", 6, 346},
    {"Sampi", 5, 809},
    {"Scaron", 6, 352},
    {"Scaronsmall", 11, 63229},
    {"Scedilla", 8, 350},
    {"Scedilla1", 9, 63510},
    {"Schwa", 5, 399},
    {"Scircumflex", 11, 348},
    {"Scommaaccent", 12, 536},
    {"Sha", 3, 1064},
    {"Shcha", 5, 1065},
    {"Sigma", 5, 931},
    {"Sinvlazy", 8, 8766},
    {"Soft", 4, 1068},
    {"Ssmall", 6, 63347},
    {"Stigma", 6, 803},
    {"T", 1, 84},
    {"Tau", 3, 932},
    {"Tbar", 4, 358},
    {"Tcaron", 6, 356},
    {"Tcaron1", 7, 63508},
    {"Tcedilla", 8, 354},
    {"Tcedilla1", 9, 63512},
    {"Tcommaaccent", 12, 354},
    {"Te", 2, 1058},
    {"TeTse", 5, 1008},
    {"Tertdes", 7, 1000},
    {"Theta", 5, 920},
    {"Thook", 5, 428},
    {"Thorn", 5, 222},
    {"Thornsmall", 10, 63486},
    {"Tildesmall", 10, 63230},
    {"Tmacron", 7, 326},
    {"Tonefive", 8, 444},
    {"Tonesix", 7, 388},
    {"Tonetwo", 7, 423},
    {"Trthook", 7, 398},
    {"Tse", 3, 1062},
    {"Tshe", 4, 1035},
    {"Tsmall", 6, 63348},
    {"U", 1, 85},
    {"US", 2, 31},
    {"Uacute", 6, 218},
    {"Uacutesmall", 11, 63482},
    {"Ubreve", 6, 364},
    {"Ucedilla", 8, 63539},
    {"Ucircumflex", 11, 219},
    {"Ucircumflexsmall", 16, 63483},
    {"Ucyril", 6, 1059},
    {"Ucyrilbreve", 11, 1038},
    {"Udblacute", 9, 368},
    {"Udieresis", 9, 220},
    {"Udieresisacute", 14, 471},
    {"Udieresisgrave", 14, 475},
    {"Udieresishacek", 14, 441},
    {"Udieresismacron", 15, 469},
    {"Udieresissmall", 14, 63484},
    {"Ugrave", 6, 217},
    {"Ugravesmall", 11, 63481},
    {"Uhacek", 6, 435},
    {"Uhorn", 5, 431},
    {"Uhungarumlaut", 13, 368},
    {"Umacron", 7, 362},
    {"Uogonek", 7, 370},
    {"Upsilon", 7, 933},
    {"Upsilon1", 8, 978},
    {"Upsilon1diaeresis", 17, 797},
    {"Upsilon1dieresis", 16, 797},
    {"Upsilon1tonos", 13, 796},
    {"Upsilon2", 8, 401},
    {"Upsilondiaeresis", 16, 756},
    {"Upsilondieresis", 15, 939},
    {"Upsilontonos", 12, 910},
    {"Uring", 5, 366},
    {"Usmall", 6, 63349},
    {"Ustrt", 5, 1002},
    {"Ustrtbar", 8, 1004},
    {"Utilde", 6, 360},
    {"V", 1, 86},
    {"VT", 2, 11},
    {"Vcursive", 8, 402},
    {"Ve", 2, 1042},
    {"Vsmall", 6, 63350},
    {"W", 1, 87},
    {"Wacute", 6, 7810},
    {"Wcircumflex", 11, 372},
    {"Wdieresis", 9, 7812},
    {"Wgrave", 6, 7808},
    {"Wsmall", 6, 63351},
    {"X", 1, 88},
    {"XOF", 3, 19},
    {"XON", 3, 17},
    {"Xi", 2, 926},
    {"Xsmall", 6, 63352},
    {"Y", 1, 89},
    {"YR", 2, 390},
    {"Yacute", 6, 221},
    {"Yacutesmall", 11, 63485},
    {"Yat", 3, 926},
    {"Ycircumflex", 11, 374},
    {"Ydieresis", 9, 376},
    {"Ydieresissmall", 14, 63487},
    {"Yeri", 4, 1067},
    {"Ygrave", 6, 7922},
    {"Yhook", 5, 435},
    {"Yi", 2, 1031},
    {"Yogh", 4, 407},
    {"Yoghhacek", 9, 462},
    {"Yoghrev", 7, 408},
    {"Ysmall", 6, 63353},
    {"Ysmallcap", 9, 543},
    {"Yusbig", 6, 934},
    {"Z", 1, 90},
    {"Zacute", 6, 377},
    {"Zbar", 4, 405},
    {"Zbb", 3, 8484},
    {"Zblackletter", 12, 8488},
    {"Zcaron", 6, 381},
    {"Zcaronsmall", 11, 63231},
    {"Zdblstruck", 10, 8484},
    {"Zdot", 4, 379},
    {"Zdotaccent", 10, 379},
    {"Ze", 2, 1047},
    {"Zecedilla", 9, 980},
    {"Zeta", 4, 918},
    {"Zfractur", 8, 8488},
    {"Zfraktur", 8, 8488},
    {"Zhe", 3, 1046},
    {"Zhebreve", 8, 1021},
    {"Zhertdes", 8, 978},
    {"Zsmall", 6, 63354},
    {"a", 1, 97},
    {"aacute", 6, 225},
    {"aacutering", 10, 475},
    {"abreve", 6, 259},
    {"accountof", 9, 8448},
    {"acircumflex", 11, 226},
    {"acknowledge", 11, 1439},
    {"acute", 5, 180},
    {"acute1", 6, 595},
    {"acutecomb", 9, 769},
    {"acutedblnosp", 12, 638},
    {"acutenosp", 9, 628},
    {"acuterightnosp", 14, 692},
    {"acutesub", 8, 600},
    {"acutesubnosp", 12, 650},
    {"acyril", 6, 1072},
    {"addresssubject", 14, 8449},
    {"adieresis", 9, 228},
    {"adieresismacron", 15, 479},
    {"adotmacron", 10, 481},
    {"ae", 2, 230},
    {"aeacute", 7, 509},
    {"aemacron", 8, 483},
    {"afii00208", 9, 8213},
    {"afii08941", 9, 8356},
    {"afii10017", 9, 1040},
    {"afii10018", 9, 1041},
    {"afii10019", 9, 1042},
    {"afii10020", 9, 1043},
    {"afii10021", 9, 1044},
    {"afii10022", 9, 1045},
    {"afii10023", 9, 1025},
    {"afii10024", 9, 1046},
    {"afii10025", 9, 1047},
    {"afii10026", 9, 1048},
    {"afii10027", 9, 1049},
    {"afii10028", 9, 1050},
    {"afii10029", 9, 1051},
    {"afii10030", 9, 1052},
    {"afii10031", 9, 1053},
    {"afii10032", 9, 1054},
    {"afii10033", 9, 1055},
    {"afii10034", 9, 1056},
    {"afii10035", 9, 1057},
    {"afii10036", 9, 1058},
    {"afii10037", 9, 1059},
    {"afii10038", 9, 1060},
    {"afii10039", 9, 1061},
    {"afii10040", 9, 1062},
    {"afii10041", 9, 1063},
    {"afii10042", 9, 1064},
    {"afii10043", 9, 1065},
    {"afii10044", 9, 1066},
    {"afii10045", 9, 1067},
    {"afii10046", 9, 1068},
    {"afii10047", 9, 1069},
    {"afii10048", 9, 1070},
    {"afii10049", 9, 1071},
    {"afii10050", 9, 1168},
    {"afii10051", 9, 1026},
    {"afii10052", 9, 1027},
    {"afii10053", 9, 1028},
    {"afii10054", 9, 1029},
    {"afii10055", 9, 1030},
    {"afii10056", 9, 1031},
    {"afii10057", 9, 1032},
    {"afii10058", 9, 1033},
    {"afii10059", 9, 1034},
    {"afii10060", 9, 1035},
    {"afii10061", 9, 1036},
    {"afii10062", 9, 1038},
    {"afii10063", 9, 63172},
    {"afii10064", 9, 63173},
    {"afii10065", 9, 1072},
    {"afii10066", 9, 1073},
    {"afii10067", 9, 1074},
    {"afii10068", 9, 1075},
    {"afii10069", 9, 1076},
    {"afii10070", 9, 1077},
    {"afii10071", 9, 1105},
    {"afii10072", 9, 1078},
    {"afii10073", 9, 1079},
    {"afii10074", 9, 1080},
    {"afii10075", 9, 1081},
    {"afii10076", 9, 1082},
    {"afii10077", 9, 1083},
    {"afii10078", 9, 1084},
    {"afii10079", 9, 1085},
    {"afii10080", 9, 1086},
    {"afii10081", 9, 1087},
    {"afii10082", 9, 1088},
    {"afii10083", 9, 1089},
    {"afii10084", 9, 1090},
    {"afii10085", 9, 1091},
    {"afii10086", 9, 1092},
    {"afii10087", 9, 1093},
    {"afii10088", 9, 1094},
    {"afii10089", 9, 1095},
    {"afii10090", 9, 1096},
    {"afii10091", 9, 1097},
    {"afii10092", 9, 1098},
    {"afii10093", 9, 1099},
    {"afii10094", 9, 1100},
    {"afii10095", 9, 1101},
    {"afii10096", 9, 1102},
    {"afii10097", 9, 1103},
    {"afii10098", 9, 1169},
    {"afii10099", 9, 1106},
    {"afii10100", 9, 1107},
    {"afii10101", 9, 1108},
    {"afii10102", 9, 1109},
    {"afii10103", 9, 1110},
    {"afii10104", 9, 1111},
    {"afii10105", 9, 1112},
    {"afii10106", 9, 1113},
    {"afii10107", 9, 1114},
    {"afii10108", 9, 1115},
    {"afii10109", 9, 1116},
    {"afii10110", 9, 1118},
    {"afii10145", 9, 1039},
    {"afii10146", 9, 1122},
    {"afii10147", 9, 1138},
    {"afii10148", 9, 1140},
    {"afii10190", 9, 1141},
    {"afii10192", 9, 63174},
    {"afii10193", 9, 1119},
    {"afii10194", 9, 1123},
    {"afii10195", 9, 1139},
    {"afii10196", 9, 1141},
    {"afii10831", 9, 63175},
    {"afii10832", 9, 63176},
    {"afii10846", 9, 1241},
    {"afii299", 7, 8206},
    {"afii300", 7, 8207},
    {"afii301", 7, 8205},
    {"afii57381", 9, 1642},
    {"afii57388", 9, 1548},
    {"afii57392", 9, 1632},
    {"afii57393", 9, 1633},
    {"afii57394", 9, 1634},
    {"afii57395", 9, 1635},
    {"afii57396", 9, 1636},
    {"afii57397", 9, 1637},
    {"afii57398", 9, 1638},
    {"afii57399", 9, 1639},
    {"afii57400", 9, 1640},
    {"afii57401", 9, 1641},
    {"afii57403", 9, 1563},
    {"afii57407", 9, 1567},
    {"afii57409", 9, 1569},
    {"afii57410", 9, 1570},
    {"afii57411", 9, 1571},
    {"afii57412", 9, 1572},
    {"afii57413", 9, 1573},
    {"afii57414", 9, 1574},
    {"afii57415", 9, 1575},
    {"afii57416", 9, 1576},
    {"afii57417", 9, 1577},
    {"afii57418", 9, 1578},
    {"afii57419", 9, 1579},
    {"afii57420", 9, 1580},
    {"afii57421", 9, 1581},
    {"afii57422", 9, 1582},
    {"afii57423", 9, 1583},
    {"afii57424", 9, 1584},
    {"afii57425", 9, 1585},
    {"afii57426", 9, 1586},
    {"afii57427", 9, 1587},
    {"afii57428", 9, 1588},
    {"afii57429", 9, 1589},
    {"afii57430", 9, 1590},
    {"afii57431", 9, 1591},
    {"afii57432", 9, 1592},
    {"afii57433", 9, 1593},
    {"afii57434", 9, 1594},
    {"afii57440", 9, 1600},
    {"afii57441", 9, 1601},
    {"afii57442", 9, 1602},
    {"afii57443", 9, 1603},
    {"afii57444", 9, 1604},
    {"afii57445", 9, 1605},
    {"afii57446", 9, 1606},
    {"afii57448", 9, 1608},
    {"afii57449", 9, 1609},
    {"afii57450", 9, 1610},
    {"afii57451", 9, 1611},
    {"afii57452", 9, 1612},
    {"afii57453", 9, 1613},
    {"afii57454", 9, 1614},
    {"afii57455", 9, 1615},
    {"afii57456", 9, 1616},
    {"afii57457", 9, 1617},
    {"afii57458", 9, 1618},
    {"afii57470", 9, 1607},
    {"afii57505", 9, 1700},
    {"afii57506", 9, 1662},
    {"afii57507", 9, 1670},
    {"afii57508", 9, 1688},
    {"afii57509", 9, 1711},
    {"afii57511", 9, 1657},
    {"afii57512", 9, 1672},
    {"afii57513", 9, 1681},
    {"afii57514", 9, 1722},
    {"afii57519", 9, 1746},
    {"afii57534", 9, 1749},
    {"afii57636", 9, 8362},
    {"afii57645", 9, 1470},
    {"afii57658", 9, 1475},
    {"afii57664", 9, 1488},
    {"afii57665", 9, 1489},
    {"afii57666", 9, 1490},
    {"afii57667", 9, 1491},
    {"afii57668", 9, 1492},
    {"afii57669", 9, 1493},
    {"afii57670", 9, 1494},
    {"afii57671", 9, 1495},
    {"afii57672", 9, 1496},
    {"afii57673", 9, 1497},
    {"afii57674", 9, 1498},
    {"afii57675", 9, 1499},
    {"afii57676", 9, 1500},
    {"afii57677", 9, 1501},
    {"afii57678", 9, 1502},
    {"afii57679", 9, 1503},
    {"afii57680", 9, 1504},
    {"afii57681", 9, 1505},
    {"afii57682", 9, 1506},
    {"afii57683", 9, 1507},
    {"afii57684", 9, 1508},
    {"afii57685", 9, 1509},
    {"afii57686", 9, 1510},
    {"afii57687", 9, 1511},
    {"afii57688", 9, 1512},
    {"afii57689", 9, 1513},
    {"afii57690", 9, 1514},
    {"afii57694", 9, 64298},
    {"afii57695", 9, 64299},
    {"afii57700", 9, 64331},
    {"afii57705", 9, 64287},
    {"afii57716", 9, 1520},
    {"afii57717", 9, 1521},
    {"afii57718", 9, 1522},
    {"afii57723", 9, 64309},
    {"afii57793", 9, 1460},
    {"afii57794", 9, 1461},
    {"afii57795", 9, 1462},
    {"afii57796", 9, 1467},
    {"afii57797", 9, 1464},
    {"afii57798", 9, 1463},
    {"afii57799", 9, 1456},
    {"afii57800", 9, 1458},
    {"afii57801", 9, 1457},
    {"afii57802", 9, 1459},
    {"afii57803", 9, 1474},
    {"afii57804", 9, 1473},
    {"afii57806", 9, 1465},
    {"afii57807", 9, 1468},
    {"afii57839", 9, 1469},
    {"afii57841", 9, 1471},
    {"afii57842", 9, 1472},
    {"afii57929", 9, 700},
    {"afii59681", 9, 3585},
    {"afii59682", 9, 3586},
    {"afii59683", 9, 3587},
    {"afii59684", 9, 3588},
    {"afii59685", 9, 3589},
    {"afii59686", 9, 3590},
    {"afii59687", 9, 3591},
    {"afii59688", 9, 3592},
    {"afii59689", 9, 3593},
    {"afii59690", 9, 3594},
    {"afii59691", 9, 3595},
    {"afii59692", 9, 3596},
    {"afii59693", 9, 3597},
    {"afii59694", 9, 3598},
    {"afii59695", 9, 3599},
    {"afii59696", 9, 3600},
    {"afii59697", 9, 3601},
    {"afii59698", 9, 3602},
    {"afii59699", 9, 3603},
    {"afii59700", 9, 3604},
    {"afii59701", 9, 3605},
    {"afii59702", 9, 3606},
    {"afii59703", 9, 3607},
    {"afii59704", 9, 3608},
    {"afii59705", 9, 3609},
    {"afii59706", 9, 3610},
    {"afii59707", 9, 3611},
    {"afii59708", 9, 3612},
    {"afii59709", 9, 3613},
    {"afii59710", 9, 3614},
    {"afii59711", 9, 3615},
    {"afii59712", 9, 3616},
    {"afii59713", 9, 3617},
    {"afii59714", 9, 3618},
    {"afii59715", 9, 3619},
    {"afii59716", 9, 3620},
    {"afii59717", 9, 3621},
    {"afii59718", 9, 3622},
    {"afii59719", 9, 3623},
    {"afii59720", 9, 3624},
    {"afii59721", 9, 3625},
    {"afii59722", 9, 3626},
    {"afii59723", 9, 3627},
    {"afii59724", 9, 3628},
    {"afii59725", 9, 3629},
    {"afii59726", 9, 3630},
    {"afii59727", 9, 3631},
    {"afii59728", 9, 3633},
    {"afii59729", 9, 3632},
    {"afii59730", 9, 3634},
    {"afii59731", 9, 3635},
    {"afii59732", 9, 3636},
    {"afii59733", 9, 3637},
    {"afii59734", 9, 3638},
    {"afii59735", 9, 3639},
    {"afii59736", 9, 3640},
    {"afii59737", 9, 3641},
    {"afii59738", 9, 3642},
    {"afii59743", 9, 3647},
    {"afii59744", 9, 3648},
    {"afii59745", 9, 3649},
    {"afii59746", 9, 3650},
    {"afii59747", 9, 3651},
    {"afii59748", 9, 3652},
    {"afii59749", 9, 3653},
    {"afii59750", 9, 3654},
    {"afii59751", 9, 3655},
    {"afii59752", 9, 3656},
    {"afii59753", 9, 3657},
    {"afii59754", 9, 3658},
    {"afii59755", 9, 3659},
    {"afii59756", 9, 3660},
    {"afii59757", 9, 3661},
    {"afii59758", 9, 3662},
    {"afii59759", 9, 3663},
    {"afii59760", 9, 3664},
    {"afii59761", 9, 3665},
    {"afii59762", 9, 3666},
    {"afii59763", 9, 3667},
    {"afii59764", 9, 3668},
    {"afii59765", 9, 3669},
    {"afii59766", 9, 3670},
    {"afii59767", 9, 3671},
    {"afii59768", 9, 3672},
    {"afii59769", 9, 3673},
    {"afii59770", 9, 3674},
    {"afii59771", 9, 3675},
    {"afii61248", 9, 8453},
    {"afii61289", 9, 8467},
    {"afii61352", 9, 8470},
    {"afii61573", 9, 8236},
    {"afii61574", 9, 8237},
    {"afii61575", 9, 8238},
    {"afii61664", 9, 8204},
    {"afii63167", 9, 1645},
    {"afii64937", 9, 701},
    {"agrave", 6, 224},
    {"ahacek", 6, 430},
    {"ain", 3, 1593},
    {"ainfinal", 8, 65226},
    {"aininitial", 10, 65227},
    {"ainisolated", 11, 65225},
    {"ainmedial", 9, 65228},
    {"alef", 4, 1488},
    {"aleffinal", 9, 65166},
    {"alefisolated", 12, 65165},
    {"aleflamed", 9, 64335},
    {"alefmaksura", 11, 1609},
    {"alefmaksurafinal", 16, 65264},
    {"alefmaksuraisolated", 19, 65263},
    {"alefwasla", 9, 1649},
    {"alefwaslafinal", 14, 64337},
    {"alefwaslaisolated", 17, 64336},
    {"alefwithfathatanfinal", 21, 64828},
    {"alefwithfathatanisolated", 24, 64829},
    {"alefwithhamzaabove", 18, 1571},
    {"alefwithhamzaabovefinal", 23, 65156},
    {"alefwithhamzaaboveisolated", 26, 65155},
    {"alefwithhamzabelow", 18, 1573},
    {"alefwithhamzabelowfinal", 23, 65160},
    {"alefwithhamzabelowisolated", 26, 65159},
    {"alefwithmaddaabove", 18, 1570},
    {"alefwithmaddaabovefinal", 23, 65154},
    {"alefwithmaddaaboveisolated", 26, 65153},
    {"alefwithmapiq", 13, 64304},
    {"alefwithpatah", 13, 64302},
    {"alefwithqamats", 14, 64303},
    {"aleph", 5, 8501},
    {"alephmath", 9, 8501},
    {"allahisolated", 13, 65010},
    {"allequal", 8, 8780},
    {"almostequal", 11, 8776},
    {"almostorequal", 13, 8778},
    {"alpha", 5, 945},
    {"alphatonos", 10, 940},
    {"alternativeayin", 15, 64288},
    {"amacron", 7, 257},
    {"ampersand", 9, 38},
    {"ampersandsmall", 14, 63270},
    {"angle", 5, 8736},
    {"angleleft", 9, 9001},
    {"angleright", 10, 9002},
    {"anglesupnosp", 12, 653},
    {"angstrom", 8, 8491},
    {"anoteleia", 9, 903},
    {"aogonek", 7, 261},
    {"apostrophe", 10, 581},
    {"apostropherev", 13, 582},
    {"apostrophesupnosp", 17, 646},
    {"apple", 5, 63743},
    {"appleopen", 9, 63742},
    {"approachlimit", 13, 8784},
    {"approxequal", 11, 8776},
    {"approxequalalt", 14, 8771},
    {"approxequalorimage", 18, 8786},
    {"approxnotequal", 14, 8774},
    {"approxorequal", 13, 8773},
    {"arabicae", 8, 1749},
    {"arabicalef", 10, 1575},
    {"arabiccomma", 11, 1548},
    {"arabicfivepointedstar", 21, 1645},
    {"arabicindicdigiteight", 21, 1640},
    {"arabicindicdigitfive", 20, 1637},
    {"arabicindicdigitfour", 20, 1636},
    {"arabicindicdigitnine", 20, 1641},
    {"arabicindicdigitone", 19, 1633},
    {"arabicindicdigitseven", 21, 1639},
    {"arabicindicdigitsix", 19, 1638},
    {"arabicindicdigitthree", 21, 1635},
    {"arabicindicdigittwo", 19, 1634},
    {"arabicindicdigitzero", 20, 1632},
    {"arabickaf", 9, 1603},
    {"arabickaffinal", 14, 65242},
    {"arabicpercentsign", 17, 1642},
    {"arabicquestionmark", 18, 1567},
    {"arabicsemicolon", 15, 1563},
    {"archdblsubnosp", 14, 670},
    {"aring", 5, 229},
    {"aringacute", 10, 507},
    {"arrowanticlockw", 15, 8634},
    {"arrowbardown", 12, 1424},
    {"arrowbarleft", 12, 1421},
    {"arrowbarright", 13, 1423},
    {"arrowbarup", 10, 1422},
    {"arrowboth", 9, 8596},
    {"arrowbothvbase", 14, 1425},
    {"arrowclockw", 11, 8635},
    {"arrowdashdown", 13, 8675},
    {"arrowdashleft", 13, 8672},
    {"arrowdashright", 14, 8674},
    {"arrowdashup", 11, 8673},
    {"arrowdblboth", 12, 8660},
    {"arrowdbldown", 12, 8659},
    {"arrowdblleft", 12, 8656},
    {"arrowdblleftnot", 15, 8653},
    {"arrowdbllongboth", 16, 8660},
    {"arrowdbllongbothnot", 19, 8654},
    {"arrowdbllongbothv", 17, 8661},
    {"arrowdblne", 10, 8663},
    {"arrowdblnw", 10, 8662},
    {"arrowdblright", 13, 8658},
    {"arrowdblrightnot", 16, 8655},
    {"arrowdblse", 10, 8664},
    {"arrowdblsw", 10, 8665},
    {"arrowdblup", 10, 8657},
    {"arrowdown", 9, 8595},
    {"arrowdownleft", 13, 8601},
    {"arrowdownright", 14, 8600},
    {"arrowhookleft", 13, 1426},
    {"arrowhookright", 14, 1427},
    {"arrowhorizex", 12, 63719},
    {"arrowleft", 9, 8592},
    {"arrowleftbothalf", 16, 8637},
    {"arrowleftnot", 12, 1411},
    {"arrowlefttophalf", 16, 8636},
    {"arrowlongboth", 13, 1405},
    {"arrowlongbothnot", 16, 1431},
    {"arrowlongbothv", 14, 1406},
    {"arrowloopleft", 13, 1428},
    {"arrowloopright", 14, 1429},
    {"arrownortheast", 14, 1408},
    {"arrownorthwest", 14, 1407},
    {"arrowopendown", 13, 8681},
    {"arrowopenleft", 13, 8678},
    {"arrowopenright", 14, 8680},
    {"arrowopenup", 11, 8679},
    {"arrowparrleftright", 18, 8646},
    {"arrowparrrightleft", 18, 8644},
    {"arrowright", 10, 8594},
    {"arrowrightbothalf", 17, 8641},
    {"arrowrightdown", 14, 8628},
    {"arrowrightnot", 13, 1412},
    {"arrowrighttophalf", 17, 8640},
    {"arrowsemanticlockw", 18, 8630},
    {"arrowsemclockw", 14, 8631},
    {"arrowsoutheast", 14, 1409},
    {"arrowsouthwest", 14, 1410},
    {"arrowsquiggleleft", 17, 8668},
    {"arrowsquiggleright", 18, 8669},
    {"arrowtableft", 12, 8676},
    {"arrowtabright", 13, 8677},
    {"arrowtailleft", 13, 1419},
    {"arrowtailright", 14, 1420},
    {"arrowtripleleft", 15, 8666},
    {"arrowtripleright", 16, 8667},
    {"arrowup", 7, 8593},
    {"arrowupdn", 9, 8597},
    {"arrowupdnbse", 12, 8616},
    {"arrowupleft", 11, 8598},
    {"arrowupright", 12, 8599},
    {"arrowupwhite", 12, 8679},
    {"arrowvertex", 11, 63718},
    {"arrowwaveboth", 13, 1430},
    {"arrowwaveleft", 13, 1413},
    {"arrowwaveright", 14, 1414},
    {"arrowzigzag", 11, 1432},
    {"asciicircum", 11, 94},
    {"asciitilde", 10, 126},
    {"ascript", 7, 593},
    {"ascriptturn", 11, 482},
    {"assertion", 9, 8870},
    {"asterisk", 8, 42},
    {"asteriskmath", 12, 8727},
    {"asterism", 8, 8258},
    {"asuperior", 9, 63209},
    {"asymptequal", 11, 8771},
    {"at", 2, 64},
    {"atilde", 6, 227},
    {"aturn", 5, 480},
    {"auxiliaryoff", 12, 1452},
    {"auxiliaryon", 11, 1450},
    {"ayin", 4, 1506},
    {"b", 1, 98},
    {"babygamma", 9, 500},
    {"backed", 6, 588},
    {"backslash", 9, 92},
    {"backslashmath", 13, 8726},
    {"backspace", 9, 1441},
    {"bar", 3, 124},
    {"bar1", 4, 8739},
    {"bardbl2", 7, 8741},
    {"barmidlongnosp", 14, 681},
    {"barmidshortnosp", 15, 680},
    {"bbar", 4, 352},
    {"be", 2, 1073},
    {"because", 7, 8757},
    {"beh", 3, 1576},
    {"behfinal", 8, 65168},
    {"behinitial", 10, 65169},
    {"behisolated", 11, 65167},
    {"behmedial", 9, 65170},
    {"behwithalefmaksurafinal", 23, 64622},
    {"behwithalefmaksuraisolated", 26, 64521},
    {"behwithhahinitial", 17, 64669},
    {"behwithhehinitial", 17, 59410},
    {"behwithjeeminitial", 18, 64668},
    {"behwithkhahinitial", 18, 64670},
    {"behwithmeeminitial", 18, 64671},
    {"behwithmeemisolated", 19, 64520},
    {"behwithnoonfinal", 16, 64621},
    {"behwithrehfinal", 15, 64618},
    {"behwithyehfinal", 15, 64623},
    {"behwithyehisolated", 18, 64522},
    {"bell", 4, 1440},
    {"bet", 3, 1489},
    {"beta", 4, 946},
    {"beta1", 5, 793},
    {"bethmath", 8, 8502},
    {"between", 7, 8812},
    {"betwithdagesh", 13, 64305},
    {"betwithrafe", 11, 64332},
    {"bhook", 5, 595},
    {"blank", 5, 9251},
    {"blankb", 6, 1467},
    {"block", 5, 9608},
    {"bom", 3, 65279},
    {"bottomarc", 9, 9697},
    {"bowtie", 6, 8904},
    {"box", 3, 9633},
    {"boxcrossdiaghatch", 17, 9641},
    {"boxcrosshatch", 13, 9638},
    {"boxhorizhatch", 13, 9636},
    {"boxleftdiaghatch", 16, 9639},
    {"boxnested", 9, 9635},
    {"boxrounded", 10, 9634},
    {"boxrtdiaghatch", 14, 9640},
    {"boxverthatch", 12, 9637},
    {"braceex", 7, 63732},
    {"braceleft", 9, 123},
    {"braceleftbt", 11, 63731},
    {"braceleftmid", 12, 63730},
    {"bracelefttp", 11, 63729},
    {"braceright", 10, 125},
    {"bracerightbt", 12, 63742},
    {"bracerightmid", 13, 63741},
    {"bracerighttp", 12, 63740},
    {"bracketleft", 11, 91},
    {"bracketleftbt", 13, 63728},
    {"bracketleftex", 13, 63727},
    {"bracketleftquill", 16, 8261},
    {"bracketlefttp", 13, 63726},
    {"bracketright", 12, 93},
    {"bracketrightbt", 14, 63739},
    {"bracketrightex", 14, 63738},
    {"bracketrightquill", 17, 8262},
    {"bracketrighttp", 14, 63737},
    {"breve", 5, 728},
    {"breve1", 6, 61446},
    {"breveinvnosp", 12, 644},
    {"breveinvsubnosp", 15, 674},
    {"brevenosp", 9, 633},
    {"brevesubnosp", 12, 673},
    {"bridgeinvsubnosp", 16, 685},
    {"bridgesubnosp", 13, 669},
    {"brokenbar", 9, 166},
    {"bsuperior", 9, 63210},
    {"btopbar", 7, 387},
    {"bullet", 6, 8226},
    {"bulletaltone", 12, 9679},
    {"bulletmath", 10, 8729},
    {"bullseye", 8, 9678},
    {"bullseye1", 9, 9678},
    {"c", 1, 99},
    {"c128", 4, 128},
    {"c129", 4, 129},
    {"c141", 4, 141},
    {"c142", 4, 142},
    {"c143", 4, 143},
    {"c144", 4, 247},
    {"c158", 4, 257},
    {"cacute", 6, 263},
    {"cadauna", 7, 8454},
    {"cancel", 6, 1457},
    {"candrabindunosp", 15, 643},
    {"capslock", 8, 8682},
    {"careof", 6, 8453},
    {"caret", 5, 8248},
    {"caretinsert", 11, 8257},
    {"caron", 5, 711},
    {"caron1", 6, 61450},
    {"carriagereturn", 14, 8629},
    {"carriagereturnleft", 18, 63740},
    {"carriagerreturn", 15, 8629},
    {"ccaron", 6, 269},
    {"ccedilla", 8, 231},
    {"ccircumflex", 11, 265},
    {"cclwcontintegral", 16, 8755},
    {"ccurl", 5, 597},
    {"cdot", 4, 267},
    {"cdotaccent", 10, 267},
    {"cedilla", 7, 184},
    {"cedilla1", 8, 61448},
    {"cedilla2", 8, 61453},
    {"cedillanosp", 11, 666},
    {"ceilingleft", 11, 8968},
    {"ceilingright", 12, 8969},
    {"celsius", 7, 8451},
    {"cent", 4, 162},
    {"centinferior", 12, 63199},
    {"centoldstyle", 12, 63394},
    {"centreline", 10, 8452},
    {"centsuperior", 12, 63200},
    {"che", 3, 1095},
    {"chertdes", 8, 1011},
    {"chevertbar", 10, 1013},
    {"chi", 3, 967},
    {"chook", 5, 392},
    {"circle", 6, 9675},
    {"circleasterisk", 14, 8859},
    {"circlebottomsld", 15, 9682},
    {"circledash", 10, 9676},
    {"circledivide", 12, 8856},
    {"circledot", 9, 8857},
    {"circleequal", 11, 8860},
    {"circleleftsld", 13, 9680},
    {"circleminus", 11, 8854},
    {"circleminus1", 12, 8861},
    {"circlemultiply", 14, 8855},
    {"circlenesld", 11, 9684},
    {"circlenwopen", 12, 9685},
    {"circleplus", 10, 8853},
    {"circlerightsld", 14, 9681},
    {"circlering", 10, 8858},
    {"circlesolid", 11, 9679},
    {"circletopsld", 12, 9683},
    {"circleverthatch", 15, 9677},
    {"circumflex", 10, 710},
    {"circumflex1", 11, 61443},
    {"circumflexnosp", 14, 629},
    {"circumflexsubnosp", 17, 672},
    {"clear", 5, 8999},
    {"club", 4, 9827},
    {"clwcontintegral", 15, 8754},
    {"clwintegral", 11, 8753},
    {"colon", 5, 58},
    {"coloncur", 8, 8353},
    {"coloncurrency", 13, 8353},
    {"colonequal", 10, 8788},
    {"colonmonetary", 13, 8353},
    {"comma", 5, 44},
    {"commaaccent", 11, 63171},
    {"commainferior", 13, 63201},
    {"commasubnosp", 12, 665},
    {"commasuperior", 13, 63202},
    {"commasuprevnosp", 15, 647},
    {"commasuprightnosp", 17, 648},
    {"commaturnsupnosp", 16, 645},
    {"complement", 10, 8705},
    {"congruent", 9, 8773},
    {"contains", 8, 8715},
    {"contextmenu", 11, 63739},
    {"contintegral", 12, 8750},
    {"contourintegral", 15, 8750},
    {"control", 7, 8963},
    {"coproduct", 9, 8720},
    {"copyright", 9, 169},
    {"copyrightsans", 13, 63721},
    {"copyrightserif", 14, 63193},
    {"corresponds", 11, 8792},
    {"cruzeiro", 8, 8354},
    {"cstretch", 8, 551},
    {"cturn", 5, 484},
    {"cuberoot", 8, 8731},
    {"curland", 7, 8911},
    {"curlor", 6, 8910},
    {"currency", 8, 164},
    {"cyrBreve", 8, 63185},
    {"cyrFlex", 7, 63186},
    {"cyrbreve", 8, 63188},
    {"cyrflex", 7, 63189},
    {"d", 1, 100},
    {"dad", 3, 1590},
    {"dadfinal", 8, 65214},
    {"dadinitial", 10, 65215},
    {"dadisolated", 11, 65213},
    {"dadmedial", 9, 65216},
    {"dagesh", 6, 1468},
    {"dagger", 6, 8224},
    {"daggerdbl", 9, 8225},
    {"dal", 3, 1583},
    {"dalet", 5, 1491},
    {"dalethmath", 10, 8504},
    {"daletwithdagesh", 15, 64307},
    {"dalfinal", 8, 65194},
    {"dalisolated", 11, 65193},
    {"damma", 5, 1615},
    {"dammahontatweel", 15, 65145},
    {"dammaisolated", 13, 65144},
    {"dammalow", 8, 59425},
    {"dammamedial", 11, 65145},
    {"dammaonhamza", 12, 59445},
    {"dammatan", 8, 1612},
    {"dammatanisolated", 16, 65138},
    {"dammatanlow", 11, 59428},
    {"dammatanonhamza", 15, 59446},
    {"datalinkescape", 14, 1449},
    {"dbar", 4, 241},
    {"dblGrave", 8, 63187},
    {"dblarrowdown", 12, 8650},
    {"dblarrowheaddown", 16, 1418},
    {"dblarrowheadleft", 16, 1415},
    {"dblarrowheadright", 17, 1417},
    {"dblarrowheadup", 14, 1416},
    {"dblarrowleft", 12, 8660},
    {"dblarrowright", 13, 8658},
    {"dblarrowup", 10, 8648},
    {"dblarrowupdown", 14, 8645},
    {"dblgrave", 8, 63190},
    {"dcaron", 6, 271},
    {"dcaron1", 7, 63505},
    {"dcroat", 6, 273},
    {"de", 2, 1076},
    {"definequal", 10, 8797},
    {"degree", 6, 176},
    {"degreecentigrade", 16, 8451},
    {"degreefahrenheit", 16, 8457},
    {"degreefarenheit", 15, 8457},
    {"degreekelvin", 12, 8490},
    {"dei", 3, 824},
    {"delete", 6, 1466},
    {"deleteleft", 10, 9003},
    {"deleteright", 11, 8998},
    {"delta", 5, 948},
    {"deltaequal", 10, 8796},
    {"deltaturn", 9, 365},
    {"devcon0", 7, 1449},
    {"devcon1", 7, 1450},
    {"devcon2", 7, 1451},
    {"devcon3", 7, 1452},
    {"devcon4", 7, 1453},
    {"dhook", 5, 599},
    {"diaeresis", 9, 136},
    {"diaeresistonos", 14, 718},
    {"diaeresistonosnosp", 18, 695},
    {"diamond", 7, 9830},
    {"diamondmath", 11, 8900},
    {"diamondrhomb", 12, 9671},
    {"diamondrhombnested", 18, 9672},
    {"diamondrhombsolid", 17, 9670},
    {"dieresis", 8, 168},
    {"dieresis1", 9, 61445},
    {"dieresisacute", 13, 63191},
    {"dieresisgrave", 13, 63192},
    {"dieresisnosp", 12, 635},
    {"dieresistonos", 13, 901},
    {"difference", 10, 8783},
    {"divide", 6, 247},
    {"divideonmultiply", 16, 8903},
    {"divides", 7, 8739},
    {"dje", 3, 1106},
    {"dkshade", 7, 9619},
    {"dkshade1", 8, 63523},
    {"dmacron", 7, 273},
    {"dnblock", 7, 9604},
    {"dneightblock", 12, 9601},
    {"dnfiveeighthblock", 17, 9605},
    {"dnquarterblock", 14, 9602},
    {"dnseveneighthblock", 18, 9607},
    {"dnthreeeighthblock", 18, 9603},
    {"dnthreequarterblock", 19, 9606},
    {"dollar", 6, 36},
    {"dollarinferior", 14, 63203},
    {"dollaroldstyle", 14, 63268},
    {"dollarsuperior", 14, 63204},
    {"dong", 4, 8363},
    {"dotaccent", 9, 729},
    {"dotbelowcomb", 12, 803},
    {"dotcircle1", 10, 63520},
    {"dotdblsubnosp", 13, 663},
    {"dotlessi", 8, 305},
    {"dotlessj", 8, 63166},
    {"dotmath", 7, 8901},
    {"dotminus", 8, 8760},
    {"dotnosp", 7, 634},
    {"dotplus", 7, 8724},
    {"dotsubnosp", 10, 662},
    {"doubleintegral", 14, 8748},
    {"downslopeellipsis", 17, 8945},
    {"dquoteright", 11, 239},
    {"drthook", 7, 486},
    {"dslash", 6, 273},
    {"dsuperior", 9, 63211},
    {"dtopbar", 7, 396},
    {"dyogh", 5, 564},
    {"dz", 2, 499},
    {"dzcurl", 6, 677},
    {"dze", 3, 1109},
    {"dzhacek", 7, 422},
    {"dzhe", 4, 1119},
    {"e", 1, 101},
    {"eacute", 6, 233},
    {"ebreve", 6, 277},
    {"ecaron", 6, 283},
    {"ecircumflex", 11, 234},
    {"ecyril", 6, 1108},
    {"ecyrilrev", 9, 1101},
    {"edieresis", 9, 235},
    {"edot", 4, 279},
    {"edotaccent", 10, 279},
    {"ef", 2, 1092},
    {"egrave", 6, 232},
    {"eight", 5, 56},
    {"eightinferior", 13, 8328},
    {"eightoldstyle", 13, 63288},
    {"eightsub", 8, 8328},
    {"eightsuperior", 13, 8312},
    {"el", 2, 1083},
    {"element", 7, 8712},
    {"elementsmall", 12, 8714},
    {"ellipsis", 8, 8230},
    {"em", 2, 1084},
    {"emacron", 7, 275},
    {"emdash", 6, 8212},
    {"emptyset", 8, 8709},
    {"emquad", 6, 8193},
    {"emspace", 7, 8195},
    {"en", 2, 1085},
    {"endash", 6, 8211},
    {"endmedium", 9, 1458},
    {"endoffile", 9, 1459},
    {"endofproof", 10, 8718},
    {"endtext", 7, 1436},
    {"endtrans", 8, 1437},
    {"endtransblock", 13, 1456},
    {"eng", 3, 331},
    {"enge", 4, 993},
    {"enquad", 6, 8192},
    {"enquiry", 7, 1438},
    {"enrtdes", 7, 991},
    {"enspace", 7, 8194},
    {"enter", 5, 63741},
    {"eogonek", 7, 281},
    {"eop", 3, 8718},
    {"epsilon", 7, 949},
    {"epsilon1", 8, 491},
    {"epsilon1rev", 11, 492},
    {"epsilon1revclosed", 17, 494},
    {"epsilon1revhook", 15, 493},
    {"epsilonclosed", 13, 554},
    {"epsilontonos", 12, 941},
    {"equal", 5, 61},
    {"equalcolon", 10, 8789},
    {"equalfollows1", 13, 8927},
    {"equalgreater", 12, 8925},
    {"equalinferior", 13, 8332},
    {"equalless", 9, 8924},
    {"equalparallel", 13, 8917},
    {"equalprecedes1", 14, 8926},
    {"equalsub", 8, 8332},
    {"equalsuperior", 13, 8316},
    {"equiangular", 11, 8794},
    {"equivalence", 11, 8801},
    {"equivasymptotic", 15, 8781},
    {"er", 2, 1088},
    {"erev", 4, 488},
    {"es", 2, 1089},
    {"escape", 6, 1460},
    {"escedilla", 9, 999},
    {"escript", 7, 8495},
    {"escudo", 6, 36},
    {"esh", 3, 643},
    {"eshcurl", 7, 646},
    {"eshlooprev", 10, 394},
    {"eshshortrev", 11, 533},
    {"estimated", 9, 8494},
    {"estimates", 9, 8793},
    {"esuperior", 9, 63212},
    {"eta", 3, 951},
    {"etatonos", 8, 942},
    {"eth", 3, 240},
    {"eturn", 5, 445},
    {"eurocurrency", 12, 8352},
    {"excess", 6, 8761},
    {"exclam", 6, 33},
    {"exclam1", 7, 419},
    {"exclamdbl", 9, 8252},
    {"exclamdown", 10, 161},
    {"exclamdownsmall", 15, 63393},
    {"exclamsmall", 11, 63265},
    {"existential", 11, 8707},
    {"extendedarabicindicdigiteight", 29, 1784},
    {"extendedarabicindicdigitfive", 28, 1781},
    {"extendedarabicindicdigitfour", 28, 1780},
    {"extendedarabicindicdigitnine", 28, 1785},
    {"extendedarabicindicdigitone", 27, 1777},
    {"extendedarabicindicdigitseven", 29, 1783},
    {"extendedarabicindicdigitsix", 27, 1782},
    {"extendedarabicindicdigitthree", 29, 1779},
    {"extendedarabicindicdigittwo", 27, 1778},
    {"extendedarabicindicdigitzero", 28, 1776},
    {"f", 1, 102},
    {"f700", 4, 63232},
    {"f701", 4, 63233},
    {"f702", 4, 63234},
    {"f703", 4, 63235},
    {"f704", 4, 63236},
    {"f705", 4, 63237},
    {"f706", 4, 63238},
    {"f707", 4, 63239},
    {"f708", 4, 63240},
    {"f709", 4, 63241},
    {"f70a", 4, 63242},
    {"f70b", 4, 63243},
    {"f70c", 4, 63244},
    {"f70d", 4, 63245},
    {"f70e", 4, 63246},
    {"f70f", 4, 63247},
    {"f710", 4, 63248},
    {"f711", 4, 63249},
    {"f712", 4, 63250},
    {"f713", 4, 63251},
    {"f714", 4, 63252},
    {"f715", 4, 63253},
    {"f716", 4, 63254},
    {"f717", 4, 63255},
    {"f718", 4, 63256},
    {"f719", 4, 63257},
    {"f71a", 4, 63258},
    {"f71c", 4, 63260},
    {"f71d", 4, 63261},
    {"fahrenheit", 10, 8457},
    {"farenheit", 9, 8457},
    {"farsiyeh", 8, 1740},
    {"farsiyehfinal", 13, 64509},
    {"farsiyehisolated", 16, 64508},
    {"fatha", 5, 1614},
    {"fathahontatweel", 15, 65143},
    {"fathaisolated", 13, 65142},
    {"fathalow", 8, 59424},
    {"fathamedial", 11, 65143},
    {"fathaonhamza", 12, 59442},
    {"fathatan", 8, 1611},
    {"fathatanisolated", 16, 65136},
    {"fathatanlow", 11, 59427},
    {"fathatanonhamza", 15, 59443},
    {"fathatanontatweel", 17, 65137},
    {"feh", 3, 1601},
    {"fehfinal", 8, 65234},
    {"fehinitial", 10, 65235},
    {"fehisolated", 11, 65233},
    {"fehmedial", 9, 65236},
    {"fehwithalefmaksuraisolated", 26, 64561},
    {"fehwithyehisolated", 18, 64562},
    {"female", 6, 9792},
    {"ff", 2, 64256},
    {"ffi", 3, 64259},
    {"ffl", 3, 64260},
    {"fi", 2, 64257},
    {"figuredash", 10, 8210},
    {"figurespace", 11, 8199},
    {"fileseparator", 13, 1461},
    {"filledbox", 9, 9632},
    {"filledparallelogram", 19, 9648},
    {"filledrect", 10, 9644},
    {"filledvertrect", 14, 9646},
    {"finalkafwithdagesh", 18, 64314},
    {"finalkafwithqamats", 18, 59395},
    {"finalkafwithsheva", 17, 59394},
    {"finalpewithdagesh", 17, 64323},
    {"fisheye", 7, 9673},
    {"five", 4, 53},
    {"fiveeighths", 11, 8541},
    {"fiveinferior", 12, 8325},
    {"fiveoldstyle", 12, 63285},
    {"fivesixth", 9, 8538},
    {"fivesub", 7, 8325},
    {"fivesuperior", 12, 8309},
    {"fl", 2, 64258},
    {"flat", 4, 9837},
    {"floorleft", 9, 8970},
    {"floorright", 10, 8971},
    {"florin", 6, 402},
    {"follows", 7, 8827},
    {"followsequal1", 13, 8829},
    {"followsequivlnt", 15, 8831},
    {"followsnotequal", 15, 8929},
    {"followsnotequivlnt", 18, 8937},
    {"force", 5, 8873},
    {"forceextr", 9, 8875},
    {"fork", 4, 8916},
    {"formfeed", 8, 1445},
    {"four", 4, 52},
    {"fourfifths", 10, 8536},
    {"fourinferior", 12, 8324},
    {"fouroldstyle", 12, 63284},
    {"fourperemspace", 14, 8197},
    {"foursub", 7, 8324},
    {"foursuperior", 12, 8308},
    {"fourthroot", 10, 8732},
    {"fraction", 8, 8725},
    {"fraction1", 9, 8260},
    {"franc", 5, 8355},
    {"fronted", 7, 587},
    {"fscript", 7, 370},
    {"g", 1, 103},
    {"gacute", 6, 501},
    {"gaf", 3, 1711},
    {"gaffinal", 8, 64403},
    {"gafinitial", 10, 64404},
    {"gafisolated", 11, 64402},
    {"gafmedial", 9, 64405},
    {"gamma", 5, 947},
    {"gamma1", 6, 499},
    {"gammasuper", 10, 617},
    {"gbar", 4, 453},
    {"gbreve", 6, 287},
    {"gcaron", 6, 487},
    {"gcedilla", 8, 291},
    {"gcedilla1", 9, 63514},
    {"gcircumflex", 11, 285},
    {"gcommaaccent", 12, 291},
    {"gcursive", 8, 497},
    {"gdot", 4, 289},
    {"gdotaccent", 10, 289},
    {"ge", 2, 1075},
    {"gebar", 5, 975},
    {"gehook", 6, 977},
    {"gekarev", 7, 989},
    {"geomequal", 9, 8785},
    {"geomequivalent", 14, 8782},
    {"geomproportion", 14, 8762},
    {"geresh", 6, 1523},
    {"germandbls", 10, 223},
    {"gershayim", 9, 1524},
    {"geupturn", 8, 1169},
    {"ghacek", 6, 455},
    {"ghain", 5, 1594},
    {"ghainfinal", 10, 65230},
    {"ghaininitial", 12, 65231},
    {"ghainisolated", 13, 65229},
    {"ghainmedial", 11, 65232},
    {"ghook", 5, 608},
    {"gimel", 5, 1490},
    {"gimelmath", 9, 8503},
    {"gimelwithdagesh", 15, 64306},
    {"gje", 3, 1107},
    {"glottal", 7, 585},
    {"glottalrev", 10, 586},
    {"glottalrevsuper", 15, 621},
    {"glottalstop", 11, 660},
    {"glottalstopbar", 14, 561},
    {"glottalstopbarinv", 17, 414},
    {"glottalstopbarrev", 17, 562},
    {"glottalstopinv", 14, 550},
    {"glottalstoprevinv", 17, 549},
    {"gradient", 8, 8711},
    {"grave", 5, 96},
    {"grave1", 6, 596},
    {"gravecomb", 9, 768},
    {"gravedblnosp", 12, 642},
    {"graveleftnosp", 13, 691},
    {"gravenosp", 9, 627},
    {"gravesub", 8, 599},
    {"gravesubnosp", 12, 649},
    {"greater", 7, 62},
    {"greaterdblequal", 15, 8807},
    {"greaterdot", 10, 8919},
    {"greaterequal", 12, 8805},
    {"greaterequalless", 16, 8923},
    {"greaterequivlnt", 15, 8819},
    {"greatermuch", 11, 8811},
    {"greaternotdblequal", 18, 8809},
    {"greaternotequivlnt", 18, 8935},
    {"greaterorless", 13, 8823},
    {"groupseparator", 14, 1462},
    {"gscript", 7, 609},
    {"gscriptmath", 11, 8458},
    {"guillemotleft", 13, 171},
    {"guillemotright", 14, 187},
    {"guilsinglleft", 13, 8249},
    {"guilsinglright", 14, 8250},
    {"h", 1, 104},
    {"haceknosp", 9, 639},
    {"haceksubnosp", 12, 671},
    {"hah", 3, 1581},
    {"hahfinal", 8, 65186},
    {"hahinitial", 10, 65187},
    {"hahisolated", 11, 65185},
    {"hahmedial", 9, 65188},
    {"hahwithmeeminitial", 18, 64682},
    {"hairspace", 9, 8202},
    {"halflength", 10, 602},
    {"hamza", 5, 1569},
    {"hamzaisolated", 13, 65152},
    {"hard", 4, 1098},
    {"harpoondownleft", 15, 8643},
    {"harpoondownright", 16, 8642},
    {"harpoonleftright", 16, 8651},
    {"harpoonrightleft", 16, 8652},
    {"harpoonupleft", 13, 8639},
    {"harpoonupright", 14, 8638},
    {"hatafpatah", 10, 1458},
    {"hatafqamats", 11, 1459},
    {"hatafsegol", 10, 1457},
    {"hbar", 4, 295},
    {"hcircumflex", 11, 293},
    {"hcyril", 6, 1015},
    {"he", 2, 1492},
    {"heart", 5, 9829},
    {"heh", 3, 1607},
    {"hehfinal", 8, 65258},
    {"hehinitial", 10, 65259},
    {"hehisolated", 11, 65257},
    {"hehmedial", 9, 65260},
    {"hehwithmeeminitial", 18, 64728},
    {"help", 4, 63734},
    {"henghook", 8, 615},
    {"hermitconjmatrix", 16, 8889},
    {"het", 3, 1495},
    {"hewithmapiq", 11, 64308},
    {"hhook", 5, 614},
    {"hhooksuper", 10, 570},
    {"highcomman", 10, 297},
    {"higherrank", 10, 8881},
    {"highhamza", 9, 1652},
    {"hiriq", 5, 1460},
    {"hmacron", 7, 263},
    {"holam", 5, 1465},
    {"home", 4, 8632},
    {"homothetic", 10, 8763},
    {"hookabovecomb", 13, 777},
    {"hooksubpalatnosp", 16, 660},
    {"hooksubretronosp", 16, 661},
    {"hooksupnosp", 11, 636},
    {"horiztab", 8, 1442},
    {"hornnosp", 8, 654},
    {"house", 5, 8962},
    {"hsuper", 6, 569},
    {"hturn", 5, 501},
    {"hungarumlaut", 12, 733},
    {"hungarumlaut1", 13, 61449},
    {"hv", 2, 405},
    {"hyphen", 6, 45},
    {"hyphen-minus", 12, 45},
    {"hyphen1", 7, 8208},
    {"hyphenbullet", 12, 8259},
    {"hyphendot", 9, 8231},
    {"hypheninferior", 14, 63205},
    {"hyphenminus", 11, 45},
    {"hyphennobreak", 13, 8209},
    {"hyphensuperior", 14, 63206},
    {"i", 1, 105},
    {"ia", 2, 1103},
    {"iacute", 6, 237},
    {"ibar", 4, 504},
    {"ibreve", 6, 301},
    {"icircumflex", 11, 238},
    {"icyril", 6, 1110},
    {"idieresis", 9, 239},
    {"ie", 2, 1077},
    {"iehook", 6, 1017},
    {"iehookogonek", 12, 1019},
    {"igrave", 6, 236},
    {"ihacek", 6, 432},
    {"ii", 2, 1080},
    {"iibreve", 7, 1081},
    {"ij", 2, 307},
    {"imacron", 7, 299},
    {"image", 5, 8887},
    {"imageorapproxequal", 18, 8787},
    {"increment", 9, 8710},
    {"infinity", 8, 8734},
    {"integral", 8, 8747},
    {"integralbt", 10, 8993},
    {"integraldbl", 11, 8748},
    {"integralex", 10, 63733},
    {"integraltp", 10, 8992},
    {"integraltrpl", 12, 8749},
    {"intercal", 8, 8890},
    {"interrobang", 11, 8253},
    {"intersection", 12, 8745},
    {"intersectiondbl", 15, 8915},
    {"intersectionsq", 14, 8851},
    {"invbullet", 9, 9688},
    {"invcircle", 9, 9689},
    {"invsemicircledn", 15, 9691},
    {"invsemicircleup", 15, 9690},
    {"invsmileface", 12, 9787},
    {"io", 2, 1105},
    {"iogonek", 7, 303},
    {"iota", 4, 953},
    {"iota1", 5, 505},
    {"iotadiaeresis", 13, 787},
    {"iotadiaeresistonos", 18, 729},
    {"iotadieresis", 12, 970},
    {"iotadieresistonos", 17, 912},
    {"iotasub", 7, 707},
    {"iotasubnosp", 11, 696},
    {"iotatonos", 9, 943},
    {"iotaturn", 8, 8489},
    {"isuperior", 9, 63213},
    {"itilde", 6, 297},
    {"iu", 2, 1102},
    {"j", 1, 106},
    {"jcircumflex", 11, 309},
    {"jcrosstail", 10, 557},
    {"jdotlessbar", 11, 495},
    {"je", 2, 1112},
    {"jeem", 4, 1580},
    {"jeemfinal", 9, 65182},
    {"jeeminitial", 11, 65183},
    {"jeemisolated", 12, 65181},
    {"jeemmedial", 10, 65184},
    {"jeemwithmeeminitial", 19, 64680},
    {"jeh", 3, 1688},
    {"jehfinal", 8, 64395},
    {"jehisolated", 11, 64394},
    {"jhacek", 6, 464},
    {"jhookdblbar", 11, 532},
    {"jsuper", 6, 571},
    {"k", 1, 107},
    {"ka", 2, 1082},
    {"kabar", 5, 987},
    {"kaf", 3, 1499},
    {"kaffinal", 8, 1498},
    {"kafinitial", 10, 65243},
    {"kafisolated", 11, 65241},
    {"kafmedial", 9, 65244},
    {"kafwithdagesh", 13, 64315},
    {"kafwithrafe", 11, 64333},
    {"kahook", 6, 1024},
    {"kappa", 5, 954},
    {"kappa1", 6, 825},
    {"kartdes", 7, 983},
    {"kasra", 5, 1616},
    {"kasrahontatweel", 15, 65147},
    {"kasraisolated", 13, 65146},
    {"kasralow", 8, 59430},
    {"kasramedial", 11, 65147},
    {"kasratan", 8, 1613},
    {"kasratanisolated", 16, 65140},
    {"kasratanlow", 11, 59431},
    {"kavertbar", 9, 985},
    {"kcedilla", 8, 311},
    {"kcedilla1", 9, 63513},
    {"kcommaaccent", 12, 311},
    {"keheh", 5, 1705},
    {"kehehfinal", 10, 64399},
    {"kehehinitial", 12, 64400},
    {"kehehisolated", 13, 64398},
    {"kehehmedial", 11, 64401},
    {"kelvin", 6, 8490},
    {"kgreenlandic", 12, 312},
    {"kha", 3, 1093},
    {"khacek", 6, 457},
    {"khah", 4, 1582},
    {"khahfinal", 9, 65190},
    {"khahinitial", 11, 65191},
    {"khahisolated", 12, 65189},
    {"khahmedial", 10, 65192},
    {"khahwithmeeminitial", 19, 64684},
    {"khartdes", 8, 1007},
    {"khook", 5, 409},
    {"kje", 3, 1116},
    {"kra", 3, 280},
    {"kturn", 5, 558},
    {"l", 1, 108},
    {"lacute", 6, 314},
    {"lam", 3, 1604},
    {"lambda", 6, 955},
    {"lambdabar", 9, 379},
    {"lamed", 5, 1500},
    {"lamedwithdagesh", 15, 64316},
    {"lamedwithdageshandholam", 23, 59397},
    {"lamedwithholam", 14, 59396},
    {"lamfinal", 8, 65246},
    {"laminitial", 10, 65247},
    {"lamisolated", 11, 65245},
    {"lammedial", 9, 65248},
    {"lamwithaleffinal", 16, 65276},
    {"lamwithalefhamzaabovefinal", 26, 65272},
    {"lamwithalefhamzaaboveisolatedd", 30, 65271},
    {"lamwithalefhamzabelowfinal", 26, 65274},
    {"lamwithalefhamzabelowisolated", 29, 65273},
    {"lamwithalefisolated", 19, 65275},
    {"lamwithalefmaddaabovefinal", 26, 65270},
    {"lamwithalefmaddaaboveisolatedd", 30, 65269},
    {"lamwithalefmaksuraisolated", 26, 64579},
    {"lamwithhahinitial", 17, 64714},
    {"lamwithhahisolated", 18, 64576},
    {"lamwithhehinitial", 17, 64717},
    {"lamwithjeeminitial", 18, 64713},
    {"lamwithjeemisolated", 19, 64575},
    {"lamwithkhahinitial", 18, 64715},
    {"lamwithkhahisolated", 19, 64577},
    {"lamwithmeeminitial", 18, 64716},
    {"lamwithmeemisolated", 19, 64578},
    {"lamwithmeemwithhahinitial", 25, 64904},
    {"lamwithmeemwithjeeminitial", 26, 59409},
    {"lamwithyehisolated", 18, 64580},
    {"latticetop", 10, 8868},
    {"lazysinv", 8, 8766},
    {"lbar", 4, 410},
    {"lbbar", 5, 8468},
    {"lbelt", 5, 620},
    {"lcaron", 6, 318},
    {"lcaron1", 7, 63507},
    {"lcedilla", 8, 316},
    {"lcedilla1", 9, 63515},
    {"lcircumflex", 11, 1206},
    {"lcommaaccent", 12, 316},
    {"ldot", 4, 320},
    {"ldotaccent", 10, 320},
    {"lefttoright", 11, 8206},
    {"length", 6, 601},
    {"less", 4, 60},
    {"lessdblequal", 12, 8806},
    {"lessdot", 7, 8918},
    {"lessequal", 9, 8804},
    {"lessequalgreater", 16, 8922},
    {"lessequivlnt", 12, 8818},
    {"lessmuch", 8, 8810},
    {"lessnotdblequal", 15, 8808},
    {"lessnotequivlnt", 15, 8934},
    {"lessorgreater", 13, 8822},
    {"lfblock", 7, 9612},
    {"lfeighthblock", 13, 9615},
    {"lffiveeighthblock", 17, 9611},
    {"lfquarterblock", 14, 9614},
    {"lfseveneighthblock", 18, 9609},
    {"lfthreeeighthblock", 18, 9613},
    {"lfthreequarterblock", 19, 9610},
    {"linefeed", 8, 1443},
    {"lineseparator", 13, 8232},
    {"linevert", 8, 593},
    {"linevertdblnosp", 15, 641},
    {"linevertnosp", 12, 640},
    {"linevertsub", 11, 597},
    {"linevertsubnosp", 15, 668},
    {"lira", 4, 8356},
    {"liter", 5, 8467},
    {"lj", 2, 457},
    {"lje", 3, 1113},
    {"ll", 2, 63168},
    {"lmidtilde", 9, 507},
    {"logicaland", 10, 8743},
    {"logicalnot", 10, 172},
    {"logicalor", 9, 8744},
    {"logonek", 7, 63536},
    {"longdash", 8, 8213},
    {"longs", 5, 383},
    {"longst", 6, 64261},
    {"lowered", 7, 590},
    {"lowerrank", 9, 8880},
    {"lozenge", 7, 9674},
    {"lre", 3, 8234},
    {"lro", 3, 8237},
    {"lrthook", 7, 509},
    {"lscript", 7, 8467},
    {"lslash", 6, 322},
    {"lsuper", 6, 618},
    {"lsuperior", 9, 63214},
    {"ltshade", 7, 9617},
    {"ltshade1", 8, 63521},
    {"lyogh", 5, 510},
    {"m", 1, 109},
    {"macron", 6, 713},
    {"macron1", 7, 594},
    {"macronnosp", 10, 631},
    {"macronsub", 9, 598},
    {"macronsubnosp", 13, 676},
    {"male", 4, 9794},
    {"maqaf", 5, 1470},
    {"mcapturn", 8, 380},
    {"measuredangle", 13, 8737},
    {"measurequal", 11, 8798},
    {"meem", 4, 1605},
    {"meemfinal", 9, 65250},
    {"meeminitial", 11, 65251},
    {"meemisolated", 12, 65249},
    {"meemmedial", 10, 65252},
    {"meemwithhahinitial", 18, 64719},
    {"meemwithjeeminitial", 19, 64718},
    {"meemwithkhahinitial", 19, 64720},
    {"meemwithmeeminitial", 19, 64721},
    {"mem", 3, 1502},
    {"memfinal", 8, 1501},
    {"memwithdagesh", 13, 64318},
    {"meteg", 5, 1469},
    {"mho", 3, 8487},
    {"mhook", 5, 625},
    {"micro", 5, 149},
    {"middot", 6, 183},
    {"midhorizellipsis", 16, 8943},
    {"mill", 4, 8357},
    {"milreis", 7, 36},
    {"minus", 5, 8722},
    {"minusinferior", 13, 8331},
    {"minusmod", 8, 727},
    {"minusplus", 9, 8723},
    {"minussub", 8, 8331},
    {"minussubnosp", 12, 659},
    {"minussuperior", 13, 8315},
    {"minustilde", 10, 8770},
    {"minute", 6, 8242},
    {"minuterev", 9, 8245},
    {"msuperior", 9, 63215},
    {"mturn", 5, 511},
    {"mturndescend", 12, 512},
    {"mu", 2, 181},
    {"multicloseleft", 14, 8905},
    {"multicloseright", 15, 8906},
    {"multimap", 8, 8888},
    {"multiopenleft", 13, 8907},
    {"multiopenright", 14, 8908},
    {"multiply", 8, 215},
    {"multiplymultiset", 16, 8845},
    {"multiset", 8, 8844},
    {"musicalnote", 11, 9834},
    {"musicalnotedbl", 14, 9835},
    {"n", 1, 110},
    {"nabla", 5, 8711},
    {"nacute", 6, 324},
    {"naira", 5, 8358},
    {"nand", 4, 8892},
    {"napostrophe", 11, 329},
    {"naryintersection", 16, 8898},
    {"narylogicaland", 14, 8896},
    {"narylogicalor", 13, 8897},
    {"naryunion", 9, 8899},
    {"natural", 7, 9838},
    {"nbhyphen", 8, 8209},
    {"nbspace", 7, 160},
    {"ncaron", 6, 328},
    {"ncedilla", 8, 326},
    {"ncedilla1", 9, 63517},
    {"ncommaaccent", 12, 326},
    {"negacknowledge", 14, 1454},
    {"nequadarc", 9, 9693},
    {"newline", 7, 1469},
    {"newsheqel", 9, 8362},
    {"nine", 4, 57},
    {"nineinferior", 12, 8329},
    {"nineoldstyle", 12, 63289},
    {"ninesub", 7, 8329},
    {"ninesuperior", 12, 8313},
    {"nj", 2, 460},
    {"nje", 3, 1114},
    {"nleg", 4, 382},
    {"nlftlfthook", 11, 514},
    {"nonmarkingreturn", 16, 13},
    {"noon", 4, 1606},
    {"noonfinal", 9, 65254},
    {"nooninitial", 11, 65255},
    {"noonisolated", 12, 65253},
    {"noonmedial", 10, 65256},
    {"noonwithalefmaksurafinal", 24, 64654},
    {"noonwithalefmaksuraisolated", 27, 64591},
    {"noonwithhahinitial", 18, 64723},
    {"noonwithhehinitial", 18, 59413},
    {"noonwithjeeminitial", 19, 64722},
    {"noonwithkhahinitial", 19, 64724},
    {"noonwithmeeminitial", 19, 64725},
    {"noonwithmeemisolated", 20, 64590},
    {"noonwithyehfinal", 16, 64655},
    {"noonwithyehisolated", 19, 64592},
    {"noonwithzainfinal", 17, 64624},
    {"nor", 3, 8893},
    {"notalmostequal", 14, 8777},
    {"notapproxequal", 14, 8775},
    {"notasymptequal", 14, 8772},
    {"notbar", 6, 8740},
    {"notbardbl", 9, 8742},
    {"notcontains", 11, 8716},
    {"notdivides", 10, 8740},
    {"notelement", 10, 8713},
    {"notequal", 8, 8800},
    {"notequivalence", 14, 8802},
    {"notequivasymptotic", 18, 8813},
    {"notexistential", 14, 8708},
    {"notfollows", 10, 8833},
    {"notforce", 8, 8878},
    {"notforceextr", 12, 8879},
    {"notgreater", 10, 8815},
    {"notgreaterequal1", 16, 8817},
    {"notgreaterequivlnt", 18, 8821},
    {"notgreaterless", 14, 8825},
    {"notless", 7, 8814},
    {"notlessequal1", 13, 8816},
    {"notlessequivlnt", 15, 8820},
    {"notlessgreater", 14, 8824},
    {"notowner", 8, 8716},
    {"notparallel", 11, 8742},
    {"notpreceeds", 11, 8832},
    {"notpropersubset", 15, 8836},
    {"notpropersuperset", 17, 8837},
    {"notreflexsubset", 15, 8840},
    {"notreflexsuperset", 17, 8841},
    {"notsatisfy", 10, 8877},
    {"notsimilar", 10, 8769},
    {"notsubset", 9, 8836},
    {"notsubsetsqequal", 16, 8930},
    {"notsuchthat", 11, 8716},
    {"notsuperset", 11, 8837},
    {"notsupersetsqequal", 18, 8931},
    {"nottriangleleft", 15, 8938},
    {"nottriangleleftequal", 20, 8940},
    {"nottriangleright", 16, 8939},
    {"nottrianglerightequal", 21, 8941},
    {"notturnstileleft", 16, 8876},
    {"nrthook", 7, 515},
    {"nsuperior", 9, 8319},
    {"ntilde", 6, 241},
    {"nu", 2, 957},
    {"null", 4, 1433},
    {"numbersign", 10, 35},
    {"numeralgreek", 12, 701},
    {"numeralgreeksub", 15, 702},
    {"numero", 6, 8470},
    {"nun", 3, 1504},
    {"nunfinal", 8, 1503},
    {"nunwithdagesh", 13, 64320},
    {"nwquadarc", 9, 9692},
    {"o", 1, 111},
    {"oacute", 6, 243},
    {"obar", 4, 517},
    {"obreve", 6, 335},
    {"ocircumflex", 11, 244},
    {"ocyril", 6, 1086},
    {"odblacute", 9, 337},
    {"odieresis", 9, 246},
    {"oe", 2, 339},
    {"ogonek", 6, 731},
    {"ogoneknosp", 10, 667},
    {"ograve", 6, 242},
    {"ohacek", 6, 434},
    {"ohm", 3, 8486},
    {"ohminverted", 11, 8487},
    {"ohook", 5, 997},
    {"ohorn", 5, 417},
    {"ohungarumlaut", 13, 337},
    {"oi", 2, 419},
    {"omacron", 7, 333},
    {"omega", 5, 969},
    {"omega1", 6, 982},
    {"omegaclosed", 11, 519},
    {"omegatonos", 10, 974},
    {"omicron", 7, 959},
    {"omicrontonos", 12, 972},
    {"one", 3, 49},
    {"onedotenleader", 14, 8228},
    {"onedotlead", 10, 8228},
    {"onedotleader", 12, 8228},
    {"oneeighth", 9, 8539},
    {"onefifth", 8, 8533},
    {"onefitted", 9, 63196},
    {"onehalf", 7, 189},
    {"oneinferior", 11, 8321},
    {"oneoldstyle", 11, 63281},
    {"onequarter", 10, 188},
    {"onesixth", 8, 8537},
    {"onesub", 6, 8321},
    {"onesuperior", 11, 185},
    {"onethird", 8, 8531},
    {"oogonek", 7, 491},
    {"oogonekmacron", 13, 493},
    {"openbullet", 10, 9702},
    {"openbullet1", 11, 8728},
    {"option", 6, 8997},
    {"ordfeminine", 11, 170},
    {"ordmasculine", 12, 186},
    {"original", 8, 8886},
    {"ornateleftparenthesis", 21, 64830},
    {"ornaterightparenthesis", 22, 64831},
    {"orthogonal", 10, 8735},
    {"orunderscore", 12, 8891},
    {"oscript", 7, 8500},
    {"oslash", 6, 248},
    {"oslashacute", 11, 511},
    {"osuperior", 9, 63216},
    {"otilde", 6, 245},
    {"ounce", 5, 8485},
    {"overline", 8, 8254},
    {"overscore", 9, 175},
    {"overscore1", 10, 594},
    {"overscoredblnosp", 16, 690},
    {"overscorenosp", 13, 632},
    {"overstore", 9, 143},
    {"owner", 5, 8715},
    {"ownersmall", 10, 8717},
    {"p", 1, 112},
    {"pagedown", 8, 8671},
    {"pageup", 6, 8670},
    {"paragraph", 9, 182},
    {"paragraphseparator", 18, 8233},
    {"parallel", 8, 8741},
    {"parallelogram", 13, 9649},
    {"parenleft", 9, 40},
    {"parenleftbt", 11, 63725},
    {"parenleftex", 11, 63724},
    {"parenleftinferior", 17, 8333},
    {"parenleftsub", 12, 8333},
    {"parenleftsuperior", 17, 8317},
    {"parenlefttp", 11, 63723},
    {"parenright", 10, 41},
    {"parenrightbt", 12, 63736},
    {"parenrightex", 12, 63735},
    {"parenrightinferior", 18, 8334},
    {"parenrightsub", 13, 8334},
    {"parenrightsuperior", 18, 8318},
    {"parenrighttp", 12, 63734},
    {"partialdiff", 11, 8706},
    {"paseq", 5, 1472},
    {"patah", 5, 1463},
    {"pdf", 3, 8236},
    {"pe", 2, 1508},
    {"pecyril", 7, 1087},
    {"pefinal", 7, 1507},
    {"peh", 3, 1662},
    {"pehfinal", 8, 64343},
    {"pehinitial", 10, 64344},
    {"pehisolated", 11, 64342},
    {"pehmedial", 9, 64345},
    {"pehook", 6, 995},
    {"pehwithhehinitial", 17, 59411},
    {"percent", 7, 37},
    {"period", 6, 46},
    {"periodcentered", 14, 8226},
    {"periodcentered.0", 16, 151},
    {"periodcentered.1", 16, 183},
    {"periodinferior", 14, 63207},
    {"periodsuperior", 14, 63208},
    {"perpendicular", 13, 8869},
    {"perspcorrespond", 15, 8966},
    {"pertenthousand", 14, 8241},
    {"perthousand", 11, 8240},
    {"peseta", 6, 8359},
    {"pesetas", 7, 8359},
    {"peso1", 5, 63515},
    {"pesoph", 6, 63515},
    {"pewithdagesh", 12, 64324},
    {"pewithrafe", 10, 64334},
    {"phi", 3, 966},
    {"phi1", 4, 981},
    {"philatin", 8, 632},
    {"phook", 5, 421},
    {"pi", 2, 960},
    {"pi1", 3, 799},
    {"pipe", 4, 416},
    {"pipedbl", 7, 417},
    {"pipedblbar", 10, 418},
    {"planck", 6, 8462},
    {"planckover2pi", 13, 8463},
    {"plus", 4, 43},
    {"plusinferior", 12, 8330},
    {"plusminus", 9, 177},
    {"plusmod", 7, 726},
    {"plussub", 7, 8330},
    {"plussubnosp", 11, 658},
    {"plussuperior", 12, 8314},
    {"power", 5, 63737},
    {"precedequivlnt", 14, 8830},
    {"precedes", 8, 8826},
    {"precedesequal1", 14, 8828},
    {"preceedsnotequal", 16, 8928},
    {"preceedsnotsimilar", 18, 8936},
    {"prescription", 12, 8478},
    {"prime", 5, 8242},
    {"prime1", 6, 8242},
    {"primedbl", 8, 8243},
    {"primedbl1", 9, 8243},
    {"primedblmod", 11, 579},
    {"primedblrev", 11, 8246},
    {"primedblrev1", 12, 8246},
    {"primemod", 8, 697},
    {"primerev", 8, 8245},
    {"primerev1", 9, 8245},
    {"primetripl", 10, 8244},
    {"primetripl1", 11, 8244},
    {"primetriplerev", 14, 8247},
    {"primetriplerev1", 15, 8247},
    {"product", 7, 8719},
    {"productdot", 10, 8729},
    {"propellor", 9, 8984},
    {"propersubset", 12, 8834},
    {"propersuperset", 14, 8835},
    {"proportion", 10, 8759},
    {"proportional", 12, 8733},
    {"proportiongeom", 14, 8762},
    {"psi", 3, 968},
    {"punctuationspace", 16, 8200},
    {"q", 1, 113},
    {"qaf", 3, 1602},
    {"qaffinal", 8, 65238},
    {"qafinitial", 10, 65239},
    {"qafisolated", 11, 65237},
    {"qafmedial", 9, 65240},
    {"qamats", 6, 1464},
    {"qhook", 5, 672},
    {"qibuts", 6, 1467},
    {"qof", 3, 1511},
    {"qofwithdagesh", 13, 64327},
    {"qubuts", 6, 1467},
    {"question", 8, 63},
    {"questiondown", 12, 191},
    {"questiondownsmall", 17, 63423},
    {"questionequal", 13, 8799},
    {"questiongreek", 13, 894},
    {"questionsmall", 13, 63295},
    {"quotedash", 9, 8213},
    {"quotedbl", 8, 34},
    {"quotedblbase", 12, 8222},
    {"quotedblleft", 12, 8220},
    {"quotedblrev", 11, 8223},
    {"quotedblright", 13, 8221},
    {"quoteleft", 9, 8216},
    {"quoteleftmod", 12, 580},
    {"quotereversed", 13, 8219},
    {"quoteright", 10, 8217},
    {"quotesinglbase", 14, 8218},
    {"quotesingle", 11, 39},
    {"quotesinglleft", 14, 8216},
    {"quotesinglrev", 13, 8219},
    {"quotesinglright", 15, 8217},
    {"r", 1, 114},
    {"racute", 6, 341},
    {"radical", 7, 8730},
    {"radicalex", 9, 63717},
    {"rafe", 4, 1471},
    {"raised", 6, 589},
    {"ratio", 5, 8758},
    {"rayaleflam", 10, 59414},
    {"rcaron", 6, 345},
    {"rcedilla", 8, 343},
    {"rcedilla1", 9, 63519},
    {"rcircumflex", 11, 63538},
    {"rcommaaccent", 12, 343},
    {"rdescend", 8, 524},
    {"recordright", 11, 8471},
    {"recordseparator", 15, 1463},
    {"rectangle", 9, 9645},
    {"reflexsubset", 12, 8838},
    {"reflexsuperset", 14, 8839},
    {"refmark", 7, 8251},
    {"registered", 10, 174},
    {"registersans", 12, 63720},
    {"registerserif", 13, 63194},
    {"reh", 3, 1585},
    {"rehfinal", 8, 65198},
    {"rehisolated", 11, 65197},
    {"resh", 4, 1512},
    {"reshwithdagesh", 14, 64328},
    {"response", 8, 8479},
    {"revasymptequal", 14, 8909},
    {"revlogicalnot", 13, 8976},
    {"revsimilar", 10, 8765},
    {"rfishhook", 9, 638},
    {"rfishhookrev", 12, 527},
    {"rho", 3, 961},
    {"rho1", 4, 826},
    {"rhotichook", 10, 615},
    {"rightangle", 10, 8735},
    {"rightanglearc", 13, 8894},
    {"righttoleft", 11, 8207},
    {"righttriangle", 13, 8895},
    {"ring", 4, 730},
    {"ring1", 5, 61447},
    {"ringequal", 9, 8791},
    {"ringinequal", 11, 8790},
    {"ringlefthalfsubnosp", 19, 655},
    {"ringlefthalfsup", 15, 604},
    {"ringlefthalfsuper", 17, 584},
    {"ringmath", 8, 8728},
    {"ringnosp", 8, 637},
    {"ringrighthalfcenter", 19, 603},
    {"ringrighthalfsubnosp", 20, 684},
    {"ringrighthalfsuper", 18, 583},
    {"ringsubnosp", 11, 664},
    {"rle", 3, 8235},
    {"rlo", 3, 8238},
    {"rrthook", 7, 525},
    {"rsuper", 6, 572},
    {"rsuperior", 9, 63217},
    {"rtblock", 7, 9616},
    {"rteighthblock", 13, 9621},
    {"rturn", 5, 521},
    {"rturnascend", 11, 522},
    {"rturnhook", 9, 523},
    {"rturnhooksuper", 14, 574},
    {"rturnrthook", 11, 523},
    {"rturnrthooksuper", 16, 574},
    {"rturnsuper", 10, 573},
    {"rupee", 5, 8360},
    {"rupees", 6, 8360},
    {"rupiah", 6, 63197},
    {"s", 1, 115},
    {"sacute", 6, 347},
    {"sad", 3, 1589},
    {"sadfinal", 8, 65210},
    {"sadinitial", 10, 65211},
    {"sadisolated", 11, 65209},
    {"sadmedial", 9, 65212},
    {"samekh", 6, 1505},
    {"samekhwithdagesh", 16, 64321},
    {"satisfy", 7, 8872},
    {"scaron", 6, 353},
    {"scedilla", 8, 351},
    {"scedilla1", 9, 63511},
    {"schwa", 5, 601},
    {"schwahook", 9, 602},
    {"scircumflex", 11, 349},
    {"scommaaccent", 12, 537},
    {"scruple", 7, 8456},
    {"seagullsubnosp", 14, 687},
    {"second", 6, 8243},
    {"secondrev", 9, 8246},
    {"section", 7, 167},
    {"seen", 4, 1587},
    {"seenfinal", 9, 65202},
    {"seeninitial", 11, 65203},
    {"seenisolated", 12, 65201},
    {"seenmedial", 10, 65204},
    {"seenwithmeeminitial", 19, 64688},
    {"segol", 5, 1462},
    {"semicircleleftsld", 17, 9686},
    {"semicirclelertsld", 17, 9687},
    {"semicolon", 9, 59},
    {"sequadarc", 9, 9694},
    {"servicemark", 11, 8480},
    {"setminus", 8, 8726},
    {"seven", 5, 55},
    {"seveneighths", 12, 8542},
    {"seveninferior", 13, 8327},
    {"sevenoldstyle", 13, 63287},
    {"sevensub", 8, 8327},
    {"sevensuperior", 13, 8311},
    {"sfthyphen", 9, 173},
    {"sha", 3, 1096},
    {"shadda", 6, 1617},
    {"shaddahontatweel", 16, 65149},
    {"shaddaisolated", 14, 65148},
    {"shaddalow", 9, 59429},
    {"shaddamedial", 12, 65149},
    {"shaddawithdammaisolated", 23, 64609},
    {"shaddawithdammaisolatedlow", 26, 59433},
    {"shaddawithdammalow", 18, 59433},
    {"shaddawithdammamedial", 21, 64755},
    {"shaddawithdammatanisolated", 26, 64606},
    {"shaddawithdammatanisolatedlow", 29, 59435},
    {"shaddawithdammatanlow", 21, 59435},
    {"shaddawithfathaisolated", 23, 64608},
    {"shaddawithfathaisolatedlow", 26, 59432},
    {"shaddawithfathalow", 18, 59432},
    {"shaddawithfathamedial", 21, 64754},
    {"shaddawithfathatanisolated", 26, 59416},
    {"shaddawithfathatanisolatedlow", 29, 59434},
    {"shaddawithfathatanlow", 21, 59434},
    {"shaddawithkasraisolated", 23, 64610},
    {"shaddawithkasraisolatedlow", 26, 59436},
    {"shaddawithkasralow", 18, 59436},
    {"shaddawithkasramedial", 21, 64756},
    {"shaddawithkasratanisolated", 26, 64607},
    {"shaddawithkasratanisolatedlow", 29, 59437},
    {"shaddawithkasratanlow", 21, 59437},
    {"shade", 5, 9618},
    {"shade1", 6, 63522},
    {"sharp", 5, 9839},
    {"shcha", 5, 1097},
    {"sheen", 5, 1588},
    {"sheenfinal", 10, 65206},
    {"sheeninitial", 12, 65207},
    {"sheenisolated", 13, 65205},
    {"sheenmedial", 11, 65208},
    {"sheenwithmeeminitial", 20, 64816},
    {"sheva", 5, 1456},
    {"shiftin", 7, 1448},
    {"shiftout", 8, 1447},
    {"shin", 4, 1513},
    {"shindot", 7, 1473},
    {"shinwithdagesh", 14, 64329},
    {"shinwithdageshandshindot", 24, 64300},
    {"shinwithdageshandsindot", 23, 64301},
    {"shinwithshindot", 15, 64298},
    {"shinwithsindot", 14, 64299},
    {"sigma", 5, 963},
    {"sigma1", 6, 962},
    {"sigmafinal", 10, 962},
    {"sigmalunate", 11, 827},
    {"similar", 7, 8764},
    {"similarequal", 12, 8771},
    {"sindot", 6, 1474},
    {"sine", 4, 8767},
    {"sinewave", 8, 8767},
    {"six", 3, 54},
    {"sixinferior", 11, 8326},
    {"sixoldstyle", 11, 63286},
    {"sixperemspace", 13, 8198},
    {"sixsub", 6, 8326},
    {"sixsuperior", 11, 8310},
    {"slash", 5, 47},
    {"slashlongnosp", 13, 683},
    {"slashmath", 9, 8725},
    {"slashshortnosp", 14, 682},
    {"slong", 5, 383},
    {"slongt", 6, 64261},
    {"slurabove", 9, 8994},
    {"slurbelow", 9, 8995},
    {"smallbox", 8, 9643},
    {"smallboxfilled", 14, 9642},
    {"smallcontains", 13, 8717},
    {"smallelement", 12, 8714},
    {"smallhighmadda", 14, 1764},
    {"smalltriangle", 13, 9653},
    {"smalltriangleinv", 16, 9663},
    {"smalltriangleinvsld", 19, 9662},
    {"smalltriangleleft", 17, 9667},
    {"smalltriangleleftsld", 20, 9666},
    {"smalltriangleright", 18, 9657},
    {"smalltrianglerightsld", 21, 9656},
    {"smalltrianglesld", 16, 9652},
    {"smileface", 9, 9786},
    {"sofpasuq", 8, 1475},
    {"soft", 4, 1100},
    {"softhyphen", 10, 173},
    {"soundcopyright", 14, 8471},
    {"space", 5, 32},
    {"spaceliteral", 12, 1465},
    {"spaceopenbox", 12, 1468},
    {"spade", 5, 9824},
    {"sphericalangle", 14, 8738},
    {"sqimageornotequal", 17, 8932},
    {"sqoriginornotequal", 18, 8933},
    {"squaredot", 9, 8865},
    {"squareimage", 11, 8847},
    {"squareleftsld", 13, 9703},
    {"squareminus", 11, 8863},
    {"squaremultiply", 14, 8864},
    {"squarenwsld", 11, 9705},
    {"squareoriginal", 14, 8848},
    {"squareplus", 10, 8862},
    {"squarerightsld", 14, 9704},
    {"squareroot", 10, 8730},
    {"squaresesld", 11, 9706},
    {"squaresubnosp", 13, 686},
    {"squarevertbisect", 16, 9707},
    {"srthook", 7, 530},
    {"ssuper", 6, 619},
    {"ssuperior", 9, 63218},
    {"st", 2, 64262},
    {"star", 4, 8902},
    {"starequal", 9, 8795},
    {"startofhead", 11, 1434},
    {"starttext", 9, 1435},
    {"sterling", 8, 163},
    {"strictequivalence", 17, 8803},
    {"subsetdbl", 9, 8912},
    {"subsetnotequal", 14, 8842},
    {"subsetsqequal", 13, 8849},
    {"substitute", 10, 1459},
    {"suchthat", 8, 8715},
    {"sukun", 5, 1618},
    {"sukunisolated", 13, 65150},
    {"sukunlow", 8, 59426},
    {"sukunmedial", 11, 65151},
    {"sukunonhamza", 12, 59444},
    {"sukunontatweel", 14, 65151},
    {"summation", 9, 8721},
    {"sun", 3, 9788},
    {"superscriptalef", 15, 1648},
    {"supersetdbl", 11, 8913},
    {"supersetnotequal", 16, 8843},
    {"supersetsqequal", 15, 8850},
    {"surfaceintegral", 15, 8751},
    {"surfintegral", 12, 8751},
    {"swquadarc", 9, 9695},
    {"synch", 5, 1455},
    {"t", 1, 116},
    {"tableftright", 12, 8633},
    {"tackdownmid", 11, 606},
    {"tackdownsubnosp", 15, 657},
    {"tackleftsubnosp", 15, 651},
    {"tackrightsubnosp", 16, 652},
    {"tacktrpl", 8, 8874},
    {"tackupmid", 9, 605},
    {"tackupsubnosp", 13, 656},
    {"tah", 3, 1591},
    {"tahfinal", 8, 65218},
    {"tahinitial", 10, 65219},
    {"tahisolated", 11, 65217},
    {"tahmedial", 9, 65220},
    {"tatweel", 7, 1600},
    {"tatweelwithfathatanabove", 24, 65137},
    {"tau", 3, 964},
    {"tav", 3, 1514},
    {"tavwithdagesh", 13, 64330},
    {"tbar", 4, 359},
    {"tcaron", 6, 357},
    {"tcaron1", 7, 63509},
    {"tcaronaltone", 12, 63509},
    {"tccurl", 6, 680},
    {"tcedilla", 8, 355},
    {"tcedilla1", 9, 63513},
    {"tcheh", 5, 1670},
    {"tchehfinal", 10, 64379},
    {"tchehinitial", 12, 64380},
    {"tchehisolated", 13, 64378},
    {"tchehmedial", 11, 64381},
    {"tcommaaccent", 12, 355},
    {"te", 2, 1090},
    {"teh", 3, 1578},
    {"tehfinal", 8, 65174},
    {"tehinitial", 10, 65175},
    {"tehisolated", 11, 65173},
    {"tehmarbuta", 10, 1577},
    {"tehmarbutafinal", 15, 65172},
    {"tehmarbutaisolated", 18, 65171},
    {"tehmedial", 9, 65176},
    {"tehwithalefmaksurafinal", 23, 64628},
    {"tehwithhahinitial", 17, 64674},
    {"tehwithhehinitial", 17, 59412},
    {"tehwithjeeminitial", 18, 64673},
    {"tehwithkhahinitial", 18, 64675},
    {"tehwithmeeminitial", 18, 64676},
    {"tehwithmeemisolated", 19, 64526},
    {"tehwithnoonfinal", 16, 64627},
    {"tehwithyehfinal", 15, 64629},
    {"tehwithyehisolated", 18, 64528},
    {"tel", 3, 8481},
    {"telephone", 9, 8481},
    {"tertdes", 7, 1001},
    {"tesh", 4, 679},
    {"tet", 3, 1496},
    {"tetse", 5, 1009},
    {"tetwithdagesh", 13, 64312},
    {"thal", 4, 1584},
    {"thalfinal", 9, 65196},
    {"thalisolated", 12, 65195},
    {"theh", 4, 1579},
    {"thehfinal", 9, 65178},
    {"thehinitial", 11, 65179},
    {"thehisolated", 12, 65177},
    {"thehmedial", 10, 65180},
    {"thehwithmeeminitial", 19, 64678},
    {"thehwithmeemisolated", 20, 64530},
    {"therefore", 9, 8756},
    {"theta", 5, 952},
    {"theta1", 6, 977},
    {"thinspace", 9, 8201},
    {"thook", 5, 429},
    {"thorn", 5, 254},
    {"three", 5, 51},
    {"threeeighths", 12, 8540},
    {"threefifths", 11, 8535},
    {"threeinferior", 13, 8323},
    {"threeoldstyle", 13, 63283},
    {"threeperemspace", 15, 8196},
    {"threequarters", 13, 190},
    {"threequartersemdash", 19, 63198},
    {"threesub", 8, 8323},
    {"threesuperior", 13, 179},
    {"tie", 3, 8256},
    {"tie1", 4, 8256},
    {"tilde", 5, 732},
    {"tilde1", 6, 61444},
    {"tildecomb", 9, 771},
    {"tildemath", 9, 8764},
    {"tildemidnosp", 12, 679},
    {"tildenosp", 9, 630},
    {"tildereversed", 13, 8765},
    {"tildesubnosp", 12, 675},
    {"tildetrpl", 9, 8779},
    {"tildevertsupnosp", 16, 689},
    {"tmacron", 7, 327},
    {"toneextrahigh", 13, 622},
    {"toneextralow", 12, 626},
    {"tonefive", 8, 445},
    {"tonehigh", 8, 623},
    {"tonelow", 7, 625},
    {"tonemid", 7, 624},
    {"tonesix", 7, 389},
    {"tonetwo", 7, 424},
    {"tonos", 5, 900},
    {"toparc", 6, 9696},
    {"tpalatalhook", 12, 427},
    {"tquoteright", 11, 325},
    {"trademark", 9, 8482},
    {"trademarksans", 13, 63722},
    {"trademarkserif", 14, 63195},
    {"tranglenwsld", 12, 9700},
    {"triagdn", 7, 9660},
    {"triaglf", 7, 9668},
    {"triaglfopen", 11, 9669},
    {"triagrt", 7, 9658},
    {"triagrtopen", 11, 9659},
    {"triagup", 7, 9650},
    {"triangle", 8, 9651},
    {"trianglebullet", 14, 8227},
    {"triangledot", 11, 9708},
    {"triangleftequal", 15, 8884},
    {"triangleinv", 11, 9661},
    {"triangleleft", 12, 8883},
    {"triangleleft1", 13, 9665},
    {"triangleleftsld", 15, 9709},
    {"triangleleftsld1", 16, 9664},
    {"trianglenesld", 13, 9701},
    {"triangleright", 13, 8882},
    {"triangleright1", 14, 9655},
    {"trianglerightsld", 16, 9710},
    {"trianglerightsld1", 17, 9654},
    {"trianglesesld", 13, 9698},
    {"triangleswsld", 13, 9699},
    {"triangrightequal", 16, 8885},
    {"tripleintegral", 14, 8749},
    {"trthook", 7, 536},
    {"truestate", 9, 8871},
    {"ts", 2, 678},
    {"tsadi", 5, 1510},
    {"tsadifinal", 10, 1509},
    {"tsadiwithdagesh", 15, 64326},
    {"tse", 3, 1094},
    {"tsere", 5, 1461},
    {"tshe", 4, 1115},
    {"tsuperior", 9, 63219},
    {"tturn", 5, 535},
    {"turnstileleft", 13, 8866},
    {"turnstileright", 14, 8867},
    {"two", 3, 50},
    {"twodotenleader", 14, 8229},
    {"twodotlead", 10, 8229},
    {"twodotleader", 12, 8229},
    {"twofifths", 9, 8534},
    {"twoinferior", 11, 8322},
    {"twooldstyle", 11, 63282},
    {"twosub", 6, 8322},
    {"twosuperior", 11, 178},
    {"twothirds", 9, 8532},
    {"u", 1, 117},
    {"u2643", 5, 9795},
    {"uacute", 6, 250},
    {"ubar", 4, 649},
    {"ubreve", 6, 365},
    {"ucedilla", 8, 63540},
    {"ucircumflex", 11, 251},
    {"ucyril", 6, 1091},
    {"ucyrilbreve", 11, 1118},
    {"udblacute", 9, 369},
    {"udieresis", 9, 252},
    {"udieresisacute", 14, 472},
    {"udieresisgrave", 14, 476},
    {"udieresishacek", 14, 442},
    {"udieresismacron", 15, 470},
    {"ugrave", 6, 249},
    {"uhacek", 6, 436},
    {"uhorn", 5, 432},
    {"uhungarumlaut", 13, 369},
    {"umacron", 7, 363},
    {"underscore", 10, 95},
    {"underscoredbl", 13, 8215},
    {"underscoredblnosp", 17, 678},
    {"underscorenosp", 14, 677},
    {"undertie", 8, 8255},
    {"union", 5, 8746},
    {"uniondbl", 8, 8914},
    {"unionmulti", 10, 8846},
    {"unionsq", 7, 8852},
    {"unitseparator", 13, 1464},
    {"universal", 9, 8704},
    {"uogonek", 7, 371},
    {"upblock", 7, 9600},
    {"upeighthblock", 13, 9620},
    {"upsilon", 7, 965},
    {"upsilondiaeresis", 16, 788},
    {"upsilondiaeresistonos", 21, 761},
    {"upsilondieresis", 15, 971},
    {"upsilondieresistonos", 20, 944},
    {"upsilonlatin", 12, 650},
    {"upsilontonos", 12, 973},
    {"upslopeellipsis", 15, 8944},
    {"uring", 5, 367},
    {"ustrt", 5, 1003},
    {"ustrtbar", 8, 1005},
    {"utilde", 6, 361},
    {"v", 1, 118},
    {"varika", 6, 64286},
    {"vav", 3, 1493},
    {"vavdbl", 6, 1520},
    {"vavwithdagesh", 13, 64309},
    {"vavwithholam", 12, 64331},
    {"vavyod", 6, 1521},
    {"ve", 2, 1074},
    {"veh", 3, 1700},
    {"vehfinal", 8, 64363},
    {"vehinitial", 10, 64364},
    {"vehisolated", 11, 64362},
    {"vehmedial", 9, 64365},
    {"versicle", 8, 8483},
    {"vertellipsis", 12, 8942},
    {"verticalbardbl", 14, 8214},
    {"vertlinedbl", 11, 8214},
    {"vertrectangle", 13, 9647},
    {"verttab", 7, 1444},
    {"verymuchgreater", 15, 8921},
    {"verymuchless", 12, 8920},
    {"volintegral", 11, 8752},
    {"volumeintegral", 14, 8752},
    {"vscript", 7, 539},
    {"vturn", 5, 540},
    {"w", 1, 119},
    {"wacute", 6, 7811},
    {"waw", 3, 1608},
    {"wawfinal", 8, 65262},
    {"wawisolated", 11, 65261},
    {"wawwithhamzaabove", 17, 1572},
    {"wawwithhamzaabovefinal", 22, 65158},
    {"wawwithhamzaaboveisolated", 25, 65157},
    {"wcircumflex", 11, 373},
    {"wdieresis", 9, 7813},
    {"weierstrass", 11, 8472},
    {"wgrave", 6, 7809},
    {"won", 3, 8361},
    {"wreathproduct", 13, 8768},
    {"wsuper", 6, 576},
    {"wturn", 5, 541},
    {"wynn", 4, 447},
    {"x", 1, 120},
    {"xi", 2, 958},
    {"xor", 3, 8891},
    {"xsuper", 6, 620},
    {"xsupnosp", 8, 688},
    {"y", 1, 121},
    {"yacute", 6, 253},
    {"yat", 3, 927},
    {"ycircumflex", 11, 375},
    {"ydieresis", 9, 255},
    {"yeh", 3, 1610},
    {"yehfinal", 8, 65266},
    {"yehinitial", 10, 65267},
    {"yehisolated", 11, 65265},
    {"yehmedial", 9, 65268},
    {"yehwithalefmaksurafinal", 23, 64661},
    {"yehwithalefmaksuraisolated", 26, 64601},
    {"yehwithhahinitial", 17, 64731},
    {"yehwithhamzaabove", 17, 1574},
    {"yehwithhamzaabovefinal", 22, 65162},
    {"yehwithhamzaaboveinitial", 24, 65163},
    {"yehwithhamzaaboveisolated", 25, 65161},
    {"yehwithhamzaabovemedial", 23, 65164},
    {"yehwithjeeminitial", 18, 64730},
    {"yehwithkhahinitial", 18, 64732},
    {"yehwithmeeminitial", 18, 64733},
    {"yehwithmeemisolated", 19, 64600},
    {"yehwithnoonfinal", 16, 64660},
    {"yehwithrehfinal", 15, 64657},
    {"yen", 3, 165},
    {"yeri", 4, 1099},
    {"ygrave", 6, 7923},
    {"yhook", 5, 436},
    {"yi", 2, 1111},
    {"yod", 3, 1497},
    {"yoddbl", 6, 1522},
    {"yodwithdagesh", 13, 64313},
    {"yogh", 4, 546},
    {"yoghcurl", 8, 547},
    {"yoghhacek", 9, 463},
    {"yoghrev", 7, 409},
    {"yoghtail", 8, 410},
    {"ysuper", 6, 577},
    {"yturn", 5, 542},
    {"yusbig", 6, 935},
    {"z", 1, 122},
    {"zacute", 6, 378},
    {"zah", 3, 1592},
    {"zahfinal", 8, 65222},
    {"zahinitial", 10, 65223},
    {"zahisolated", 11, 65221},
    {"zahmedial", 9, 65224},
    {"zain", 4, 1586},
    {"zainfinal", 9, 65200},
    {"zainisolated", 12, 65199},
    {"zayin", 5, 1494},
    {"zayinwithdagesh", 15, 64310},
    {"zbar", 4, 406},
    {"zcaron", 6, 382},
    {"zcurl", 5, 657},
    {"zdot", 4, 380},
    {"zdotaccent", 10, 380},
    {"ze", 2, 1079},
    {"zecedilla", 9, 981},
    {"zero", 4, 48},
    {"zerodot", 7, 48},
    {"zeroinferior", 12, 8320},
    {"zerojoin", 8, 8205},
    {"zeronojoin", 10, 8204},
    {"zerooldstyle", 12, 63280},
    {"zeroslash", 9, 48},
    {"zerospace", 9, 8203},
    {"zerosub", 7, 8320},
    {"zerosuperior", 12, 8304},
    {"zerowidthnobreakspace", 21, 65279},
    {"zeta", 4, 950},
    {"zhe", 3, 1078},
    {"zhebreve", 8, 1022},
    {"zhertdes", 8, 979},
    {"zrthook", 7, 544},
  }
};
static const pdfi_font_decoding_t FCO_Wingdings = {
  "FCO_Wingdings",
  13,
  223,
  {
    {"airplane", 8, 61521},
    {"ampersandit", 11, 61547},
    {"ampersanditlc", 13, 61546},
    {"aquarius", 8, 61544},
    {"aries", 5, 61534},
    {"arrowdwnleft1", 13, 61635},
    {"arrowdwnrt1", 11, 61636},
    {"arrowleftdwn1", 13, 61641},
    {"arrowleftup1", 12, 61639},
    {"arrowrtdwn1", 11, 61642},
    {"arrowrtup1", 10, 61640},
    {"arrowupleft1", 12, 61637},
    {"arrowuprt1", 10, 61638},
    {"ballpoint", 9, 61497},
    {"barb2down", 9, 61666},
    {"barb2left", 9, 61663},
    {"barb2ne", 7, 61668},
    {"barb2nw", 7, 61667},
    {"barb2right", 10, 61664},
    {"barb2se", 7, 61670},
    {"barb2sw", 7, 61669},
    {"barb2up", 7, 61665},
    {"barb4down", 9, 61674},
    {"barb4left", 9, 61671},
    {"barb4ne", 7, 61676},
    {"barb4nw", 7, 61675},
    {"barb4right", 10, 61672},
    {"barb4se", 7, 61678},
    {"barb4sw", 7, 61677},
    {"barb4up", 7, 61673},
    {"bdash1", 6, 61689},
    {"bdash2", 6, 61690},
    {"bdown", 5, 61682},
    {"bell", 4, 61477},
    {"bleft", 5, 61679},
    {"bleftright", 10, 61683},
    {"bne", 3, 61686},
    {"bnw", 3, 61685},
    {"bomb", 4, 61517},
    {"book", 4, 61478},
    {"box2", 4, 61608},
    {"box3", 4, 61551},
    {"box4", 4, 61552},
    {"boxcheckbld", 11, 61694},
    {"boxshadowdwn", 12, 61553},
    {"boxshadowup", 11, 61554},
    {"boxxmarkbld", 11, 61693},
    {"bright", 6, 61680},
    {"bse", 3, 61688},
    {"bsw", 3, 61687},
    {"budleafne", 9, 61590},
    {"budleafnw", 9, 61591},
    {"budleafse", 9, 61593},
    {"budleafsw", 9, 61592},
    {"bup", 3, 61681},
    {"bupdown", 7, 61684},
    {"cancer", 6, 61537},
    {"candle", 6, 61479},
    {"capricorn", 9, 61543},
    {"checkbld", 8, 61692},
    {"circle2", 7, 61598},
    {"circle4", 7, 61599},
    {"circle6", 7, 61548},
    {"circledown", 10, 61662},
    {"circleleft", 10, 61659},
    {"circleright", 11, 61660},
    {"circleshadowdwn", 15, 61549},
    {"circleshadowup", 14, 61606},
    {"circlestar", 10, 61621},
    {"circleup", 8, 61661},
    {"clear", 5, 61560},
    {"command", 7, 61562},
    {"crescentstar", 12, 61530},
    {"crossceltic", 11, 61527},
    {"crossmaltese", 12, 61528},
    {"crossoutline", 12, 61525},
    {"crossshadow", 11, 61526},
    {"crosstar2", 9, 61610},
    {"cuspopen", 8, 61618},
    {"cuspopen1", 9, 61619},
    {"deleteleft", 10, 61653},
    {"deleteright", 11, 61654},
    {"dodecastar3", 11, 61614},
    {"droplet", 7, 61523},
    {"eightoclock", 11, 61630},
    {"eightsans", 9, 61576},
    {"eightsansinv", 12, 61587},
    {"elevenoclock", 12, 61633},
    {"envelopeback", 12, 61482},
    {"envelopefront", 13, 61483},
    {"escape", 6, 61561},
    {"filecabinet", 11, 61493},
    {"filetalltext", 12, 61491},
    {"filetalltext1", 13, 61490},
    {"filetalltext3", 13, 61492},
    {"fiveoclock", 10, 61627},
    {"fivesans", 8, 61573},
    {"fivesansinv", 11, 61584},
    {"flag", 4, 61519},
    {"floppy3", 7, 61500},
    {"floppy5", 7, 61501},
    {"folder", 6, 61488},
    {"folderopen", 10, 61489},
    {"fouroclock", 10, 61626},
    {"foursans", 8, 61572},
    {"foursansinv", 11, 61583},
    {"frownface", 9, 61516},
    {"gemini", 6, 61536},
    {"handhalt", 8, 61513},
    {"handok", 6, 61506},
    {"handptdwn", 9, 61512},
    {"handptleft", 10, 61509},
    {"handptright", 11, 61510},
    {"handptup", 8, 61511},
    {"handv", 5, 61505},
    {"handwrite", 9, 61503},
    {"handwriteleft", 13, 61504},
    {"harddisk", 8, 61499},
    {"head2down", 9, 61658},
    {"head2left", 9, 61655},
    {"head2right", 10, 61656},
    {"head2up", 7, 61657},
    {"hexstar2", 8, 61612},
    {"hourglass", 9, 61494},
    {"keyboard", 8, 61495},
    {"leafccwne", 9, 61648},
    {"leafccwnw", 9, 61646},
    {"leafccwse", 9, 61647},
    {"leafccwsw", 9, 61645},
    {"leafne", 6, 61651},
    {"leafnw", 6, 61649},
    {"leafse", 6, 61652},
    {"leafsw", 6, 61650},
    {"leo", 3, 61538},
    {"libra", 5, 61540},
    {"lozenge4", 8, 61555},
    {"lozenge6", 8, 61556},
    {"mailboxflagdwn", 14, 61484},
    {"mailboxflagup", 13, 61485},
    {"mailbxopnflgdwn", 15, 61487},
    {"mailbxopnflgup", 14, 61486},
    {"mouse2button", 12, 61496},
    {"neutralface", 11, 61515},
    {"nineoclock", 10, 61631},
    {"ninesans", 8, 61577},
    {"ninesansinv", 11, 61588},
    {"octastar2", 9, 61613},
    {"octastar4", 9, 61615},
    {"om", 2, 61532},
    {"oneoclock", 9, 61623},
    {"onesans", 7, 61569},
    {"onesansinv", 10, 61580},
    {"pc", 2, 61498},
    {"pencil", 6, 61473},
    {"pennant", 7, 61520},
    {"pentastar2", 10, 61611},
    {"pisces", 6, 61545},
    {"query", 5, 61620},
    {"quiltsquare2", 12, 61643},
    {"quiltsquare2inv", 15, 61644},
    {"quotedbllftbld", 14, 61565},
    {"quotedblrtbld", 13, 61566},
    {"readingglasses", 14, 61476},
    {"registercircle", 14, 61617},
    {"registersquare", 14, 61616},
    {"rhombus4", 8, 61559},
    {"rhombus6", 8, 61557},
    {"ring2", 5, 61601},
    {"ring4", 5, 61602},
    {"ring6", 5, 61603},
    {"ringbutton2", 11, 61604},
    {"rosette", 7, 61563},
    {"rosettesolid", 12, 61564},
    {"saggitarius", 11, 61542},
    {"scissors", 8, 61474},
    {"scissorscutting", 15, 61475},
    {"scorpio", 7, 61541},
    {"sevenoclock", 11, 61629},
    {"sevensans", 9, 61575},
    {"sevensansinv", 12, 61586},
    {"sixoclock", 9, 61628},
    {"sixsans", 7, 61574},
    {"sixsansinv", 10, 61585},
    {"skullcrossbones", 15, 61518},
    {"smileface", 9, 61514},
    {"snowflake", 9, 61524},
    {"space", 5, 32},
    {"square2", 7, 61600},
    {"square4", 7, 61607},
    {"square6", 7, 61550},
    {"starofdavid", 11, 61529},
    {"starshadow", 10, 61622},
    {"sunshine", 8, 61522},
    {"tapereel", 8, 61502},
    {"target", 6, 61605},
    {"taurus", 6, 61535},
    {"telephonesolid", 14, 61480},
    {"telhandsetcirc", 14, 61481},
    {"tenoclock", 9, 61632},
    {"tensans", 7, 61578},
    {"tensansinv", 10, 61589},
    {"threeoclock", 11, 61625},
    {"threesans", 9, 61571},
    {"threesansinv", 12, 61582},
    {"thumbdown", 9, 61508},
    {"thumbup", 7, 61507},
    {"tristar2", 8, 61609},
    {"twelveoclock", 12, 61634},
    {"twooclock", 9, 61624},
    {"twosans", 7, 61570},
    {"twosansinv", 10, 61581},
    {"vineleafboldne", 14, 61594},
    {"vineleafboldnw", 14, 61595},
    {"vineleafboldse", 14, 61597},
    {"vineleafboldsw", 14, 61596},
    {"virgo", 5, 61539},
    {"wheel", 5, 61533},
    {"windowslogo", 11, 61695},
    {"xmarkbld", 8, 61691},
    {"xrhombus", 8, 61558},
    {"yinyang", 7, 61531},
    {"zerosans", 8, 61568},
    {"zerosansinv", 11, 61579},
  }
};
static const pdfi_font_decoding_t *pdfi_fco_font_decoding_list[] = {
  &FCO_Dingbats,
  &FCO_Symbol,
  &FCO_Unicode,
  &FCO_Wingdings,
};


int pdfi_lookup_fco_char_code(const char *decname, int32_t decnamelen, const char *gname, int32_t gnamelen, int64_t *charcode)
{
    int i;
    int code = gs_error_undefined;
    const size_t n = sizeof(pdfi_fco_font_decoding_list) / sizeof(pdfi_fco_font_decoding_list[0]);

    for (i = 0; i < n;i++) {
        if (pdfi_fco_font_decoding_list[i]->dec_name_len == decnamelen && strncmp(pdfi_fco_font_decoding_list[i]->dec_name, decname, decnamelen) == 0) {
            break;
        }
    }
    if (i < n) {
        const pdfi_font_decoding_t *dec = pdfi_fco_font_decoding_list[i];
        for (i = 0; i < dec->nentries; i++) {
            if (dec->entries[i].glyph_name_len == gnamelen && strncmp(dec->entries[i].glyph_name, gname, gnamelen) == 0) {
                code = 0;
                *charcode = dec->entries[i].code_point;
            }
        }
    }
    return code;
}
#endif /* UFST_BRIDGE */
