// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception


// Copyright 2018 Ulf Adams
// Copyright (c) Microsoft Corporation. All rights reserved.

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


// This file contains test cases derived from:
// https://github.com/ulfjack/ryu
// See xcharconv_ryu.h for the exact commit.
// (Keep the cgmanifest.json commitHash in sync.)


#ifndef DOUBLE_TO_CHARS_TEST_CASES_HPP
#define DOUBLE_TO_CHARS_TEST_CASES_HPP

#include <charconv>

#include "test.hpp"
using namespace std;

inline constexpr DoubleToCharsTestCase double_to_chars_test_cases[] = {
    // Test special cases (zero, inf, nan) and an ordinary case. Also test negative signs.
    {0.0, chars_format::scientific, "0e+00"},
    {-0.0, chars_format::scientific, "-0e+00"},
    {double_inf, chars_format::scientific, "inf"},
    {-double_inf, chars_format::scientific, "-inf"},
    {double_nan, chars_format::scientific, "nan"},
    {-double_nan, chars_format::scientific, "-nan(ind)"},
    {double_nan_payload, chars_format::scientific, "nan"},
    {-double_nan_payload, chars_format::scientific, "-nan"},
    {2.018, chars_format::scientific, "2.018e+00"},
    {-2.018, chars_format::scientific, "-2.018e+00"},

    // Ditto for fixed, which doesn't emit exponents.
    {0.0, chars_format::fixed, "0"},
    {-0.0, chars_format::fixed, "-0"},
    {double_inf, chars_format::fixed, "inf"},
    {-double_inf, chars_format::fixed, "-inf"},
    {double_nan, chars_format::fixed, "nan"},
    {-double_nan, chars_format::fixed, "-nan(ind)"},
    {double_nan_payload, chars_format::fixed, "nan"},
    {-double_nan_payload, chars_format::fixed, "-nan"},
    {2.018, chars_format::fixed, "2.018"},
    {-2.018, chars_format::fixed, "-2.018"},

    // Ditto for general, which selects fixed for the scientific exponent 0.
    {0.0, chars_format::general, "0"},
    {-0.0, chars_format::general, "-0"},
    {double_inf, chars_format::general, "inf"},
    {-double_inf, chars_format::general, "-inf"},
    {double_nan, chars_format::general, "nan"},
    {-double_nan, chars_format::general, "-nan(ind)"},
    {double_nan_payload, chars_format::general, "nan"},
    {-double_nan_payload, chars_format::general, "-nan"},
    {2.018, chars_format::general, "2.018"},
    {-2.018, chars_format::general, "-2.018"},

    // Ditto for plain, which selects fixed because it's shorter for these values.
    {0.0, chars_format{}, "0"},
    {-0.0, chars_format{}, "-0"},
    {double_inf, chars_format{}, "inf"},
    {-double_inf, chars_format{}, "-inf"},
    {double_nan, chars_format{}, "nan"},
    {-double_nan, chars_format{}, "-nan(ind)"},
    {double_nan_payload, chars_format{}, "nan"},
    {-double_nan_payload, chars_format{}, "-nan"},
    {2.018, chars_format{}, "2.018"},
    {-2.018, chars_format{}, "-2.018"},

    // Ditto for hex.
    {0.0, chars_format::hex, "0p+0"},
    {-0.0, chars_format::hex, "-0p+0"},
    {double_inf, chars_format::hex, "inf"},
    {-double_inf, chars_format::hex, "-inf"},
    {double_nan, chars_format::hex, "nan"},
    {-double_nan, chars_format::hex, "-nan(ind)"},
    {double_nan_payload, chars_format::hex, "nan"},
    {-double_nan_payload, chars_format::hex, "-nan"},
    {0x1.729p+0, chars_format::hex, "1.729p+0"},
    {-0x1.729p+0, chars_format::hex, "-1.729p+0"},

    // Ryu d2s_test.cc SwitchToSubnormal
    {2.2250738585072014e-308, chars_format::scientific, "2.2250738585072014e-308"},

    // Ryu d2s_test.cc MinAndMax
    {0x1.fffffffffffffp+1023, chars_format::scientific, "1.7976931348623157e+308"},
    {0x0.0000000000001p-1022, chars_format::scientific, "5e-324"},

    // Ryu d2s_test.cc LotsOfTrailingZeros
    {2.98023223876953125e-8, chars_format::scientific, "2.9802322387695312e-08"},

    // Ryu d2s_test.cc Regression
    {-2.109808898695963e16, chars_format::scientific, "-2.109808898695963e+16"},
    {4.940656e-318, chars_format::scientific, "4.940656e-318"},
    {1.18575755e-316, chars_format::scientific, "1.18575755e-316"},
    {2.989102097996e-312, chars_format::scientific, "2.989102097996e-312"},
    {9.0608011534336e15, chars_format::scientific, "9.0608011534336e+15"},
    {4.708356024711512e18, chars_format::scientific, "4.708356024711512e+18"},
    {9.409340012568248e18, chars_format::scientific, "9.409340012568248e+18"},

    // Ryu d2s_test.cc LooksLikePow5
    {0x1.0f0cf064dd592p+132, chars_format::scientific, "5.764607523034235e+39"},
    {0x1.0f0cf064dd592p+133, chars_format::scientific, "1.152921504606847e+40"},
    {0x1.0f0cf064dd592p+134, chars_format::scientific, "2.305843009213694e+40"},

    // Ryu d2s_test.cc OutputLength
    {1.0, chars_format::scientific, "1e+00"},
    {1.2, chars_format::scientific, "1.2e+00"},
    {1.23, chars_format::scientific, "1.23e+00"},
    {1.234, chars_format::scientific, "1.234e+00"},
    {1.2345, chars_format::scientific, "1.2345e+00"},
    {1.23456, chars_format::scientific, "1.23456e+00"},
    {1.234567, chars_format::scientific, "1.234567e+00"},
    {1.2345678, chars_format::scientific, "1.2345678e+00"},
    {1.23456789, chars_format::scientific, "1.23456789e+00"},
    {1.234567895, chars_format::scientific, "1.234567895e+00"},
    {1.2345678901, chars_format::scientific, "1.2345678901e+00"},
    {1.23456789012, chars_format::scientific, "1.23456789012e+00"},
    {1.234567890123, chars_format::scientific, "1.234567890123e+00"},
    {1.2345678901234, chars_format::scientific, "1.2345678901234e+00"},
    {1.23456789012345, chars_format::scientific, "1.23456789012345e+00"},
    {1.234567890123456, chars_format::scientific, "1.234567890123456e+00"},
    {1.2345678901234567, chars_format::scientific, "1.2345678901234567e+00"},

    // Ryu d2s_test.cc 32-bit Chunking
    {4.294967294, chars_format::scientific, "4.294967294e+00"},
    {4.294967295, chars_format::scientific, "4.294967295e+00"},
    {4.294967296, chars_format::scientific, "4.294967296e+00"},
    {4.294967297, chars_format::scientific, "4.294967297e+00"},
    {4.294967298, chars_format::scientific, "4.294967298e+00"},

    // Ryu d2s_test.cc MinMaxShift
    {0x1.0000000000000p-1019, chars_format::scientific, "1.7800590868057611e-307"},
    {0x1.fffffffffffffp-1016, chars_format::scientific, "2.8480945388892175e-306"},
    {0x1.0000000000000p-982, chars_format::scientific, "2.446494580089078e-296"},
    {0x1.fffffffffffffp-982, chars_format::scientific, "4.8929891601781557e-296"},
    {0x1.0000000000000p+54, chars_format::scientific, "1.8014398509481984e+16"},
    {0x1.fffffffffffffp+54, chars_format::scientific, "3.6028797018963964e+16"},
    {0x1.0000000000000p-716, chars_format::scientific, "2.900835519859558e-216"},
    {0x1.fffffffffffffp-716, chars_format::scientific, "5.801671039719115e-216"},
    {0x1.fa7161a4d6e0cp-89, chars_format::scientific, "3.196104012172126e-27"},

    // Ryu d2s_test.cc SmallIntegers
    {9007199254740991.0, chars_format::scientific, "9.007199254740991e+15"},
    {9007199254740992.0, chars_format::scientific, "9.007199254740992e+15"},

    {1.0, chars_format::scientific, "1e+00"},
    {12.0, chars_format::scientific, "1.2e+01"},
    {123.0, chars_format::scientific, "1.23e+02"},
    {1234.0, chars_format::scientific, "1.234e+03"},
    {12345.0, chars_format::scientific, "1.2345e+04"},
    {123456.0, chars_format::scientific, "1.23456e+05"},
    {1234567.0, chars_format::scientific, "1.234567e+06"},
    {12345678.0, chars_format::scientific, "1.2345678e+07"},
    {123456789.0, chars_format::scientific, "1.23456789e+08"},
    {1234567890.0, chars_format::scientific, "1.23456789e+09"},
    {1234567895.0, chars_format::scientific, "1.234567895e+09"},
    {12345678901.0, chars_format::scientific, "1.2345678901e+10"},
    {123456789012.0, chars_format::scientific, "1.23456789012e+11"},
    {1234567890123.0, chars_format::scientific, "1.234567890123e+12"},
    {12345678901234.0, chars_format::scientific, "1.2345678901234e+13"},
    {123456789012345.0, chars_format::scientific, "1.23456789012345e+14"},
    {1234567890123456.0, chars_format::scientific, "1.234567890123456e+15"},

    {1.0, chars_format::scientific, "1e+00"},
    {10.0, chars_format::scientific, "1e+01"},
    {100.0, chars_format::scientific, "1e+02"},
    {1000.0, chars_format::scientific, "1e+03"},
    {10000.0, chars_format::scientific, "1e+04"},
    {100000.0, chars_format::scientific, "1e+05"},
    {1000000.0, chars_format::scientific, "1e+06"},
    {10000000.0, chars_format::scientific, "1e+07"},
    {100000000.0, chars_format::scientific, "1e+08"},
    {1000000000.0, chars_format::scientific, "1e+09"},
    {10000000000.0, chars_format::scientific, "1e+10"},
    {100000000000.0, chars_format::scientific, "1e+11"},
    {1000000000000.0, chars_format::scientific, "1e+12"},
    {10000000000000.0, chars_format::scientific, "1e+13"},
    {100000000000000.0, chars_format::scientific, "1e+14"},
    {1000000000000000.0, chars_format::scientific, "1e+15"},

    {1000000000000001.0, chars_format::scientific, "1.000000000000001e+15"},
    {1000000000000010.0, chars_format::scientific, "1.00000000000001e+15"},
    {1000000000000100.0, chars_format::scientific, "1.0000000000001e+15"},
    {1000000000001000.0, chars_format::scientific, "1.000000000001e+15"},
    {1000000000010000.0, chars_format::scientific, "1.00000000001e+15"},
    {1000000000100000.0, chars_format::scientific, "1.0000000001e+15"},
    {1000000001000000.0, chars_format::scientific, "1.000000001e+15"},
    {1000000010000000.0, chars_format::scientific, "1.00000001e+15"},
    {1000000100000000.0, chars_format::scientific, "1.0000001e+15"},
    {1000001000000000.0, chars_format::scientific, "1.000001e+15"},
    {1000010000000000.0, chars_format::scientific, "1.00001e+15"},
    {1000100000000000.0, chars_format::scientific, "1.0001e+15"},
    {1001000000000000.0, chars_format::scientific, "1.001e+15"},
    {1010000000000000.0, chars_format::scientific, "1.01e+15"},
    {1100000000000000.0, chars_format::scientific, "1.1e+15"},

    {8.0, chars_format::scientific, "8e+00"},
    {64.0, chars_format::scientific, "6.4e+01"},
    {512.0, chars_format::scientific, "5.12e+02"},
    {8192.0, chars_format::scientific, "8.192e+03"},
    {65536.0, chars_format::scientific, "6.5536e+04"},
    {524288.0, chars_format::scientific, "5.24288e+05"},
    {8388608.0, chars_format::scientific, "8.388608e+06"},
    {67108864.0, chars_format::scientific, "6.7108864e+07"},
    {536870912.0, chars_format::scientific, "5.36870912e+08"},
    {8589934592.0, chars_format::scientific, "8.589934592e+09"},
    {68719476736.0, chars_format::scientific, "6.8719476736e+10"},
    {549755813888.0, chars_format::scientific, "5.49755813888e+11"},
    {8796093022208.0, chars_format::scientific, "8.796093022208e+12"},
    {70368744177664.0, chars_format::scientific, "7.0368744177664e+13"},
    {562949953421312.0, chars_format::scientific, "5.62949953421312e+14"},
    {9007199254740992.0, chars_format::scientific, "9.007199254740992e+15"},

    {8000.0, chars_format::scientific, "8e+03"},
    {64000.0, chars_format::scientific, "6.4e+04"},
    {512000.0, chars_format::scientific, "5.12e+05"},
    {8192000.0, chars_format::scientific, "8.192e+06"},
    {65536000.0, chars_format::scientific, "6.5536e+07"},
    {524288000.0, chars_format::scientific, "5.24288e+08"},
    {8388608000.0, chars_format::scientific, "8.388608e+09"},
    {67108864000.0, chars_format::scientific, "6.7108864e+10"},
    {536870912000.0, chars_format::scientific, "5.36870912e+11"},
    {8589934592000.0, chars_format::scientific, "8.589934592e+12"},
    {68719476736000.0, chars_format::scientific, "6.8719476736e+13"},
    {549755813888000.0, chars_format::scientific, "5.49755813888e+14"},
    {8796093022208000.0, chars_format::scientific, "8.796093022208e+15"},

    // Test all exponents.
    {7.29e-324, chars_format::scientific, "5e-324"}, // 1.729e-324 would be too small
    {1.729e-323, chars_format::scientific, "1.5e-323"},
    {1.729e-322, chars_format::scientific, "1.73e-322"},
    {1.729e-321, chars_format::scientific, "1.73e-321"},
    {1.729e-320, chars_format::scientific, "1.729e-320"},
    {1.729e-319, chars_format::scientific, "1.729e-319"},
    {1.729e-318, chars_format::scientific, "1.729e-318"},
    {1.729e-317, chars_format::scientific, "1.729e-317"},
    {1.729e-316, chars_format::scientific, "1.729e-316"},
    {1.729e-315, chars_format::scientific, "1.729e-315"},
    {1.729e-314, chars_format::scientific, "1.729e-314"},
    {1.729e-313, chars_format::scientific, "1.729e-313"},
    {1.729e-312, chars_format::scientific, "1.729e-312"},
    {1.729e-311, chars_format::scientific, "1.729e-311"},
    {1.729e-310, chars_format::scientific, "1.729e-310"},
    {1.729e-309, chars_format::scientific, "1.729e-309"},
    {1.729e-308, chars_format::scientific, "1.729e-308"},
    {1.729e-307, chars_format::scientific, "1.729e-307"},
    {1.729e-306, chars_format::scientific, "1.729e-306"},
    {1.729e-305, chars_format::scientific, "1.729e-305"},
    {1.729e-304, chars_format::scientific, "1.729e-304"},
    {1.729e-303, chars_format::scientific, "1.729e-303"},
    {1.729e-302, chars_format::scientific, "1.729e-302"},
    {1.729e-301, chars_format::scientific, "1.729e-301"},
    {1.729e-300, chars_format::scientific, "1.729e-300"},
    {1.729e-299, chars_format::scientific, "1.729e-299"},
    {1.729e-298, chars_format::scientific, "1.729e-298"},
    {1.729e-297, chars_format::scientific, "1.729e-297"},
    {1.729e-296, chars_format::scientific, "1.729e-296"},
    {1.729e-295, chars_format::scientific, "1.729e-295"},
    {1.729e-294, chars_format::scientific, "1.729e-294"},
    {1.729e-293, chars_format::scientific, "1.729e-293"},
    {1.729e-292, chars_format::scientific, "1.729e-292"},
    {1.729e-291, chars_format::scientific, "1.729e-291"},
    {1.729e-290, chars_format::scientific, "1.729e-290"},
    {1.729e-289, chars_format::scientific, "1.729e-289"},
    {1.729e-288, chars_format::scientific, "1.729e-288"},
    {1.729e-287, chars_format::scientific, "1.729e-287"},
    {1.729e-286, chars_format::scientific, "1.729e-286"},
    {1.729e-285, chars_format::scientific, "1.729e-285"},
    {1.729e-284, chars_format::scientific, "1.729e-284"},
    {1.729e-283, chars_format::scientific, "1.729e-283"},
    {1.729e-282, chars_format::scientific, "1.729e-282"},
    {1.729e-281, chars_format::scientific, "1.729e-281"},
    {1.729e-280, chars_format::scientific, "1.729e-280"},
    {1.729e-279, chars_format::scientific, "1.729e-279"},
    {1.729e-278, chars_format::scientific, "1.729e-278"},
    {1.729e-277, chars_format::scientific, "1.729e-277"},
    {1.729e-276, chars_format::scientific, "1.729e-276"},
    {1.729e-275, chars_format::scientific, "1.729e-275"},
    {1.729e-274, chars_format::scientific, "1.729e-274"},
    {1.729e-273, chars_format::scientific, "1.729e-273"},
    {1.729e-272, chars_format::scientific, "1.729e-272"},
    {1.729e-271, chars_format::scientific, "1.729e-271"},
    {1.729e-270, chars_format::scientific, "1.729e-270"},
    {1.729e-269, chars_format::scientific, "1.729e-269"},
    {1.729e-268, chars_format::scientific, "1.729e-268"},
    {1.729e-267, chars_format::scientific, "1.729e-267"},
    {1.729e-266, chars_format::scientific, "1.729e-266"},
    {1.729e-265, chars_format::scientific, "1.729e-265"},
    {1.729e-264, chars_format::scientific, "1.729e-264"},
    {1.729e-263, chars_format::scientific, "1.729e-263"},
    {1.729e-262, chars_format::scientific, "1.729e-262"},
    {1.729e-261, chars_format::scientific, "1.729e-261"},
    {1.729e-260, chars_format::scientific, "1.729e-260"},
    {1.729e-259, chars_format::scientific, "1.729e-259"},
    {1.729e-258, chars_format::scientific, "1.729e-258"},
    {1.729e-257, chars_format::scientific, "1.729e-257"},
    {1.729e-256, chars_format::scientific, "1.729e-256"},
    {1.729e-255, chars_format::scientific, "1.729e-255"},
    {1.729e-254, chars_format::scientific, "1.729e-254"},
    {1.729e-253, chars_format::scientific, "1.729e-253"},
    {1.729e-252, chars_format::scientific, "1.729e-252"},
    {1.729e-251, chars_format::scientific, "1.729e-251"},
    {1.729e-250, chars_format::scientific, "1.729e-250"},
    {1.729e-249, chars_format::scientific, "1.729e-249"},
    {1.729e-248, chars_format::scientific, "1.729e-248"},
    {1.729e-247, chars_format::scientific, "1.729e-247"},
    {1.729e-246, chars_format::scientific, "1.729e-246"},
    {1.729e-245, chars_format::scientific, "1.729e-245"},
    {1.729e-244, chars_format::scientific, "1.729e-244"},
    {1.729e-243, chars_format::scientific, "1.729e-243"},
    {1.729e-242, chars_format::scientific, "1.729e-242"},
    {1.729e-241, chars_format::scientific, "1.729e-241"},
    {1.729e-240, chars_format::scientific, "1.729e-240"},
    {1.729e-239, chars_format::scientific, "1.729e-239"},
    {1.729e-238, chars_format::scientific, "1.729e-238"},
    {1.729e-237, chars_format::scientific, "1.729e-237"},
    {1.729e-236, chars_format::scientific, "1.729e-236"},
    {1.729e-235, chars_format::scientific, "1.729e-235"},
    {1.729e-234, chars_format::scientific, "1.729e-234"},
    {1.729e-233, chars_format::scientific, "1.729e-233"},
    {1.729e-232, chars_format::scientific, "1.729e-232"},
    {1.729e-231, chars_format::scientific, "1.729e-231"},
    {1.729e-230, chars_format::scientific, "1.729e-230"},
    {1.729e-229, chars_format::scientific, "1.729e-229"},
    {1.729e-228, chars_format::scientific, "1.729e-228"},
    {1.729e-227, chars_format::scientific, "1.729e-227"},
    {1.729e-226, chars_format::scientific, "1.729e-226"},
    {1.729e-225, chars_format::scientific, "1.729e-225"},
    {1.729e-224, chars_format::scientific, "1.729e-224"},
    {1.729e-223, chars_format::scientific, "1.729e-223"},
    {1.729e-222, chars_format::scientific, "1.729e-222"},
    {1.729e-221, chars_format::scientific, "1.729e-221"},
    {1.729e-220, chars_format::scientific, "1.729e-220"},
    {1.729e-219, chars_format::scientific, "1.729e-219"},
    {1.729e-218, chars_format::scientific, "1.729e-218"},
    {1.729e-217, chars_format::scientific, "1.729e-217"},
    {1.729e-216, chars_format::scientific, "1.729e-216"},
    {1.729e-215, chars_format::scientific, "1.729e-215"},
    {1.729e-214, chars_format::scientific, "1.729e-214"},
    {1.729e-213, chars_format::scientific, "1.729e-213"},
    {1.729e-212, chars_format::scientific, "1.729e-212"},
    {1.729e-211, chars_format::scientific, "1.729e-211"},
    {1.729e-210, chars_format::scientific, "1.729e-210"},
    {1.729e-209, chars_format::scientific, "1.729e-209"},
    {1.729e-208, chars_format::scientific, "1.729e-208"},
    {1.729e-207, chars_format::scientific, "1.729e-207"},
    {1.729e-206, chars_format::scientific, "1.729e-206"},
    {1.729e-205, chars_format::scientific, "1.729e-205"},
    {1.729e-204, chars_format::scientific, "1.729e-204"},
    {1.729e-203, chars_format::scientific, "1.729e-203"},
    {1.729e-202, chars_format::scientific, "1.729e-202"},
    {1.729e-201, chars_format::scientific, "1.729e-201"},
    {1.729e-200, chars_format::scientific, "1.729e-200"},
    {1.729e-199, chars_format::scientific, "1.729e-199"},
    {1.729e-198, chars_format::scientific, "1.729e-198"},
    {1.729e-197, chars_format::scientific, "1.729e-197"},
    {1.729e-196, chars_format::scientific, "1.729e-196"},
    {1.729e-195, chars_format::scientific, "1.729e-195"},
    {1.729e-194, chars_format::scientific, "1.729e-194"},
    {1.729e-193, chars_format::scientific, "1.729e-193"},
    {1.729e-192, chars_format::scientific, "1.729e-192"},
    {1.729e-191, chars_format::scientific, "1.729e-191"},
    {1.729e-190, chars_format::scientific, "1.729e-190"},
    {1.729e-189, chars_format::scientific, "1.729e-189"},
    {1.729e-188, chars_format::scientific, "1.729e-188"},
    {1.729e-187, chars_format::scientific, "1.729e-187"},
    {1.729e-186, chars_format::scientific, "1.729e-186"},
    {1.729e-185, chars_format::scientific, "1.729e-185"},
    {1.729e-184, chars_format::scientific, "1.729e-184"},
    {1.729e-183, chars_format::scientific, "1.729e-183"},
    {1.729e-182, chars_format::scientific, "1.729e-182"},
    {1.729e-181, chars_format::scientific, "1.729e-181"},
    {1.729e-180, chars_format::scientific, "1.729e-180"},
    {1.729e-179, chars_format::scientific, "1.729e-179"},
    {1.729e-178, chars_format::scientific, "1.729e-178"},
    {1.729e-177, chars_format::scientific, "1.729e-177"},
    {1.729e-176, chars_format::scientific, "1.729e-176"},
    {1.729e-175, chars_format::scientific, "1.729e-175"},
    {1.729e-174, chars_format::scientific, "1.729e-174"},
    {1.729e-173, chars_format::scientific, "1.729e-173"},
    {1.729e-172, chars_format::scientific, "1.729e-172"},
    {1.729e-171, chars_format::scientific, "1.729e-171"},
    {1.729e-170, chars_format::scientific, "1.729e-170"},
    {1.729e-169, chars_format::scientific, "1.729e-169"},
    {1.729e-168, chars_format::scientific, "1.729e-168"},
    {1.729e-167, chars_format::scientific, "1.729e-167"},
    {1.729e-166, chars_format::scientific, "1.729e-166"},
    {1.729e-165, chars_format::scientific, "1.729e-165"},
    {1.729e-164, chars_format::scientific, "1.729e-164"},
    {1.729e-163, chars_format::scientific, "1.729e-163"},
    {1.729e-162, chars_format::scientific, "1.729e-162"},
    {1.729e-161, chars_format::scientific, "1.729e-161"},
    {1.729e-160, chars_format::scientific, "1.729e-160"},
    {1.729e-159, chars_format::scientific, "1.729e-159"},
    {1.729e-158, chars_format::scientific, "1.729e-158"},
    {1.729e-157, chars_format::scientific, "1.729e-157"},
    {1.729e-156, chars_format::scientific, "1.729e-156"},
    {1.729e-155, chars_format::scientific, "1.729e-155"},
    {1.729e-154, chars_format::scientific, "1.729e-154"},
    {1.729e-153, chars_format::scientific, "1.729e-153"},
    {1.729e-152, chars_format::scientific, "1.729e-152"},
    {1.729e-151, chars_format::scientific, "1.729e-151"},
    {1.729e-150, chars_format::scientific, "1.729e-150"},
    {1.729e-149, chars_format::scientific, "1.729e-149"},
    {1.729e-148, chars_format::scientific, "1.729e-148"},
    {1.729e-147, chars_format::scientific, "1.729e-147"},
    {1.729e-146, chars_format::scientific, "1.729e-146"},
    {1.729e-145, chars_format::scientific, "1.729e-145"},
    {1.729e-144, chars_format::scientific, "1.729e-144"},
    {1.729e-143, chars_format::scientific, "1.729e-143"},
    {1.729e-142, chars_format::scientific, "1.729e-142"},
    {1.729e-141, chars_format::scientific, "1.729e-141"},
    {1.729e-140, chars_format::scientific, "1.729e-140"},
    {1.729e-139, chars_format::scientific, "1.729e-139"},
    {1.729e-138, chars_format::scientific, "1.729e-138"},
    {1.729e-137, chars_format::scientific, "1.729e-137"},
    {1.729e-136, chars_format::scientific, "1.729e-136"},
    {1.729e-135, chars_format::scientific, "1.729e-135"},
    {1.729e-134, chars_format::scientific, "1.729e-134"},
    {1.729e-133, chars_format::scientific, "1.729e-133"},
    {1.729e-132, chars_format::scientific, "1.729e-132"},
    {1.729e-131, chars_format::scientific, "1.729e-131"},
    {1.729e-130, chars_format::scientific, "1.729e-130"},
    {1.729e-129, chars_format::scientific, "1.729e-129"},
    {1.729e-128, chars_format::scientific, "1.729e-128"},
    {1.729e-127, chars_format::scientific, "1.729e-127"},
    {1.729e-126, chars_format::scientific, "1.729e-126"},
    {1.729e-125, chars_format::scientific, "1.729e-125"},
    {1.729e-124, chars_format::scientific, "1.729e-124"},
    {1.729e-123, chars_format::scientific, "1.729e-123"},
    {1.729e-122, chars_format::scientific, "1.729e-122"},
    {1.729e-121, chars_format::scientific, "1.729e-121"},
    {1.729e-120, chars_format::scientific, "1.729e-120"},
    {1.729e-119, chars_format::scientific, "1.729e-119"},
    {1.729e-118, chars_format::scientific, "1.729e-118"},
    {1.729e-117, chars_format::scientific, "1.729e-117"},
    {1.729e-116, chars_format::scientific, "1.729e-116"},
    {1.729e-115, chars_format::scientific, "1.729e-115"},
    {1.729e-114, chars_format::scientific, "1.729e-114"},
    {1.729e-113, chars_format::scientific, "1.729e-113"},
    {1.729e-112, chars_format::scientific, "1.729e-112"},
    {1.729e-111, chars_format::scientific, "1.729e-111"},
    {1.729e-110, chars_format::scientific, "1.729e-110"},
    {1.729e-109, chars_format::scientific, "1.729e-109"},
    {1.729e-108, chars_format::scientific, "1.729e-108"},
    {1.729e-107, chars_format::scientific, "1.729e-107"},
    {1.729e-106, chars_format::scientific, "1.729e-106"},
    {1.729e-105, chars_format::scientific, "1.729e-105"},
    {1.729e-104, chars_format::scientific, "1.729e-104"},
    {1.729e-103, chars_format::scientific, "1.729e-103"},
    {1.729e-102, chars_format::scientific, "1.729e-102"},
    {1.729e-101, chars_format::scientific, "1.729e-101"},
    {1.729e-100, chars_format::scientific, "1.729e-100"},
    {1.729e-99, chars_format::scientific, "1.729e-99"},
    {1.729e-98, chars_format::scientific, "1.729e-98"},
    {1.729e-97, chars_format::scientific, "1.729e-97"},
    {1.729e-96, chars_format::scientific, "1.729e-96"},
    {1.729e-95, chars_format::scientific, "1.729e-95"},
    {1.729e-94, chars_format::scientific, "1.729e-94"},
    {1.729e-93, chars_format::scientific, "1.729e-93"},
    {1.729e-92, chars_format::scientific, "1.729e-92"},
    {1.729e-91, chars_format::scientific, "1.729e-91"},
    {1.729e-90, chars_format::scientific, "1.729e-90"},
    {1.729e-89, chars_format::scientific, "1.729e-89"},
    {1.729e-88, chars_format::scientific, "1.729e-88"},
    {1.729e-87, chars_format::scientific, "1.729e-87"},
    {1.729e-86, chars_format::scientific, "1.729e-86"},
    {1.729e-85, chars_format::scientific, "1.729e-85"},
    {1.729e-84, chars_format::scientific, "1.729e-84"},
    {1.729e-83, chars_format::scientific, "1.729e-83"},
    {1.729e-82, chars_format::scientific, "1.729e-82"},
    {1.729e-81, chars_format::scientific, "1.729e-81"},
    {1.729e-80, chars_format::scientific, "1.729e-80"},
    {1.729e-79, chars_format::scientific, "1.729e-79"},
    {1.729e-78, chars_format::scientific, "1.729e-78"},
    {1.729e-77, chars_format::scientific, "1.729e-77"},
    {1.729e-76, chars_format::scientific, "1.729e-76"},
    {1.729e-75, chars_format::scientific, "1.729e-75"},
    {1.729e-74, chars_format::scientific, "1.729e-74"},
    {1.729e-73, chars_format::scientific, "1.729e-73"},
    {1.729e-72, chars_format::scientific, "1.729e-72"},
    {1.729e-71, chars_format::scientific, "1.729e-71"},
    {1.729e-70, chars_format::scientific, "1.729e-70"},
    {1.729e-69, chars_format::scientific, "1.729e-69"},
    {1.729e-68, chars_format::scientific, "1.729e-68"},
    {1.729e-67, chars_format::scientific, "1.729e-67"},
    {1.729e-66, chars_format::scientific, "1.729e-66"},
    {1.729e-65, chars_format::scientific, "1.729e-65"},
    {1.729e-64, chars_format::scientific, "1.729e-64"},
    {1.729e-63, chars_format::scientific, "1.729e-63"},
    {1.729e-62, chars_format::scientific, "1.729e-62"},
    {1.729e-61, chars_format::scientific, "1.729e-61"},
    {1.729e-60, chars_format::scientific, "1.729e-60"},
    {1.729e-59, chars_format::scientific, "1.729e-59"},
    {1.729e-58, chars_format::scientific, "1.729e-58"},
    {1.729e-57, chars_format::scientific, "1.729e-57"},
    {1.729e-56, chars_format::scientific, "1.729e-56"},
    {1.729e-55, chars_format::scientific, "1.729e-55"},
    {1.729e-54, chars_format::scientific, "1.729e-54"},
    {1.729e-53, chars_format::scientific, "1.729e-53"},
    {1.729e-52, chars_format::scientific, "1.729e-52"},
    {1.729e-51, chars_format::scientific, "1.729e-51"},
    {1.729e-50, chars_format::scientific, "1.729e-50"},
    {1.729e-49, chars_format::scientific, "1.729e-49"},
    {1.729e-48, chars_format::scientific, "1.729e-48"},
    {1.729e-47, chars_format::scientific, "1.729e-47"},
    {1.729e-46, chars_format::scientific, "1.729e-46"},
    {1.729e-45, chars_format::scientific, "1.729e-45"},
    {1.729e-44, chars_format::scientific, "1.729e-44"},
    {1.729e-43, chars_format::scientific, "1.729e-43"},
    {1.729e-42, chars_format::scientific, "1.729e-42"},
    {1.729e-41, chars_format::scientific, "1.729e-41"},
    {1.729e-40, chars_format::scientific, "1.729e-40"},
    {1.729e-39, chars_format::scientific, "1.729e-39"},
    {1.729e-38, chars_format::scientific, "1.729e-38"},
    {1.729e-37, chars_format::scientific, "1.729e-37"},
    {1.729e-36, chars_format::scientific, "1.729e-36"},
    {1.729e-35, chars_format::scientific, "1.729e-35"},
    {1.729e-34, chars_format::scientific, "1.729e-34"},
    {1.729e-33, chars_format::scientific, "1.729e-33"},
    {1.729e-32, chars_format::scientific, "1.729e-32"},
    {1.729e-31, chars_format::scientific, "1.729e-31"},
    {1.729e-30, chars_format::scientific, "1.729e-30"},
    {1.729e-29, chars_format::scientific, "1.729e-29"},
    {1.729e-28, chars_format::scientific, "1.729e-28"},
    {1.729e-27, chars_format::scientific, "1.729e-27"},
    {1.729e-26, chars_format::scientific, "1.729e-26"},
    {1.729e-25, chars_format::scientific, "1.729e-25"},
    {1.729e-24, chars_format::scientific, "1.729e-24"},
    {1.729e-23, chars_format::scientific, "1.729e-23"},
    {1.729e-22, chars_format::scientific, "1.729e-22"},
    {1.729e-21, chars_format::scientific, "1.729e-21"},
    {1.729e-20, chars_format::scientific, "1.729e-20"},
    {1.729e-19, chars_format::scientific, "1.729e-19"},
    {1.729e-18, chars_format::scientific, "1.729e-18"},
    {1.729e-17, chars_format::scientific, "1.729e-17"},
    {1.729e-16, chars_format::scientific, "1.729e-16"},
    {1.729e-15, chars_format::scientific, "1.729e-15"},
    {1.729e-14, chars_format::scientific, "1.729e-14"},
    {1.729e-13, chars_format::scientific, "1.729e-13"},
    {1.729e-12, chars_format::scientific, "1.729e-12"},
    {1.729e-11, chars_format::scientific, "1.729e-11"},
    {1.729e-10, chars_format::scientific, "1.729e-10"},
    {1.729e-9, chars_format::scientific, "1.729e-09"},
    {1.729e-8, chars_format::scientific, "1.729e-08"},
    {1.729e-7, chars_format::scientific, "1.729e-07"},
    {1.729e-6, chars_format::scientific, "1.729e-06"},
    {1.729e-5, chars_format::scientific, "1.729e-05"},
    {1.729e-4, chars_format::scientific, "1.729e-04"},
    {1.729e-3, chars_format::scientific, "1.729e-03"},
    {1.729e-2, chars_format::scientific, "1.729e-02"},
    {1.729e-1, chars_format::scientific, "1.729e-01"},
    {1.729e0, chars_format::scientific, "1.729e+00"},
    {1.729e1, chars_format::scientific, "1.729e+01"},
    {1.729e2, chars_format::scientific, "1.729e+02"},
    {1.729e3, chars_format::scientific, "1.729e+03"},
    {1.729e4, chars_format::scientific, "1.729e+04"},
    {1.729e5, chars_format::scientific, "1.729e+05"},
    {1.729e6, chars_format::scientific, "1.729e+06"},
    {1.729e7, chars_format::scientific, "1.729e+07"},
    {1.729e8, chars_format::scientific, "1.729e+08"},
    {1.729e9, chars_format::scientific, "1.729e+09"},
    {1.729e10, chars_format::scientific, "1.729e+10"},
    {1.729e11, chars_format::scientific, "1.729e+11"},
    {1.729e12, chars_format::scientific, "1.729e+12"},
    {1.729e13, chars_format::scientific, "1.729e+13"},
    {1.729e14, chars_format::scientific, "1.729e+14"},
    {1.729e15, chars_format::scientific, "1.729e+15"},
    {1.729e16, chars_format::scientific, "1.729e+16"},
    {1.729e17, chars_format::scientific, "1.729e+17"},
    {1.729e18, chars_format::scientific, "1.729e+18"},
    {1.729e19, chars_format::scientific, "1.729e+19"},
    {1.729e20, chars_format::scientific, "1.729e+20"},
    {1.729e21, chars_format::scientific, "1.729e+21"},
    {1.729e22, chars_format::scientific, "1.729e+22"},
    {1.729e23, chars_format::scientific, "1.729e+23"},
    {1.729e24, chars_format::scientific, "1.729e+24"},
    {1.729e25, chars_format::scientific, "1.729e+25"},
    {1.729e26, chars_format::scientific, "1.729e+26"},
    {1.729e27, chars_format::scientific, "1.729e+27"},
    {1.729e28, chars_format::scientific, "1.729e+28"},
    {1.729e29, chars_format::scientific, "1.729e+29"},
    {1.729e30, chars_format::scientific, "1.729e+30"},
    {1.729e31, chars_format::scientific, "1.729e+31"},
    {1.729e32, chars_format::scientific, "1.729e+32"},
    {1.729e33, chars_format::scientific, "1.729e+33"},
    {1.729e34, chars_format::scientific, "1.729e+34"},
    {1.729e35, chars_format::scientific, "1.729e+35"},
    {1.729e36, chars_format::scientific, "1.729e+36"},
    {1.729e37, chars_format::scientific, "1.729e+37"},
    {1.729e38, chars_format::scientific, "1.729e+38"},
    {1.729e39, chars_format::scientific, "1.729e+39"},
    {1.729e40, chars_format::scientific, "1.729e+40"},
    {1.729e41, chars_format::scientific, "1.729e+41"},
    {1.729e42, chars_format::scientific, "1.729e+42"},
    {1.729e43, chars_format::scientific, "1.729e+43"},
    {1.729e44, chars_format::scientific, "1.729e+44"},
    {1.729e45, chars_format::scientific, "1.729e+45"},
    {1.729e46, chars_format::scientific, "1.729e+46"},
    {1.729e47, chars_format::scientific, "1.729e+47"},
    {1.729e48, chars_format::scientific, "1.729e+48"},
    {1.729e49, chars_format::scientific, "1.729e+49"},
    {1.729e50, chars_format::scientific, "1.729e+50"},
    {1.729e51, chars_format::scientific, "1.729e+51"},
    {1.729e52, chars_format::scientific, "1.729e+52"},
    {1.729e53, chars_format::scientific, "1.729e+53"},
    {1.729e54, chars_format::scientific, "1.729e+54"},
    {1.729e55, chars_format::scientific, "1.729e+55"},
    {1.729e56, chars_format::scientific, "1.729e+56"},
    {1.729e57, chars_format::scientific, "1.729e+57"},
    {1.729e58, chars_format::scientific, "1.729e+58"},
    {1.729e59, chars_format::scientific, "1.729e+59"},
    {1.729e60, chars_format::scientific, "1.729e+60"},
    {1.729e61, chars_format::scientific, "1.729e+61"},
    {1.729e62, chars_format::scientific, "1.729e+62"},
    {1.729e63, chars_format::scientific, "1.729e+63"},
    {1.729e64, chars_format::scientific, "1.729e+64"},
    {1.729e65, chars_format::scientific, "1.729e+65"},
    {1.729e66, chars_format::scientific, "1.729e+66"},
    {1.729e67, chars_format::scientific, "1.729e+67"},
    {1.729e68, chars_format::scientific, "1.729e+68"},
    {1.729e69, chars_format::scientific, "1.729e+69"},
    {1.729e70, chars_format::scientific, "1.729e+70"},
    {1.729e71, chars_format::scientific, "1.729e+71"},
    {1.729e72, chars_format::scientific, "1.729e+72"},
    {1.729e73, chars_format::scientific, "1.729e+73"},
    {1.729e74, chars_format::scientific, "1.729e+74"},
    {1.729e75, chars_format::scientific, "1.729e+75"},
    {1.729e76, chars_format::scientific, "1.729e+76"},
    {1.729e77, chars_format::scientific, "1.729e+77"},
    {1.729e78, chars_format::scientific, "1.729e+78"},
    {1.729e79, chars_format::scientific, "1.729e+79"},
    {1.729e80, chars_format::scientific, "1.729e+80"},
    {1.729e81, chars_format::scientific, "1.729e+81"},
    {1.729e82, chars_format::scientific, "1.729e+82"},
    {1.729e83, chars_format::scientific, "1.729e+83"},
    {1.729e84, chars_format::scientific, "1.729e+84"},
    {1.729e85, chars_format::scientific, "1.729e+85"},
    {1.729e86, chars_format::scientific, "1.729e+86"},
    {1.729e87, chars_format::scientific, "1.729e+87"},
    {1.729e88, chars_format::scientific, "1.729e+88"},
    {1.729e89, chars_format::scientific, "1.729e+89"},
    {1.729e90, chars_format::scientific, "1.729e+90"},
    {1.729e91, chars_format::scientific, "1.729e+91"},
    {1.729e92, chars_format::scientific, "1.729e+92"},
    {1.729e93, chars_format::scientific, "1.729e+93"},
    {1.729e94, chars_format::scientific, "1.729e+94"},
    {1.729e95, chars_format::scientific, "1.729e+95"},
    {1.729e96, chars_format::scientific, "1.729e+96"},
    {1.729e97, chars_format::scientific, "1.729e+97"},
    {1.729e98, chars_format::scientific, "1.729e+98"},
    {1.729e99, chars_format::scientific, "1.729e+99"},
    {1.729e100, chars_format::scientific, "1.729e+100"},
    {1.729e101, chars_format::scientific, "1.729e+101"},
    {1.729e102, chars_format::scientific, "1.729e+102"},
    {1.729e103, chars_format::scientific, "1.729e+103"},
    {1.729e104, chars_format::scientific, "1.729e+104"},
    {1.729e105, chars_format::scientific, "1.729e+105"},
    {1.729e106, chars_format::scientific, "1.729e+106"},
    {1.729e107, chars_format::scientific, "1.729e+107"},
    {1.729e108, chars_format::scientific, "1.729e+108"},
    {1.729e109, chars_format::scientific, "1.729e+109"},
    {1.729e110, chars_format::scientific, "1.729e+110"},
    {1.729e111, chars_format::scientific, "1.729e+111"},
    {1.729e112, chars_format::scientific, "1.729e+112"},
    {1.729e113, chars_format::scientific, "1.729e+113"},
    {1.729e114, chars_format::scientific, "1.729e+114"},
    {1.729e115, chars_format::scientific, "1.729e+115"},
    {1.729e116, chars_format::scientific, "1.729e+116"},
    {1.729e117, chars_format::scientific, "1.729e+117"},
    {1.729e118, chars_format::scientific, "1.729e+118"},
    {1.729e119, chars_format::scientific, "1.729e+119"},
    {1.729e120, chars_format::scientific, "1.729e+120"},
    {1.729e121, chars_format::scientific, "1.729e+121"},
    {1.729e122, chars_format::scientific, "1.729e+122"},
    {1.729e123, chars_format::scientific, "1.729e+123"},
    {1.729e124, chars_format::scientific, "1.729e+124"},
    {1.729e125, chars_format::scientific, "1.729e+125"},
    {1.729e126, chars_format::scientific, "1.729e+126"},
    {1.729e127, chars_format::scientific, "1.729e+127"},
    {1.729e128, chars_format::scientific, "1.729e+128"},
    {1.729e129, chars_format::scientific, "1.729e+129"},
    {1.729e130, chars_format::scientific, "1.729e+130"},
    {1.729e131, chars_format::scientific, "1.729e+131"},
    {1.729e132, chars_format::scientific, "1.729e+132"},
    {1.729e133, chars_format::scientific, "1.729e+133"},
    {1.729e134, chars_format::scientific, "1.729e+134"},
    {1.729e135, chars_format::scientific, "1.729e+135"},
    {1.729e136, chars_format::scientific, "1.729e+136"},
    {1.729e137, chars_format::scientific, "1.729e+137"},
    {1.729e138, chars_format::scientific, "1.729e+138"},
    {1.729e139, chars_format::scientific, "1.729e+139"},
    {1.729e140, chars_format::scientific, "1.729e+140"},
    {1.729e141, chars_format::scientific, "1.729e+141"},
    {1.729e142, chars_format::scientific, "1.729e+142"},
    {1.729e143, chars_format::scientific, "1.729e+143"},
    {1.729e144, chars_format::scientific, "1.729e+144"},
    {1.729e145, chars_format::scientific, "1.729e+145"},
    {1.729e146, chars_format::scientific, "1.729e+146"},
    {1.729e147, chars_format::scientific, "1.729e+147"},
    {1.729e148, chars_format::scientific, "1.729e+148"},
    {1.729e149, chars_format::scientific, "1.729e+149"},
    {1.729e150, chars_format::scientific, "1.729e+150"},
    {1.729e151, chars_format::scientific, "1.729e+151"},
    {1.729e152, chars_format::scientific, "1.729e+152"},
    {1.729e153, chars_format::scientific, "1.729e+153"},
    {1.729e154, chars_format::scientific, "1.729e+154"},
    {1.729e155, chars_format::scientific, "1.729e+155"},
    {1.729e156, chars_format::scientific, "1.729e+156"},
    {1.729e157, chars_format::scientific, "1.729e+157"},
    {1.729e158, chars_format::scientific, "1.729e+158"},
    {1.729e159, chars_format::scientific, "1.729e+159"},
    {1.729e160, chars_format::scientific, "1.729e+160"},
    {1.729e161, chars_format::scientific, "1.729e+161"},
    {1.729e162, chars_format::scientific, "1.729e+162"},
    {1.729e163, chars_format::scientific, "1.729e+163"},
    {1.729e164, chars_format::scientific, "1.729e+164"},
    {1.729e165, chars_format::scientific, "1.729e+165"},
    {1.729e166, chars_format::scientific, "1.729e+166"},
    {1.729e167, chars_format::scientific, "1.729e+167"},
    {1.729e168, chars_format::scientific, "1.729e+168"},
    {1.729e169, chars_format::scientific, "1.729e+169"},
    {1.729e170, chars_format::scientific, "1.729e+170"},
    {1.729e171, chars_format::scientific, "1.729e+171"},
    {1.729e172, chars_format::scientific, "1.729e+172"},
    {1.729e173, chars_format::scientific, "1.729e+173"},
    {1.729e174, chars_format::scientific, "1.729e+174"},
    {1.729e175, chars_format::scientific, "1.729e+175"},
    {1.729e176, chars_format::scientific, "1.729e+176"},
    {1.729e177, chars_format::scientific, "1.729e+177"},
    {1.729e178, chars_format::scientific, "1.729e+178"},
    {1.729e179, chars_format::scientific, "1.729e+179"},
    {1.729e180, chars_format::scientific, "1.729e+180"},
    {1.729e181, chars_format::scientific, "1.729e+181"},
    {1.729e182, chars_format::scientific, "1.729e+182"},
    {1.729e183, chars_format::scientific, "1.729e+183"},
    {1.729e184, chars_format::scientific, "1.729e+184"},
    {1.729e185, chars_format::scientific, "1.729e+185"},
    {1.729e186, chars_format::scientific, "1.729e+186"},
    {1.729e187, chars_format::scientific, "1.729e+187"},
    {1.729e188, chars_format::scientific, "1.729e+188"},
    {1.729e189, chars_format::scientific, "1.729e+189"},
    {1.729e190, chars_format::scientific, "1.729e+190"},
    {1.729e191, chars_format::scientific, "1.729e+191"},
    {1.729e192, chars_format::scientific, "1.729e+192"},
    {1.729e193, chars_format::scientific, "1.729e+193"},
    {1.729e194, chars_format::scientific, "1.729e+194"},
    {1.729e195, chars_format::scientific, "1.729e+195"},
    {1.729e196, chars_format::scientific, "1.729e+196"},
    {1.729e197, chars_format::scientific, "1.729e+197"},
    {1.729e198, chars_format::scientific, "1.729e+198"},
    {1.729e199, chars_format::scientific, "1.729e+199"},
    {1.729e200, chars_format::scientific, "1.729e+200"},
    {1.729e201, chars_format::scientific, "1.729e+201"},
    {1.729e202, chars_format::scientific, "1.729e+202"},
    {1.729e203, chars_format::scientific, "1.729e+203"},
    {1.729e204, chars_format::scientific, "1.729e+204"},
    {1.729e205, chars_format::scientific, "1.729e+205"},
    {1.729e206, chars_format::scientific, "1.729e+206"},
    {1.729e207, chars_format::scientific, "1.729e+207"},
    {1.729e208, chars_format::scientific, "1.729e+208"},
    {1.729e209, chars_format::scientific, "1.729e+209"},
    {1.729e210, chars_format::scientific, "1.729e+210"},
    {1.729e211, chars_format::scientific, "1.729e+211"},
    {1.729e212, chars_format::scientific, "1.729e+212"},
    {1.729e213, chars_format::scientific, "1.729e+213"},
    {1.729e214, chars_format::scientific, "1.729e+214"},
    {1.729e215, chars_format::scientific, "1.729e+215"},
    {1.729e216, chars_format::scientific, "1.729e+216"},
    {1.729e217, chars_format::scientific, "1.729e+217"},
    {1.729e218, chars_format::scientific, "1.729e+218"},
    {1.729e219, chars_format::scientific, "1.729e+219"},
    {1.729e220, chars_format::scientific, "1.729e+220"},
    {1.729e221, chars_format::scientific, "1.729e+221"},
    {1.729e222, chars_format::scientific, "1.729e+222"},
    {1.729e223, chars_format::scientific, "1.729e+223"},
    {1.729e224, chars_format::scientific, "1.729e+224"},
    {1.729e225, chars_format::scientific, "1.729e+225"},
    {1.729e226, chars_format::scientific, "1.729e+226"},
    {1.729e227, chars_format::scientific, "1.729e+227"},
    {1.729e228, chars_format::scientific, "1.729e+228"},
    {1.729e229, chars_format::scientific, "1.729e+229"},
    {1.729e230, chars_format::scientific, "1.729e+230"},
    {1.729e231, chars_format::scientific, "1.729e+231"},
    {1.729e232, chars_format::scientific, "1.729e+232"},
    {1.729e233, chars_format::scientific, "1.729e+233"},
    {1.729e234, chars_format::scientific, "1.729e+234"},
    {1.729e235, chars_format::scientific, "1.729e+235"},
    {1.729e236, chars_format::scientific, "1.729e+236"},
    {1.729e237, chars_format::scientific, "1.729e+237"},
    {1.729e238, chars_format::scientific, "1.729e+238"},
    {1.729e239, chars_format::scientific, "1.729e+239"},
    {1.729e240, chars_format::scientific, "1.729e+240"},
    {1.729e241, chars_format::scientific, "1.729e+241"},
    {1.729e242, chars_format::scientific, "1.729e+242"},
    {1.729e243, chars_format::scientific, "1.729e+243"},
    {1.729e244, chars_format::scientific, "1.729e+244"},
    {1.729e245, chars_format::scientific, "1.729e+245"},
    {1.729e246, chars_format::scientific, "1.729e+246"},
    {1.729e247, chars_format::scientific, "1.729e+247"},
    {1.729e248, chars_format::scientific, "1.729e+248"},
    {1.729e249, chars_format::scientific, "1.729e+249"},
    {1.729e250, chars_format::scientific, "1.729e+250"},
    {1.729e251, chars_format::scientific, "1.729e+251"},
    {1.729e252, chars_format::scientific, "1.729e+252"},
    {1.729e253, chars_format::scientific, "1.729e+253"},
    {1.729e254, chars_format::scientific, "1.729e+254"},
    {1.729e255, chars_format::scientific, "1.729e+255"},
    {1.729e256, chars_format::scientific, "1.729e+256"},
    {1.729e257, chars_format::scientific, "1.729e+257"},
    {1.729e258, chars_format::scientific, "1.729e+258"},
    {1.729e259, chars_format::scientific, "1.729e+259"},
    {1.729e260, chars_format::scientific, "1.729e+260"},
    {1.729e261, chars_format::scientific, "1.729e+261"},
    {1.729e262, chars_format::scientific, "1.729e+262"},
    {1.729e263, chars_format::scientific, "1.729e+263"},
    {1.729e264, chars_format::scientific, "1.729e+264"},
    {1.729e265, chars_format::scientific, "1.729e+265"},
    {1.729e266, chars_format::scientific, "1.729e+266"},
    {1.729e267, chars_format::scientific, "1.729e+267"},
    {1.729e268, chars_format::scientific, "1.729e+268"},
    {1.729e269, chars_format::scientific, "1.729e+269"},
    {1.729e270, chars_format::scientific, "1.729e+270"},
    {1.729e271, chars_format::scientific, "1.729e+271"},
    {1.729e272, chars_format::scientific, "1.729e+272"},
    {1.729e273, chars_format::scientific, "1.729e+273"},
    {1.729e274, chars_format::scientific, "1.729e+274"},
    {1.729e275, chars_format::scientific, "1.729e+275"},
    {1.729e276, chars_format::scientific, "1.729e+276"},
    {1.729e277, chars_format::scientific, "1.729e+277"},
    {1.729e278, chars_format::scientific, "1.729e+278"},
    {1.729e279, chars_format::scientific, "1.729e+279"},
    {1.729e280, chars_format::scientific, "1.729e+280"},
    {1.729e281, chars_format::scientific, "1.729e+281"},
    {1.729e282, chars_format::scientific, "1.729e+282"},
    {1.729e283, chars_format::scientific, "1.729e+283"},
    {1.729e284, chars_format::scientific, "1.729e+284"},
    {1.729e285, chars_format::scientific, "1.729e+285"},
    {1.729e286, chars_format::scientific, "1.729e+286"},
    {1.729e287, chars_format::scientific, "1.729e+287"},
    {1.729e288, chars_format::scientific, "1.729e+288"},
    {1.729e289, chars_format::scientific, "1.729e+289"},
    {1.729e290, chars_format::scientific, "1.729e+290"},
    {1.729e291, chars_format::scientific, "1.729e+291"},
    {1.729e292, chars_format::scientific, "1.729e+292"},
    {1.729e293, chars_format::scientific, "1.729e+293"},
    {1.729e294, chars_format::scientific, "1.729e+294"},
    {1.729e295, chars_format::scientific, "1.729e+295"},
    {1.729e296, chars_format::scientific, "1.729e+296"},
    {1.729e297, chars_format::scientific, "1.729e+297"},
    {1.729e298, chars_format::scientific, "1.729e+298"},
    {1.729e299, chars_format::scientific, "1.729e+299"},
    {1.729e300, chars_format::scientific, "1.729e+300"},
    {1.729e301, chars_format::scientific, "1.729e+301"},
    {1.729e302, chars_format::scientific, "1.729e+302"},
    {1.729e303, chars_format::scientific, "1.729e+303"},
    {1.729e304, chars_format::scientific, "1.729e+304"},
    {1.729e305, chars_format::scientific, "1.729e+305"},
    {1.729e306, chars_format::scientific, "1.729e+306"},
    {1.729e307, chars_format::scientific, "1.729e+307"},
    {1.729e308, chars_format::scientific, "1.729e+308"},

    // Test all of the cases for fixed notation, including the non-Ryu fallback for large integers.
    {1.729e-4, chars_format::fixed, "0.0001729"},
    {1.729e-3, chars_format::fixed, "0.001729"},
    {1.729e-2, chars_format::fixed, "0.01729"},
    {1.729e-1, chars_format::fixed, "0.1729"},
    {1.729e0, chars_format::fixed, "1.729"},
    {1.729e1, chars_format::fixed, "17.29"},
    {1.729e2, chars_format::fixed, "172.9"},
    {1.729e3, chars_format::fixed, "1729"},
    {1.729e4, chars_format::fixed, "17290"},
    {1.729e5, chars_format::fixed, "172900"},
    {1.729e6, chars_format::fixed, "1729000"},
    {1.729e7, chars_format::fixed, "17290000"},
    {1.729e8, chars_format::fixed, "172900000"},
    {1.729e9, chars_format::fixed, "1729000000"},
    {1.729e10, chars_format::fixed, "17290000000"},
    {1.729e11, chars_format::fixed, "172900000000"},
    {1.729e12, chars_format::fixed, "1729000000000"},
    {1.729e13, chars_format::fixed, "17290000000000"},
    {1.729e14, chars_format::fixed, "172900000000000"},
    {1.729e15, chars_format::fixed, "1729000000000000"},
    {1.729e16, chars_format::fixed, "17290000000000000"},
    {1.729e17, chars_format::fixed, "172900000000000000"},
    {1.729e18, chars_format::fixed, "1729000000000000000"},
    {1.729e19, chars_format::fixed, "17290000000000000000"},
    {1.729e20, chars_format::fixed, "172900000000000000000"},
    {1.729e21, chars_format::fixed, "1729000000000000000000"},
    {1.729e22, chars_format::fixed, "17289999999999999475712"},
    {1.729e23, chars_format::fixed, "172900000000000015728640"},
    {1.729e24, chars_format::fixed, "1728999999999999888850944"},
    {1.729e25, chars_format::fixed, "17290000000000000499122176"},
    {1.729e26, chars_format::fixed, "172899999999999987811352576"},
    {1.729e27, chars_format::fixed, "1729000000000000084271955968"},
    {1.729e28, chars_format::fixed, "17290000000000000842719559680"},
    {1.729e29, chars_format::fixed, "172900000000000004029149085696"},
    {1.729e30, chars_format::fixed, "1728999999999999969922746679296"},
    {1.729e31, chars_format::fixed, "17290000000000000825127373635584"},
    {1.729e32, chars_format::fixed, "172899999999999994740474854244352"},
    {1.729e33, chars_format::fixed, "1729000000000000019462342580371456"},
    {1.729e34, chars_format::fixed, "17290000000000000771084178107138048"},
    {1.729e35, chars_format::fixed, "172900000000000003099155762643992576"},
    {1.729e36, chars_format::fixed, "1728999999999999957204581331601719296"},
    {1.729e37, chars_format::fixed, "17289999999999998981750002957311541248"},
    {1.729e38, chars_format::fixed, "172900000000000018151698926790986694656"},
    {1.729e39, chars_format::fixed, "1728999999999999879285534364252573270016"},
    {1.729e40, chars_format::fixed, "17289999999999999397318253449840320053248"},
    {1.729e41, chars_format::fixed, "172899999999999993973182534498403200532480"},
    {1.729e42, chars_format::fixed, "1728999999999999978417451572652165595922432"},
    {1.729e43, chars_format::fixed, "17290000000000001022114555011901930858348544"},
    {1.729e44, chars_format::fixed, "172899999999999995365865078694456009793994752"},
    {1.729e45, chars_format::fixed, "1729000000000000112114975815473235285027848192"},
    {1.729e46, chars_format::fixed, "17289999999999999853499157926502951353575276544"},
    {1.729e47, chars_format::fixed, "172900000000000003605593980177947119522565586944"},
    {1.729e48, chars_format::fixed, "1728999999999999914361482179869448651542148153344"},
    {1.729e49, chars_format::fixed, "17290000000000001090726143749254847214357604990976"},
    {1.729e50, chars_format::fixed, "172900000000000000522667720422893215082583391469568"},
    {1.729e51, chars_format::fixed, "1729000000000000046765052072507553179069804548456448"},
    {1.729e52, chars_format::fixed, "17289999999999999138422524940159658886890985204219904"},
    {1.729e53, chars_format::fixed, "172899999999999991384225249401596588868909852042199040"},
    {1.729e54, chars_format::fixed, "1729000000000000083983435954485197620376402236306096128"},
    {1.729e55, chars_format::fixed, "17289999999999999478704891861098122350265592635988115456"},
    {1.729e56, chars_format::fixed, "172899999999999994787048918610981223502655926359881154560"},
    {1.729e57, chars_format::fixed, "1729000000000000122095061049630305528274358268664135811072"},
    {1.729e58, chars_format::fixed, "17289999999999999130255748134057135763769994625857466925056"},
    {1.729e59, chars_format::fixed, "172900000000000002452930080605882928405559082582755422240768"},
    {1.729e60, chars_format::fixed, "1728999999999999846123339217813844151769844644640662174564352"},
    {1.729e61, chars_format::fixed, "17290000000000000602104931237078263105127400620649326319763456"},
    {1.729e62, chars_format::fixed, "172899999999999994603067770723103582584986250610532172135661568"},
    {1.729e63, chars_format::fixed, "1728999999999999991702603873821752019715013528489166085604507648"},
    {1.729e64, chars_format::fixed, "17289999999999999917026038738217520197150135284891660856045076480"},
    {1.729e65, chars_format::fixed, "172899999999999999170260387382175201971501352848916608560450764800"},
    {1.729e66, chars_format::fixed, "1728999999999999898166499084643965254679184234647052827624824897536"},
    {1.729e67, chars_format::fixed, "17290000000000000478242667473284240787365111047944340403923172982784"},
    {1.729e68, chars_format::fixed, "172899999999999992809805261718085701949064960867652907017832337768448"},
    {1.729e69, chars_format::fixed, "1729000000000000167550480877475991137982372600912339010606311218872320"},
    {1.729e70, chars_format::fixed, "17289999999999998610513727042982194663129671708505022868584867821518848"},
    {1.729e71, chars_format::fixed, "172900000000000010625065924284043680364849151489997166585674633152823296"},
    {1.729e72, chars_format::fixed, "1729000000000000008170944627423549868714281777280183914257442511777693696"},
    {1.729e73, chars_format::fixed, "17290000000000000081709446274235498687142817772801839142574425117776936960"},
    {1.729e74, chars_format::fixed, "172900000000000000817094462742354986871428177728018391425744251177769369600"},
    {1.729e75, chars_format::fixed, "1728999999999999957954130744330103758027966391618852585438598956065417592832"},
    {1.729e76, chars_format::fixed, "17289999999999999981275818508048606465770187001479176484936738006352384753664"},
    {1.729e77, chars_format::fixed, "172899999999999993385006008044524962489853500650141354760555404932352506331136"},
    {1.729e78, chars_format::fixed, "1728999999999999933850060080445249624898535006501413547605554049323525063311360"},
    {1.729e79, chars_format::fixed, "17289999999999998515748322143849475171500758786338882984687607676445318958809088"},
    {1.729e80, chars_format::fixed,
        "172900000000000004903537909292967257574637778551594889639706464367411549771399168"},
    {1.729e81, chars_format::fixed,
        "1728999999999999996379233258651079226787363943680732736949516943399559870558502912"},
    {1.729e82, chars_format::fixed,
        "17289999999999999121293999238053298684529417967443868818334406229602708671097208832"},
    {1.729e83, chars_format::fixed,
        "172900000000000011432899992743512832845555494939161693411202379201456447538679775232"},
    {1.729e84, chars_format::fixed,
        "1728999999999999898649426590230009971119434253234571545014868411689984626557915758592"},
    {1.729e85, chars_format::fixed,
        "17289999999999998555135119227889862996522101140031624671954373356250686567921393598464"},
    {1.729e86, chars_format::fixed,
        "172899999999999992453097539069462417399976873677341699170652705732893420841738159783936"},
    {1.729e87, chars_format::fixed,
        "1729000000000000034958916939343644772955862533205824230924270612055119091017769178628096"},
    {1.729e88, chars_format::fixed,
        "17289999999999999907877403198840365333734250146328613352371731901646451379776141463126016"},
    {1.729e89, chars_format::fixed,
        "172900000000000013213550550215478290003722507406634260143588494021416178770611024972218368"},
    {1.729e90, chars_format::fixed,
        "1729000000000000019057293356338185806706185026519557588476915540174548467923313366994518016"},
    {1.729e91, chars_format::fixed,
        "17289999999999998833634387813582692947089369694634155729261522601270124841839571077213192192"},
    {1.729e92, chars_format::fixed,
        "172900000000000002810355032800351357417266823032330038951363309217771753350593711761273126912"},
    {1.729e93, chars_format::fixed,
        "1728999999999999912311461090687318150601683221635392536243648426537153494048353109699601629184"},
    {1.729e94, chars_format::fixed,
        "17289999999999999586282967856137963200300772251105556775516422927933791098313867128648534851584"},
    {1.729e95, chars_format::fixed,
        "172900000000000003273523389749616139111550763067081670364443247880334009508424047792925645471744"},
    {1.729e96, chars_format::fixed,
        "1729000000000000032735233897496161391115507630670816703644432478803340095084240477929256454717440"},
    {1.729e97, chars_format::fixed,
        "17290000000000001275921134007055886821048585497879508170432039168960901562078932972116922557530112"},
    {1.729e98, chars_format::fixed,
        "172899999999999997582110619557050501652189707920053623560516961594769005841004878635979497409609728"},
    {1.729e99, chars_format::fixed,
        "1729000000000000097237911959678571948988266255670467900755597056706410136648324395041312799421628416"},
    {1.729e100, chars_format::fixed,
        "17290000000000000001044673483921184030151709144945225686352551040994340740577039080960985391612035072"},
    {1.729e101, chars_format::fixed,
        "172900000000000007781122303742128123979364718743527883433152866618501492413020029765226994736954343424"},
    {1.729e102, chars_format::fixed,
        "1729000000000000015645818486197950970370866169082673821774509816516550244072203186007332820802871492608"},
    {1.729e103, chars_format::fixed,
        "17290000000000000653781421271766151859090909837647578318201248962513219881186008753232825220562090459136"},
    {1.729e104, chars_format::fixed,
        "17289999999999999062347064760448896961867715767820889996741566411000524071701282695122434780455288753356"
        "8"},
    {1.729e105, chars_format::fixed,
        "172899999999999990623470647604488969618677157678208899967415664110005240717012826951224347804552887533568"
        "0"},
    {1.729e106, chars_format::fixed,
        "1728999999999999957160605884407041852897913787016543025960866482748458673073639503371775972128946529920614"
        "4"},
    {1.729e107, chars_format::fixed,
        "1729000000000000079382764464476207029004655091579232689048970102704633711242066464634653957929148900924456"
        "96"},
    {1.729e108, chars_format::fixed,
        "1729000000000000079382764464476207029004655091579232689048970102704633711242066464634653957929148900924456"
        "960"},
    {1.729e109, chars_format::fixed,
        "1728999999999999922938401481987675603588026221738989920296197469160729662386479954218170136104889866039538"
        "4832"},
    {1.729e110, chars_format::fixed,
        "1729000000000000006375395072648225697143561618987119396964342873717478488442792759773628174411161351311495"
        "00416"},
    {1.729e111, chars_format::fixed,
        "1729000000000000073124989945176665771987989936785622978298859197362877549287843004217994605056178539529060"
        "220928"},
    {1.729e112, chars_format::fixed,
        "1729000000000000019725314047153913712112447282546820113231246138446558300611802808662501460540164788955008"
        "0475136"},
    {1.729e113, chars_format::fixed,
        "1729000000000000062445054765572115360012881405937862405285336585579613699552634965106895976152975789414249"
        "78624512"},
    {1.729e114, chars_format::fixed,
        "1728999999999999994093469616102992723372186808512194737998791870166725061247303514795864751172478188679463"
        "004274688"},
    {1.729e115, chars_format::fixed,
        "1729000000000000048774737735678290832684742486452728871828027642497035971891568675044689731156876269267292"
        "4298510336"},
    {1.729e116, chars_format::fixed,
        "1729000000000000136264766726998767807584831571157583485954804878225533428922392931442809699131913198207819"
        "51077318656"},
    {1.729e117, chars_format::fixed,
        "1728999999999999996280720340886004647744689035629816103351961301059937497673074121205817750371854111902976"
        "181297741824"},
    {1.729e118, chars_format::fixed,
        "1729000000000000108267957449776215175616803064052030009434236162792414242672529169395411309379901380946850"
        "8448780976128"},
    {1.729e119, chars_format::fixed,
        "1728999999999999884293483231995794119872575007207602197269686439327460752673619073016224191363806842859101"
        "51771738603520"},
    {1.729e120, chars_format::fixed,
        "1729000000000000099308978481064998333387033941778252896947654173853816103072572765540243824659257599423340"
        "871791669149696"},
    {1.729e121, chars_format::fixed,
        "1729000000000000041971513081313210543116511559226079377033529444646788009632851780867171922447137397672877"
        "0440385269858304"},
    {1.729e122, chars_format::fixed,
        "1728999999999999904361596121908919846467257841100862929239630094549920585377521417651799357138048913471763"
        "85743098579255296"},
    {1.729e123, chars_format::fixed,
        "1728999999999999977753551833591208218013526490767645034729709747934916544980364278033331391969562771712357"
        "556955007762300928"},
    {1.729e124, chars_format::fixed,
        "1729000000000000095180680972282869612487556330234496403513837193350910080344912854643782647699984944897307"
        "4761934429138976768"},
    {1.729e125, chars_format::fixed,
        "1729000000000000048209829316806205054697944394447755856000186215184512666199093423999602145407816075623327"
        "50849806885325897728"},
    {1.729e126, chars_format::fixed,
        "1729000000000000048209829316806205054697944394447755856000186215184512666199093423999602145407816075623327"
        "508498068853258977280"},
    {1.729e127, chars_format::fixed,
        "1728999999999999927964449078785943786756537838833700054365239711078535285985795681550500059539863770281938"
        "7911979112580239065088"},
    {1.729e128, chars_format::fixed,
        "1728999999999999927964449078785943786756537838833700054365239711078535285985795681550500059539863770281938"
        "79119791125802390650880"},
    {1.729e129, chars_format::fixed,
        "1729000000000000120357057459618361815462788327816189336981154117648099094327072069469063396928587458828160"
        "738878163410400019742720"},
    {1.729e130, chars_format::fixed,
        "1728999999999999997225788095885614277090788014867396196106968897443578256988655181201182860999804298158578"
        "6923628020328793072730112"},
    {1.729e131, chars_format::fixed,
        "1728999999999999997225788095885614277090788014867396196106968897443578256988655181201182860999804298158578"
        "69236280203287930727301120"},
    {1.729e132, chars_format::fixed,
        "1729000000000000036627794292280093489369828115011010001186708167909024924936948585446904632497014909572844"
        "947247717673685935263318016"},
    {1.729e133, chars_format::fixed,
        "1729000000000000099671004206511260229016292275240792089314291000653739593654218032240059466892551887835670"
        "9550635826989765400478089216"},
    {1.729e134, chars_format::fixed,
        "1728999999999999948367300412356460053864778290689315077808092202066424388732771359936487864343263140004888"
        "53630550663827908856503074816"},
    {1.729e135, chars_format::fixed,
        "1728999999999999988714954757464406767238515353236375614209745215023041776711823805884106958356406806093097"
        "181307660254465075627104927744"},
    {1.729e136, chars_format::fixed,
        "1728999999999999924158707805291692025840536053161078755967100394292453955945339892367916407935376940351963"
        "3493042144685674963277862404096"},
    {1.729e137, chars_format::fixed,
        "1728999999999999975803705367029863818958919493221316242561216250876924212558527023180868848272200832944870"
        "41490697109728555976724119027712"},
    {1.729e138, chars_format::fixed,
        "1729000000000000099751699515201476122443039749365886210387094306679652828430176137131954705080578175167847"
        "372353587006208912021933069959168"},
    {1.729e139, chars_format::fixed,
        "1729000000000000099751699515201476122443039749365886210387094306679652828430176137131954705080578175167847"
        "3723535870062089120219330699591680"},
    {1.729e140, chars_format::fixed,
        "1728999999999999993982744508761700290136590464122519837842345032394657742886368893227028107270762843137573"
        "70199914143059431809792933263048704"},
    {1.729e141, chars_format::fixed,
        "1729000000000000036290326511337610623059170178219866386860244742108655777103891790788998746394688975949683"
        "170140919660840155667530827561959424"},
    {1.729e142, chars_format::fixed,
        "1729000000000000036290326511337610623059170178219866386860244742108655777103891790788998746394688975949683"
        "1701409196608401556675308275619594240"},
    {1.729e143, chars_format::fixed,
        "1729000000000000090444031474634775849200072212264469969603156370542573260902321099668321164473314425949183"
        "28936239579555482775662074107424407552"},
    {1.729e144, chars_format::fixed,
        "1728999999999999873829211621446114944636464076086055638631509856806903325708603864151031492158812625951182"
        "812476491256696139400261087025105469440"},
    {1.729e145, chars_format::fixed,
        "1728999999999999943145953974466486434096818679663148224542436741202317704970593379516564187299453201950542"
        "9650799807091309196742961763208298233856"},
    {1.729e146, chars_format::fixed,
        "1728999999999999943145953974466486434096818679663148224542436741202317704970593379516564187299453201950542"
        "96507998070913091967429617632082982338560"},
    {1.729e147, chars_format::fixed,
        "1729000000000000031871384186332561940606072572241826734508423153228448110425939959184446037079473139229723"
        "960412447208247438425061090619356996435968"},
    {1.729e148, chars_format::fixed,
        "1728999999999999889910695847346841130191266344115941118562844893986639461697385431715835077431441239583034"
        "3678805008096610084238372277417135195553792"},
    {1.729e149, chars_format::fixed,
        "1728999999999999946694971182941129454357188835366295364941076197683362921188807242703279461290653999441710"
        "20489327936909558042432677289277091030761472"},
    {1.729e150, chars_format::fixed,
        "1728999999999999946694971182941129454357188835366295364941076197683362921188807242703279461290653999441710"
        "204893279369095580424326772892770910307614720"},
    {1.729e151, chars_format::fixed,
        "1728999999999999946694971182941129454357188835366295364941076197683362921188807242703279461290653999441710"
        "2048932793690955804243267728927709103076147200"},
    {1.729e152, chars_format::fixed,
        "1729000000000000062989167070238231942248998097447020861523693907654252566227239111605565559434321731632278"
        "31909544985881758388132936136213644656819306496"},
    {1.729e153, chars_format::fixed,
        "1729000000000000156024523780075913932562445507111601258789788075630964282257984606727394437949255917384732"
        "810457186250595186646931432137628875576655740928"},
    {1.729e154, chars_format::fixed,
        "1728999999999999932739667676465477155810171723916608305351162072486856163784195418435005129513413871578842"
        "0311890189103289400094864622764470459563453186048"},
    {1.729e155, chars_format::fixed,
        "1728999999999999932739667676465477155810171723916608305351162072486856163784195418435005129513413871578842"
        "03118901891032894000948646227644704595634531860480"},
    {1.729e156, chars_format::fixed,
        "1728999999999999885105565041028583976769686650168343141950921858482779765176453724932628743713767568473585"
        "331611809877738807393498202039394922304012428509184"},
    {1.729e157, chars_format::fixed,
        "1728999999999999961320129257727613063234462768165567403391306200889302002948840434536430960993201653441996"
        "0509353443298830195790794184186783201477450526621696"},
    {1.729e158, chars_format::fixed,
        "1729000000000000022291780631086836332406283662563346812543613674814519793166749802219472734816748921416724"
        "62639417189159838932754439152210503842273115198455808"},
    {1.729e159, chars_format::fixed,
        "1729000000000000071069101729774214947743740378081570339865459653954694025341077296365906153875586735796507"
        "486761233940970685126316370004846413042720031442468864"},
    {1.729e160, chars_format::fixed,
        "1728999999999999875959817335024700486393913516008676230578075737393997096643767319780172477640235478277376"
        "0452929857434815019312284560738809145627645136108257280"},
    {1.729e161, chars_format::fixed,
        "1729000000000000000829759347664389741657802707735328460522001443992843131010045704795042030430860283089620"
        "16783266458987457917608472098969883358993604502307733504"},
    {1.729e162, chars_format::fixed,
        "1729000000000000050777736152720265443763358384425989352499571726632381544756557058800989851547110205014517"
        "816848536128431810074027226956026001200804657587977977856"},
    {1.729e163, chars_format::fixed,
        "1728999999999999970860973264630864320394469301720931925335459274409120082762138892391473337761110329934681"
        "5784231416667402406373192174099025330234148774841369493504"},
    {1.729e164, chars_format::fixed,
        "1728999999999999970860973264630864320394469301720931925335459274409120082762138892391473337761110329934681"
        "57842314166674024063731921740990253302341487748413694935040"},
    {1.729e165, chars_format::fixed,
        "1728999999999999919714245016253647601438380288789695171950427304986232747085711265889382768938070409883586"
        "385830889211257636197826091300383513389885418217678691106816"},
    {1.729e166, chars_format::fixed,
        "1728999999999999837879479818850100851108637868099716366534376153909613010003427063486037858821206537801834"
        "0776832852824854690946370895251530819762382833913454779170816"},
    {1.729e167, chars_format::fixed,
        "1729000000000000099750728450541450452163813614307648543865739837354796168666736511176741571195170928463441"
        "46375561785455640382484189520589046249990911483561176012423168"},
    {1.729e168, chars_format::fixed,
        "1729000000000000047376478724203180531952778465066062108399467100665759536934074621638600828720378050331119"
        "986541151340142216878800934069742986395174948546758503682801664"},
    {1.729e169, chars_format::fixed,
        "1729000000000000005477078943132564595783950345672792960026448911314530231547945110008088234740543747825262"
        "8047695781286108673219681651608250055113876155156758985296576512"},
    {1.729e170, chars_format::fixed,
        "1729000000000000072516118592845550093654075336702023597423278014276497120165752328616908385108278631834634"
        "29560409526706102661290059541509377492544734836540806677468807168"},
    {1.729e171, chars_format::fixed,
        "1728999999999999911622423433534384898765775358231870067670888167167776587483015003955740024225714910212142"
        "717601254134780644314662762804848728331703989526050862986615062528"},
    {1.729e172, chars_format::fixed,
        "1729000000000000126147350312615938491950175329525408107340741296646070631059998103503964505402466539042131"
        "4882717089778211540456465396185087904566951346451938013707124080640"},
    {1.729e173, chars_format::fixed,
        "1729000000000000057499373711309841342131167338711475934646388295213016537115363511648532671425906017816535"
        "08165716342804819093173173103813757057669796820706806108780125749248"},
    {1.729e174, chars_format::fixed,
        "1728999999999999892744229868175208182565548160758038720179941091773686711648240491195496269882160766875103"
        "705782254108593079458336190445246642864704768755566284408814496120832"},
    {1.729e175, chars_format::fixed,
        "1729000000000000112417754992354719061986373731362621672801870696359459812271071185132878138607154434797012"
        "2069487998678665614228635779024345464806957013575686533141301779496960"},
    {1.729e176, chars_format::fixed,
        "1728999999999999901531170873142388617742381183582222038284818275957117635673153718952991544631160513591980"
        "04582891593896401873691728594353415900934440605964637916502712339398656"},
    {1.729e177, chars_format::fixed,
        "1729000000000000014004015736722298188005843875731768510027246233505033463192043034248931061418357271567997"
        "198426187367712041502755308321614365660731763551871592044548752490364928"},
    {1.729e178, chars_format::fixed,
        "1729000000000000103982291627586225844216614029451405687421188599543366125207154486485682674848114677948810"
        "9205040045107104597154257262240785309818416495456517623481660557674676224"},
    {1.729e179, chars_format::fixed,
        "1729000000000000103982291627586225844216614029451405687421188599543366125207154486485682674848114677948810"
        "92050400451071045971542572622407853098184164954565176234816605576746762240"},
    {1.729e180, chars_format::fixed,
        "1729000000000000103982291627586225844216614029451405687421188599543366125207154486485682674848114677948810"
        "920504004510710459715425726224078530981841649545651762348166055767467622400"},
    {1.729e181, chars_format::fixed,
        "1729000000000000057913414371463894884236699710746951452595490108131739802255417422940465848772078885881834"
        "2948001621334952695905384722580168783374333879168363151527139964895910428672"},
    {1.729e182, chars_format::fixed,
        "1729000000000000131623617981259624420204562620674078228316607694390341918978196724612812770493736153188996"
        "89592630993703957379035807860371552256848660652294103066543729133419357011968"},
    {1.729e183, chars_format::fixed,
        "1728999999999999954719129317749873533881691636848973966585925487369696838843526400599180158361758711651806"
        "653223555208533243710791023374038776413958881868289713434901383707147504713728"},
    {1.729e184, chars_format::fixed,
        "1728999999999999813195538386942072824823394849788890557201379721753180774735790141388274068656176758422054"
        "4590613514257281796471373791902973794903367021445686596504726576055106523889664"},
    {1.729e185, chars_format::fixed,
        "1729000000000000115112532372665381004147761328850401830555077355068415044832294161038207060028084925312192"
        "47327405282904564964959848678227902626073068555517357439058727328900260401512448"},
    {1.729e186, chars_format::fixed,
        "1728999999999999933962335981231396096553141441413495066542858775079274482774391749248247265204940025178109"
        "664746431987055167648121822227090038198494295508810625546518503878907433039429632"},
    {1.729e187, chars_format::fixed,
        "1729000000000000078882493094378584022628837351363020477752633639070586932420713678680215101063455945285375"
        "9115685286606475532493031538712412286482834075459009846217735194069835698199855104"},
    {1.729e188, chars_format::fixed,
        "1729000000000000001591742634033417128721799532723273591774087044941886959276008649649832255272247454561500"
        "57993007710139828092867311032769392707506254779278612644830417779200963020368904192"},
    {1.729e189, chars_format::fixed,
        "1729000000000000001591742634033417128721799532723273591774087044941886959276008649649832255272247454561500"
        "579930077101398280928673110327693927075062547792786126448304177792009630203689041920"},
    {1.729e190, chars_format::fixed,
        "1728999999999999952125662339412510316621295328793835584747817224699518976463397431070387233965874020498220"
        "3676814681034787466434698824598236540682011975507926172172837991584263088492593020928"},
    {1.729e191, chars_format::fixed,
        "1729000000000000070844255046502686665662505418224486801610864793281202135213664355661055285101170262250092"
        "87707812969848562892795762934271230928466843813157703937173270787902628009989067767808"},
    {1.729e192, chars_format::fixed,
        "1728999999999999880894506715158404507196569275135444854629988683550509081213237276315986403284696275447096"
        "862043471146474617272777234330090460938320853202321963924614453926066326098880476741632"},
    {1.729e193, chars_format::fixed,
        "1729000000000000032854305380233830233969318189606678412214689571335063524413578939792041508737875464889493"
        "6740711979880834265969215503401879396153989211457260242823090570884342892996886374907904"},
    {1.729e194, chars_format::fixed,
        "1729000000000000032854305380233830233969318189606678412214689571335063524413578939792041508737875464889493"
        "67407119798808342659692155034018793961539892114572602428230905708843428929968863749079040"},
    {1.729e195, chars_format::fixed,
        "1729000000000000097690486143999345210725691059781071396784161950123140086845724716208491687064565252384916"
        "313869694773836518575223125171162863850952230134911756701592087771044620265366786077097984"},
    {1.729e196, chars_format::fixed,
        "1728999999999999942083652310962109266510396171362528233817428241031756337008574852809011259080509762395901"
        "9783533024880290978272993455768230456856242885608659988953128141327798259477392294699597824"},
    {1.729e197, chars_format::fixed,
        "1728999999999999900588496622152179681386317534450916723692965918607387337052001555902483144951428298398831"
        "48888226454514711896118633768499909417487017080778713014697167449590921412970521437472292864"},
    {1.729e198, chars_format::fixed,
        "1728999999999999900588496622152179681386317534450916723692965918607387337052001555902483144951428298398831"
        "488882264545147118961186337684999094174870170807787130146971674495909214129705214374722928640"},
    {1.729e199, chars_format::fixed,
        "1729000000000000006816095185505599419303958844944642189611589464013771976940829195983195117121876846231331"
        "9419281216789249848584356378880684100424007122556690341427249919662979803838722930185292742656"},
    {1.729e200, chars_format::fixed,
        "1729000000000000049307134610846967314471015369142132375979038882176325832896360252015479905990056265364332"
        "12314646453243613121733535796929613638941292883482179574102631895445348688553912447605181251584"},
    {1.729e201, chars_format::fixed,
        "1729000000000000117292797691393155946738305807858116674166957951236412002425209941667135568179143335977132"
        "413095813098053965391574910099260498544632475361466214298308442135502297288206054808087873716224"},
    {1.729e202, chars_format::fixed,
        "1728999999999999954127206298082303229296808754939754358515952185492205195555970686503161978925334366506411"
        "7172173765405711633733999849873460293721055636975196097608313465009851523218054220112013268353024"},
    {1.729e203, chars_format::fixed,
        "1728999999999999867105557554983181779994676993383294456835415777095294898559043083749042731323302916122027"
        "34608221037658033563037335826099164581342454414341475400751022882924267500639175118619516849881088"},
    {1.729e204, chars_format::fixed,
        "1728999999999999867105557554983181779994676993383294456835415777095294898559043083749042731323302916122027"
        "346082210376580335630373358260991645813424544143414754007510228829242675006391751186195168498810880"},
    {1.729e205, chars_format::fixed,
        "1728999999999999978493267946150057235101405648175563130986502379843340078715110415274315368253903172614039"
        "3411352230664885951414474404707252567685362491726689693717612594490730459701212498422030511695200256"},
    {1.729e206, chars_format::fixed,
        "1729000000000000023048352102616807417144097110092470600646937020942558150777537347884424423026143275210844"
        "13915642814245189894587707335461870115058093118437065551746167169700519435561304930460620423780368384"},
    {1.729e207, chars_format::fixed,
        "1728999999999999951760217452270007125875790771025418649190241595183809235477654255708249935390559111055956"
        "462322500020910612858789660740389190139309439965647957684341012100313756938826170164761159328549830656"},
    {1.729e208, chars_format::fixed,
        "1729000000000000065821232892824887591905080913532701771520954276397807499957467203190129115607493773703776"
        "7452567850153766705981295209231564077573438259156042742173340674550200568056851767885132311833559957504"},
    {1.729e209, chars_format::fixed,
        "1728999999999999974572420540380983219081648799526875273656384131426608888373616845204625771433946043585520"
        "51890935701980382440665763277694263366291631715563922099093962317125501691219797148951157369951106367488"},
    {1.729e210, chars_format::fixed,
        "1729000000000000047571470422336106717340394490731536471948040247403567777640697131593028446772784227680125"
        "49998729941626210135983514329391365293845832416361126357205517859826704882698773572871289968658700933529"
        "6"},
    {1.729e211, chars_format::fixed,
        "1728999999999999930772990611207909120126401384804078554681390461840433554813368673371584166230643133128757"
        "530262591581928858234751126466760022097591112950855995442270289915047797763324112945990778107265496278630"
        "4"},
    {1.729e212, chars_format::fixed,
        "1729000000000000024211774460110467197897595869546044888494710290290940933075231439948739590664356008769851"
        "9060423578493954527348183399284829267702848819210602099460982008616231986142550111721684753707227067239628"
        "8"},
    {1.729e213, chars_format::fixed,
        "1729000000000000098962801539232513660114551457339617955545366153051346835684721653210463930211326309282727"
        "4066661708633687283348721106978612505084398970972235815491605296188835192949997297531106331814884750802288"
        "64"},
    {1.729e214, chars_format::fixed,
        "1729000000000000098962801539232513660114551457339617955545366153051346835684721653210463930211326309282727"
        "4066661708633687283348721106978612505084398970972235815491605296188835192949997297531106331814884750802288"
        "640"},
    {1.729e215, chars_format::fixed,
        "1728999999999999859759514886041964981020293576400184140983267392218047947334352970772946043661021347641525"
        "8046699692186542464147000442358506145463438485335007924193610775956504931166166302940957281870380163401777"
        "1520"},
    {1.729e216, chars_format::fixed,
        "1728999999999999859759514886041964981020293576400184140983267392218047947334352970772946043661021347641525"
        "8046699692186542464147000442358506145463438485335007924193610775956504931166166302940957281870380163401777"
        "15200"},
    {1.729e217, chars_format::fixed,
        "1729000000000000104703680418909086828412813646482164367094856523311346009005130501588964359488533628362116"
        "2451140797028418759009562402929495057715302022627529284882757164674411119232809241401269909013552860899900"
        "915712"},
    {1.729e218, chars_format::fixed,
        "1728999999999999908748347992615389350498797590416580186205585218436707559668508476936149706826523803785643"
        "8927587913154917723119512834472703927913811192793512196331440053700086168779494890633019807299014702901401"
        "9047424"},
    {1.729e219, chars_format::fixed,
        "1728999999999999947939414477874128846081600801629697022383439479411635249535832881866712637358925768700938"
        "3632298489929617930297522748164062153874109358760315614041703475894951158870157760786669827641922334501101"
        "70693632"},
    {1.729e220, chars_format::fixed,
        "1729000000000000073350827230702095231946571077511670898152573114531403857111270977644514015062612056429880"
        "6687372335608658593267154471976408476947063489854086550714546426918519127160278945278349892739226755620141"
        "073956864"},
    {1.729e221, chars_format::fixed,
        "1728999999999999973021697028439722123254594856806091797537266206435588971050920501022272912899663026246726"
        "8243313259065426062891449092926531418488700184979069801376272066099664752528181997685005840661383218724909"
        "5803404288"},
    {1.729e222, chars_format::fixed,
        "1728999999999999852626740785724874392824223391959396876798897916720611107778499929075583590304124190026942"
        "2110442367213547026440602638066678948338664219129049702170342833117039502969665660572992978167970974450631"
        "78800070656"},
    {1.729e223, chars_format::fixed,
        "1729000000000000109469314103516549551075682516965679374374083601445897216092997149228520811841273707295816"
        "0527233603164222304202408408434364217992074279609092580476325196813306702027833846411953751487250428902424"
        "411658780672"},
    {1.729e224, chars_format::fixed,
        "1728999999999999955363770112841544456124807041961909875828972190610725551104298817136758478918983996934491"
        "7477158861593817137545324946213753056200028243321066853492735778595546382592932934908577287495682756231348"
        "8374639362048"},
    {1.729e225, chars_format::fixed,
        "1728999999999999955363770112841544456124807041961909875828972190610725551104298817136758478918983996934491"
        "7477158861593817137545324946213753056200028243321066853492735778595546382592932934908577287495682756231348"
        "83746393620480"},
    {1.729e226, chars_format::fixed,
        "1729000000000000086867167651550882137149554113965126514587467261190072038561321393855062336346004549776155"
        "1546555974400562879759369500642007914262574194286848807185398748808035188510715046058125203435153836910666"
        "660776870150144"},
    {1.729e227, chars_format::fixed,
        "1728999999999999929063090605099676919919857627561266548077273176494856253612894301793097707433579886366159"
        "0663279439032467989102516035328102084587519053127910462754203184553048621409376512678667704307788540095485"
        "2728013494157312"},
    {1.729e228, chars_format::fixed,
        "1729000000000000097387439454647629151631533879725383845688146866836419757557883199992526644940166194003488"
        "2272107743425102539136493064996268302907577870364111363480811786425034292984137614950089036710311523365012"
        "08664190486577152"},
    {1.729e229, chars_format::fixed,
        "1729000000000000097387439454647629151631533879725383845688146866836419757557883199992526644940166194003488"
        "2272107743425102539136493064996268302907577870364111363480811786425034292984137614950089036710311523365012"
        "086641904865771520"},
    {1.729e230, chars_format::fixed,
        "1729000000000000043523647822792284437483797479032866310452667285927119436295486752568709384938058575559542"
        "8957282686019459483125620415502455113045159048848527075248297033825998878080214062223234210341504168718763"
        "5062129271217586176"},
    {1.729e231, chars_format::fixed,
        "1728999999999999828068481295370905580892851876262796169510748962289918151245900962873440344929628101783761"
        "5697982456396887259082129817527202353595483762786189922318238023429857218464519851315814904866274750133769"
        "18449701614570700800"},
    {1.729e232, chars_format::fixed,
        "1728999999999999897014134584145746815001954469149218614612162825853822562461768415575926437732325853392011"
        "5940958529876110370776046808879283236619379854326137811255856906756622549541541998806189082618348164080967"
        "367446107658043523072"},
    {1.729e233, chars_format::fixed,
        "1729000000000000062483702477205365776863800692076632482855556098407193149379850302061893060458800457251811"
        "6524101106226245838841447588124277355876730474022012744706142226740859344126395152783087109223324357554243"
        "0065239272876511592448"},
    {1.729e234, chars_format::fixed,
        "1729000000000000106608920582021264166693626351523942847720460971088091972558005471791484159852527018281091"
        "6679605793252948630325554462589609121012023972607579393626218312069989156015689327176926582984651342480449"
        "84361134585554652889088"},
    {1.729e235, chars_format::fixed,
        "1728999999999999894807873678904951895510463186176853096368917582219777621302860657089446882762639525340547"
        "5933183295524775231201841465156016648362615179396859478809853102490166058947077290086497108930281814834657"
        "025591736729648754589696"},
    {1.729e236, chars_format::fixed,
        "1729000000000000007768432027233651773474816874361967630423074056282878608638937891597200097210579521575504"
        "4331275294313134377401155063787265967108966535775910100045247880932738377383670376534726161759278896245746"
        "5285355282634609008836608"},
    {1.729e237, chars_format::fixed,
        "1728999999999999827031538669907731968731850973265784375936423697781917028901214316384794954093875527599573"
        "4894328096251759743482253305977267057114804365569429106068616235424622667885121438217559677232883565988003"
        "32382546180936146681331712"},
    {1.729e238, chars_format::fixed,
        "1729000000000000043915810698698835734423410054581204281320404127983070924586482606639681125833920320370690"
        "6218664733925409304184935415349265749107798969817206298840574210034361519283380164198159458664557962297295"
        "169477541554280787697729536"},
    {1.729e239, chars_format::fixed,
        "1729000000000000043915810698698835734423410054581204281320404127983070924586482606639681125833920320370690"
        "6218664733925409304184935415349265749107798969817206298840574210034361519283380164198159458664557962297295"
        "1694775415542807876977295360"},
    {1.729e240, chars_format::fixed,
        "1728999999999999905109876600272529324380812242539335541874656652654332431347910900876553975920291652997175"
        "6571089285814273585335218865351186586232282423098628895466521106284128654388494579570575598548286348659348"
        "38826021051753242233170558976"},
    {1.729e241, chars_format::fixed,
        "1729000000000000053169539638593922828426249908717328863950120626338320157469054053690556269161495564862258"
        "2861836430466151685441583185349137693299500072931778125732177750284377043609705869839998382672309403206491"
        "621558696956730678722131132416"},
    {1.729e242, chars_format::fixed,
        "1729000000000000112393404853922480230044424975188526192780306215811915247917511314816157186457977129608291"
        "3378135288326902925484128913348318136126387132865037817838440407884476399298190385947767496321918625025348"
        "9148780915324099812783013494784"},
    {1.729e243, chars_format::fixed,
        "1728999999999999828118851820345404702277184656126779014395415386338658813764916461413272783434865618827332"
        "6899900770595296973279909418952252010557329245185391295728379651403999491993464708630475750803794360294833"
        "90694499756914932900868430757888"},
    {1.729e244, chars_format::fixed,
        "1728999999999999979731946771586511650419712826293044176200690495391062245312967049894811131713858424577177"
        "3021625846718820147788826482630153944194160118614536107520412054860253842555985069866364681746793968151108"
        "577842647682888343552480063258624"},
    {1.729e245, chars_format::fixed,
        "1729000000000000040377184752082954429676724094359550240922800539012023617932187285287426471025455546877115"
        "1470315877168229417592393308101314717648892467986194032237225016242755582780993214360720254123993811293618"
        "4462017077283839493699983655305216"},
    {1.729e246, chars_format::fixed,
        "1729000000000000040377184752082954429676724094359550240922800539012023617932187285287426471025455546877115"
        "1470315877168229417592393308101314717648892467986194032237225016242755582780993214360720254123993811293618"
        "44620170772838394936999836553052160"},
    {1.729e247, chars_format::fixed,
        "1729000000000000079190137059600677808401211305922114122344950966929438896408488235938700288184877705149075"
        "3677477496655851350266676076402857612659921171584055104055985311527556696524998426837107820445401710904824"
        "761951506157501137093210078984536064"},
    {1.729e248, chars_format::fixed,
        "1728999999999999954988689675543962996482852228921909701794069597593710005284325193854624073274726798678802"
        "6614560314295461165708971217837920348624629320070899674235952366616193132544181746912667608216896432148964"
        "5515521511843261363789325959316897792"},
    {1.729e249, chars_format::fixed,
        "1729000000000000054349847582789334846017539490522073238234774693062293118183655627521885045202847523855020"
        "8264894060183773313355135104689870159852862801281424018091978722545283983728835090852219777999700655153652"
        "71987163516286613695035458237396680704"},
    {1.729e250, chars_format::fixed,
        "1728999999999999974860921256993037366389789681241942409082210616687426627864191280588076267660350943714046"
        "2944627063473123595238203995208310310870276016313004543007157637802011302781112415700578042173457276749902"
        "185216047980034136493216993220145184768"},
    {1.729e251, chars_format::fixed,
        "1728999999999999974860921256993037366389789681241942409082210616687426627864191280588076267660350943714046"
        "2944627063473123595238203995208310310870276016313004543007157637802011302781112415700578042173457276749902"
        "1852160479800341364932169932201451847680"},
    {1.729e252, chars_format::fixed,
        "1729000000000000025733834105502667753351549559181226139739851625567341181668648462625713885287548755004269"
        "9949597941367939414833039905276508614219131558692793007061443132037705818587654927797628753102253038928302"
        "52739562377704661678578505027859102302208"},
    {1.729e253, chars_format::fixed,
        "1728999999999999985035503826694963443782141656829799155213738818463409538625082716995603791185790505972091"
        "0345621239052086759157171177221949971540047124788962235818014736649150205942420918119988184359216429185582"
        "253651963139436632551730604631834352418816"},
    {1.729e254, chars_format::fixed,
        "1729000000000000115270160718879617234404246944354365505697299801195990796364493103011956092311416902875063"
        "7078346686462815257319951106996537628113117313281220703796985601892528166407169749088438004336933580362287"
        "1296316771797885821007048307014556983492608"},
    {1.729e255, chars_format::fixed,
        "1729000000000000011082435205131894201906562714334712425310451015009925790172964794198874251410915785352685"
        "5692166328534232458789727163176867502854661162487413929413808909697825798035370684313678148354759859420923"
        "22884790594750702246152544984575862160490496"},
    {1.729e256, chars_format::fixed,
        "1729000000000000052757525410630983414905636406342573657465190529484351792649576117724106987771116232361636"
        "8246638471705665578201816740704735552958043622804936639167079586575706745384090310223582090747629347797468"
        "789161414440419646317197202188037452302647296"},
    {1.729e257, chars_format::fixed,
        "1729000000000000052757525410630983414905636406342573657465190529484351792649576117724106987771116232361636"
        "8246638471705665578201816740704735552958043622804936639167079586575706745384090310223582090747629347797468"
        "7891614144404196463171972021880374523026472960"},
    {1.729e258, chars_format::fixed,
        "1728999999999999999413409947592149222266822080572511280307123950957086509479513623611809085230059660190179"
        "2176914128446231185354342081469064448825714073598507570682893120172019132777729189058905044484756402675490"
        "47196012356949148778193735918992054900953710592"},
    {1.729e259, chars_format::fixed,
        "1728999999999999871387532836298947159933667698724361575127764162491649829871363637742294119131523886978680"
        "9609575704623588642520402899303453798908123155503077806320845600803168862522462498263680133453861334382742"
        "510677025479263907297313735994439981106072649728"},
    {1.729e260, chars_format::fixed,
        "1729000000000000007948468421678362693089032372695721260652414603521448954786723622669776749636628711737612"
        "4348070023367740688209938026946771825486886801471536221640362954796609150794746968445253371886816073895007"
        "0027123301088399931475789340696192535364347363328"},
    {1.729e261, chars_format::fixed,
        "1729000000000000062572842655830128906351178242284265134862274779933368604752867616640769801838670641641185"
        "0243467750865401506485752078004099036118392259858919587768169896393985266103660756517882667259997969699912"
        "79952645196067042748768501329969096250857957097472"},
    {1.729e262, chars_format::fixed,
        "1728999999999999844075345719223064053302594763930089638022834074285690004888291640756797593030502922026894"
        "6661876840874758233382495873774790193592370426309386123256942130004480804868005604227365485767270386480289"
        "612269964553348690127260696379404126620000232407040"},
    {1.729e263, chars_format::fixed,
        "1728999999999999913994544738937324806278141477003425797011455100092947156844955953039668699849116592303467"
        "5807985932071764080775537859128169023200697413045236831900535015249122232463415252960330983844943213110569"
        "0321920405236916460825964777938959141043456207486976"},
    {1.729e264, chars_format::fixed,
        "1728999999999999913994544738937324806278141477003425797011455100092947156844955953039668699849116592303467"
        "5807985932071764080775537859128169023200697413045236831900535015249122232463415252960330983844943213110569"
        "03219204052369164608259647779389591410434562074869760"},
    {1.729e265, chars_format::fixed,
        "1729000000000000048239406856788705451991191166104231222269607469642880888601751432622781224940854839234487"
        "5768515387170015307770178471006656376048685227578070192496233354918833773446601778527624740154075040240705"
        "518442426386750121516841178109720146074288766364680192"},
    {1.729e266, chars_format::fixed,
        "1728999999999999905044887264413899429897271497730038768660911608789618241394502921067461198176334042508066"
        "2477283968398547332309228485002936533010831558743047941194155125937808129731202817922511400091001091301893"
        "2664420147994877477203134977728409653063494110409654272"},
    {1.729e267, chars_format::fixed,
        "1729000000000000076878310775263666656409975099779069712991346641813533418043201134933845230293758998579771"
        "8426761670924308902862368468207400344656255961345074642756649000715038902189681570648647408166689830028467"
        "96884250870420259627614671417709598222787663742942314496"},
    {1.729e268, chars_format::fixed,
        "1728999999999999985233818236143790802269866512019586542681781290867445323830562087538440413164465688674862"
        "1920373562910569398567360477165019645112029613290660401923318934167182490211826235861374870526322502707628"
        "127562245288354677046368998761493306536395450022245695488"},
    {1.729e269, chars_format::fixed,
        "1728999999999999911918224204847890118957779641812000006434129010110574848460450849622116559461031040750934"
        "4715263076499577795131354084331115085476648534847129009256654880928897360629541968031556840414028640850956"
        "2545380345556763416625468264290111659832105000965037359104"},
    {1.729e270, chars_format::fixed,
        "1728999999999999970570699429884610665607449137978069235432250834716071228756539839955175642423778759090076"
        "6479351465628371077880159198598238733184953397601954123389986123519525464295369382295411264503863730336293"
        "75295740314181900996960456429499687842575846003709730357248"},
    {1.729e271, chars_format::fixed,
        "1728999999999999829804758889796481353648242347179503085836758455662879916045926263155833843313184235076135"
        "4245539331719267199283026924357141978685021726990373849469991141302018015497383588062160646688259515571483"
        "756750918535076606032665993416631168563643356179672741183488"},
    {1.729e272, chars_format::fixed,
        "1728999999999999979955095465890485953071396257364640312071950326652950649603914078408465095697818394024339"
        "3961605607888978003119968016880978516818282175642726141651319122334025960881901768577627972358237344653947"
        "7527045021156018368987338023535545924165661336275922743984128"},
    {1.729e273, chars_format::fixed,
        "1728999999999999979955095465890485953071396257364640312071950326652950649603914078408465095697818394024339"
        "3961605607888978003119968016880978516818282175642726141651319122334025960881901768577627972358237344653947"
        "75270450211560183689873380235355459241656613362759227439841280"},
    {1.729e274, chars_format::fixed,
        "1728999999999999931906987761540404481255987006105396399676688927936128014865357977527623094934735463160914"
        "1252464399514670545892146867273350824615638832073973408153294168403783418358855950812678428143844439347559"
        "273999355369833763021592103493739096783630844844258023769636864"},
    {1.729e275, chars_format::fixed,
        "1728999999999999893468501598060339303803659605098001269760479808962669907074513096822949494324269118470173"
        "9085151432815224580109889947587248670853524157218971221354874205259589384340419296600718792772330115102448"
        "4910352379732193039198787444058867002772826138175906232666161152"},
    {1.729e276, chars_format::fixed,
        "1729000000000000077973235182764652155574831129933497893358283580035268824470568524205382777254507572985726"
        "9488253672972565215864723162080539008911674596522981717987290028351720747628915236818125042555598871478980"
        "24926300147696870760810286802757820350775412274559414568111570944"},
    {1.729e277, chars_format::fixed,
        "1728999999999999979570710604255685301296872983354566360772788235463216068526005629601418359691713730577431"
        "9939932478221983543462145447684117495280661028894176119783334922702584020541717402035508376004522201411496"
        "644874860941635692307716668762676068451502651317325600393382592512"},
    {1.729e278, chars_format::fixed,
        "1729000000000000058292730267062858784719239500617711586841184511120858273281655945284589893741948804504067"
        "9578589434022448881384207619201254706185471882997220598346499007221893402211475669861601709245383537465483"
        "5283853733699021045480256281745977764965038284599404366235690860544"},
    {1.729e279, chars_format::fixed,
        "1729000000000000058292730267062858784719239500617711586841184511120858273281655945284589893741948804504067"
        "9578589434022448881384207619201254706185471882997220598346499007221893402211475669861601709245383537465483"
        "52838537336990210454802562817459777649650382845994043662356908605440"},
    {1.729e280, chars_format::fixed,
        "1729000000000000058292730267062858784719239500617711586841184511120858273281655945284589893741948804504067"
        "9578589434022448881384207619201254706185471882997220598346499007221893402211475669861601709245383537465483"
        "528385373369902104548025628174597776496503828459940436623569086054400"},
    {1.729e281, chars_format::fixed,
        "1729000000000000098598404334420131608231491157456441942588203404257571082116548906914373719175669162354505"
        "5713581795392287134400303451018028958168735040297979371370839018495779805626391902988561495864704541525124"
        "8127427557331745076150638153935016910155444311569592327734245707481088"},
    {1.729e282, chars_format::fixed,
        "1729000000000000034109325826648495090611888506514473373392973175238830587980720168306719598481716589793805"
        "3897594017200545929574550120111190154995513988616765334531895000457561560162525929985425837273790935029698"
        "75777094395193866270780271584325542778507946684172915893365579523817472"},
    {1.729e283, chars_format::fixed,
        "1729000000000000034109325826648495090611888506514473373392973175238830587980720168306719598481716589793805"
        "3897594017200545929574550120111190154995513988616765334531895000457561560162525929985425837273790935029698"
        "757770943951938662707802715843255427785079466841729158933655795238174720"},
    {1.729e284, chars_format::fixed,
        "1729000000000000034109325826648495090611888506514473373392973175238830587980720168306719598481716589793805"
        "3897594017200545929574550120111190154995513988616765334531895000457561560162525929985425837273790935029698"
        "7577709439519386627078027158432554277850794668417291589336557952381747200"},
    {1.729e285, chars_format::fixed,
        "1728999999999999968072509434690339296569415391949897558537057420723640321985631539972481778891109155491648"
        "4038022532332202935832978709262587220546135631695202160808816325986426076807527173630214922876695401978382"
        "47747980868795315752276734990380325423708334338293356332173256911600222208"},
    {1.729e286, chars_format::fixed,
        "1729000000000000020901962548256863931803393883601558210421790024335792534781702442639872034563595102933373"
        "9925679720226877330826235837941469568105638317232452699787279265563334463491526178714383654394371828419435"
        "501712716899141561670795642655364993075480242149970039811271150013740220416"},
    {1.729e287, chars_format::fixed,
        "1729000000000000105429087529963303348177759470244215253437362190115236075255415886907696443639572618840134"
        "9345931220858356362815447243827681324200842614092053562152819968886387882185924586849053624822654110725120"
        "3404853700370430083076409110578637752169152801772284021945328794501210177536"},
    {1.729e288, chars_format::fixed,
        "1729000000000000105429087529963303348177759470244215253437362190115236075255415886907696443639572618840134"
        "9345931220858356362815447243827681324200842614092053562152819968886387882185924586849053624822654110725120"
        "34048537003704300830764091105786377521691528017722840219453287945012101775360"},
    {1.729e289, chars_format::fixed,
        "1728999999999999943137007565086939668738977543890313730847463631818704477545886073913473578213695788299153"
        "9259048339645916621396161344526154752498050364121619906410981818506125318292679643230487281600352128698205"
        "450041876012272230764897995725066113505360007164892346418670358932269886865408"},
    {1.729e290, chars_format::fixed,
        "1729000000000000159526447518255424574657353445695515760967328376214079941158592491239104065448198229020461"
        "9374892181262502943288542543594856848101773364082198114066766019013142070150339568055242405896754771400758"
        "6372998680452999341552218828354629957874337045146737541198203862894047280496640"},
    {1.729e291, chars_format::fixed,
        "1729000000000000090281826733241509404763473157117851111328971658007559792802526437694902309533157447989643"
        "3737822151945195320282980559892872177508582004094813087616915074850896709555888392111320766121905925735941"
        "61737731059473106907031823896013599345717012136274370365545237753512157887070208"},
    {1.729e292, chars_format::fixed,
        "1729000000000000034886130105230377268848368926255719391618286283442343674117673594859540904801124823164988"
        "5228166128491349221878530972931284441034028916104905066457034319521100421080327451356183454302026849204088"
        "001439264634275977002395323859874391592959254841199663283957970531695059527532544"},
    {1.729e293, chars_format::fixed,
        "1729000000000000123519244710048188686312535695635130143155382882746689464013438143396119152372377022884436"
        "2843615766017502979325650312069824819393313856888757900312843528048774482641224956564403153213833371655053"
        "7869401381710041243110719880202929545756966412756701278783490217371774904766038016"},
    {1.729e294, chars_format::fixed,
        "1729000000000000052612753026193939552341202280131601541925705603303212832096826504566856554315375263108878"
        "0751256055996579973367954840758992516705885904261675633228196161226635233392506952397827394084388153694281"
        "15853943934162160646413065669195810418950673212809375620283618077279154571734679552"},
    {1.729e295, chars_format::fixed,
        "1728999999999999995887559679110540245164135547728778660941963779748431526563537193503446475869773855288431"
        "5077368287979841568601798463710326674555943542160009819560478267768923833993532549064566786780831979325663"
        "055818880278115592186577591629290223880554804810032658862425908001282789909941190656"},
    {1.729e296, chars_format::fixed,
        "1729000000000000041267714356777259690905788933651036965728957238592256570990168642354174538626254981544788"
        "7616478502393232292414723565349259348275897431841342470494652582535092953512712071731175272623676918820557"
        "5379953275289204036086200436794245281277163466644815367347541262184897945558656745472"},
    {1.729e297, chars_format::fixed,
        "1728999999999999968659466872510508577719143516175423678069767704442136499907558324193009638215885179534617"
        "1553902159331807134314043402726967070323971208351210228999973678909222362282024835464601695275125015628726"
        "36651301192763270533335212039920964133225787969736333213902897707095858712238650032128"},
    {1.729e298, chars_format::fixed,
        "1729000000000000084832662847337310358817776184136404938324470959082328613639734833250873478872476862750891"
        "7254024308230087387275131662922634715047053165935421815391459924710615308251124413491119419032808060735656"
        "240884716889693022573780797647553460204991426844752459492189215707008519015953179082752"},
    {1.729e299, chars_format::fixed,
        "1729000000000000084832662847337310358817776184136404938324470959082328613639734833250873478872476862750891"
        "7254024308230087387275131662922634715047053165935421815391459924710615308251124413491119419032808060735656"
        "2408847168896930225737807976475534602049914268447524594921892157070085190159531790827520"},
    {1.729e300, chars_format::fixed,
        "1729000000000000010481817423448157218914651276641376931761460876112605660851141867453840620852258185492476"
        "0005946132935188025380035176397407422424280713081526400100908727397723822830900683554148075827890911867221"
        "12128682571397441953990644420861341612644195667042341798616666297993656260407050467540992"},
    {1.729e301, chars_format::fixed,
        "1729000000000000010481817423448157218914651276641376931761460876112605660851141867453840620852258185492476"
        "0005946132935188025380035176397407422424280713081526400100908727397723822830900683554148075827890911867221"
        "121286825713974419539906444208613416126441956670423417986166662979936562604070504675409920"},
    {1.729e302, chars_format::fixed,
        "1728999999999999915312735280870041199838651395047741083360807969911360281281742871233638562586378278601703"
        "8728406068557716842154311673645116487867131973428540268529003194837222721493014309234824756525596961315624"
        "1682015250090546076565472718067701597058986348472822448584577954892844583968606814340120576"},
    {1.729e303, chars_format::fixed,
        "1728999999999999991448000994932534015099451300322649762081330294872356584937262068209800209199082204114321"
        "5750438120059693788734890475846949235512850965150929173786527620885623602563323408690283411967432121756901"
        "73066976557299045716323460972824476484233329230579518336062488948180614176262854002713034752"},
    {1.729e304, chars_format::fixed,
        "1729000000000000113264426137432522519516731148762503648034166014809950670786092783371658843779408484934509"
        "8985689402462856903263816559369881631746001351906751422198566702563065012275817967819017260674368378462945"
        "830618950475287816373934350402604133060628744239415884964092239869840835147857113776119611392"},
    {1.729e305, chars_format::fixed,
        "1729000000000000064537856080432527117749819209386562093653031726834913036446560497306915389947277972606434"
        "5691588889501591657452246125960708673252741197204422522833751069892088448390820144167523721191593875780528"
        "1906392765143688726896544541328603857733105634659676043227052997146269577937656842765239058432"},
    {1.729e306, chars_format::fixed,
        "1728999999999999908612831898032541832095701003383549119633402005314792606560057181899736337684460333156593"
        "5150467248025542870855220739051355206074308702156970044866341045344963443958827108482744394846715467196791"
        "74270431983942825289995878606968039445389238499093310627026709121794255026067310987781764808704"},
    {1.729e307, chars_format::fixed,
        "1729000000000000033352851243952530060618995568185959498849105782530888950469259834225479579494714444716466"
        "3583364561206381900132841048578837979817054698194932027240269064982663447504421537030567855922618194063780"
        "901052285179380748731715320520224387509426927770960704712217658015290076287147169396782654291968"},
    {1.729e308, chars_format::fixed,
        "1729000000000000033352851243952530060618995568185959498849105782530888950469259834225479579494714444716466"
        "3583364561206381900132841048578837979817054698194932027240269064982663447504421537030567855922618194063780"
        "9010522851793807487317153205202243875094269277709607047122176580152900762871471693967826542919680"},

    // Also test one-digit cases, where the decimal point can't appear between digits like "17.29".
    {7e-3, chars_format::fixed, "0.007"},
    {7e-2, chars_format::fixed, "0.07"},
    {7e-1, chars_format::fixed, "0.7"},
    {7e0, chars_format::fixed, "7"},
    {7e1, chars_format::fixed, "70"},
    {7e2, chars_format::fixed, "700"},
    {7e3, chars_format::fixed, "7000"},

    // Test the maximum value in fixed notation.
    {0x1.fffffffffffffp+1023, chars_format::fixed,
        "1797693134862315708145274237317043567980705675258449965989174768031572607800285387605895586327668781715404"
        "5895351438246423432132688946418276846754670353751698604991057655128207624549009038932894407586850845513394"
        "2304583236903222948165808559332123348274797826204144723168738177180919299881250404026184124858368"},

    // Test highly-trimmed powers of 2.
    {0x1p959, chars_format::fixed,
        "4872657005699999540176691193937594155438113428797503763433953228606474345383213051232807532941005129612652"
        "4581157043340917295849326015470232889936481563267097656388499782365149353948277450268241763997967396091894"
        "36842798962697437472873181807734482806413869401552138773540914294995957055488"},
    {0x1p959, chars_format::scientific, "4.8726570057e+288"},
    {0x1p960, chars_format::fixed,
        "9745314011399999080353382387875188310876226857595007526867906457212948690766426102465615065882010259225304"
        "9162314086681834591698652030940465779872963126534195312776999564730298707896554900536483527995934792183788"
        "73685597925394874945746363615468965612827738803104277547081828589991914110976"},
    {0x1p960, chars_format::scientific, "9.7453140114e+288"},

    // Test powers of 10 that are exactly representable.
    {1e0, chars_format::fixed, "1"},
    {1e1, chars_format::fixed, "10"},
    {1e2, chars_format::fixed, "100"},
    {1e3, chars_format::fixed, "1000"},
    {1e4, chars_format::fixed, "10000"},
    {1e5, chars_format::fixed, "100000"},
    {1e6, chars_format::fixed, "1000000"},
    {1e7, chars_format::fixed, "10000000"},
    {1e8, chars_format::fixed, "100000000"},
    {1e9, chars_format::fixed, "1000000000"},
    {1e10, chars_format::fixed, "10000000000"},
    {1e11, chars_format::fixed, "100000000000"},
    {1e12, chars_format::fixed, "1000000000000"},
    {1e13, chars_format::fixed, "10000000000000"},
    {1e14, chars_format::fixed, "100000000000000"},
    {1e15, chars_format::fixed, "1000000000000000"},
    {1e16, chars_format::fixed, "10000000000000000"},
    {1e17, chars_format::fixed, "100000000000000000"},
    {1e18, chars_format::fixed, "1000000000000000000"},
    {1e19, chars_format::fixed, "10000000000000000000"},
    {1e20, chars_format::fixed, "100000000000000000000"},
    {1e21, chars_format::fixed, "1000000000000000000000"},
    {1e22, chars_format::fixed, "10000000000000000000000"},

    // Test powers of 10 that aren't exactly representable.
    // This exercises the "adjustment" code.
    {1e23, chars_format::fixed, "99999999999999991611392"},
    {1e24, chars_format::fixed, "999999999999999983222784"},
    {1e25, chars_format::fixed, "10000000000000000905969664"},
    {1e26, chars_format::fixed, "100000000000000004764729344"},
    {1e27, chars_format::fixed, "1000000000000000013287555072"},
    {1e28, chars_format::fixed, "9999999999999999583119736832"},
    {1e29, chars_format::fixed, "99999999999999991433150857216"},
    {1e30, chars_format::fixed, "1000000000000000019884624838656"},
    {1e31, chars_format::fixed, "9999999999999999635896294965248"},
    {1e32, chars_format::fixed, "100000000000000005366162204393472"},
    {1e33, chars_format::fixed, "999999999999999945575230987042816"},
    {1e34, chars_format::fixed, "9999999999999999455752309870428160"},
    {1e35, chars_format::fixed, "99999999999999996863366107917975552"},
    {1e36, chars_format::fixed, "1000000000000000042420637374017961984"},
    {1e37, chars_format::fixed, "9999999999999999538762658202121142272"},
    {1e38, chars_format::fixed, "99999999999999997748809823456034029568"},
    {1e39, chars_format::fixed, "999999999999999939709166371603178586112"},
    {1e40, chars_format::fixed, "10000000000000000303786028427003666890752"},
    {1e41, chars_format::fixed, "100000000000000000620008645040778319495168"},
    {1e42, chars_format::fixed, "1000000000000000044885712678075916785549312"},
    {1e43, chars_format::fixed, "10000000000000000139372116959414099130712064"},
    {1e44, chars_format::fixed, "100000000000000008821361405306422640701865984"},
    {1e45, chars_format::fixed, "999999999999999929757289024535551219930759168"},
    {1e46, chars_format::fixed, "9999999999999999931398190359470212947659194368"},
    {1e47, chars_format::fixed, "100000000000000004384584304507619735463404765184"},
    {1e48, chars_format::fixed, "1000000000000000043845843045076197354634047651840"},
    {1e49, chars_format::fixed, "9999999999999999464902769475481793196872414789632"},
    {1e50, chars_format::fixed, "100000000000000007629769841091887003294964970946560"},
    {1e51, chars_format::fixed, "999999999999999993220948674361627976461708441944064"},
    {1e52, chars_format::fixed, "9999999999999999932209486743616279764617084419440640"},
    {1e53, chars_format::fixed, "99999999999999999322094867436162797646170844194406400"},
    {1e54, chars_format::fixed, "1000000000000000078291540404596243842305360299886116864"},
    {1e55, chars_format::fixed, "10000000000000000102350670204085511496304388135324745728"},
    {1e56, chars_format::fixed, "100000000000000009190283508143378238084034459715684532224"},
    {1e57, chars_format::fixed, "1000000000000000048346692115553659057528394845890514255872"},
    {1e58, chars_format::fixed, "9999999999999999438119489974413630815797154428513196965888"},
    {1e59, chars_format::fixed, "99999999999999997168788049560464200849936328366177157906432"},
    {1e60, chars_format::fixed, "999999999999999949387135297074018866963645011013410073083904"},
    {1e61, chars_format::fixed, "9999999999999999493871352970740188669636450110134100730839040"},
    {1e62, chars_format::fixed, "100000000000000003502199685943161173046080317798311825604870144"},
    {1e63, chars_format::fixed, "1000000000000000057857959942726969827393378689175040438172647424"},
    {1e64, chars_format::fixed, "10000000000000000213204190094543968723012578712679649467743338496"},
    {1e65, chars_format::fixed, "99999999999999999209038626283633850822756121694230455365568299008"},
    {1e66, chars_format::fixed, "999999999999999945322333868247445125709646570021247924665841614848"},
    {1e67, chars_format::fixed, "9999999999999999827367757839185598317239782875580932278577147150336"},
    {1e68, chars_format::fixed, "99999999999999995280522225138166806691251291352861698530421623488512"},
    {1e69, chars_format::fixed, "1000000000000000072531436381529235126158374409646521955518210155479040"},
    {1e70, chars_format::fixed, "10000000000000000725314363815292351261583744096465219555182101554790400"},
    {1e71, chars_format::fixed, "100000000000000004188152556421145795899143386664033828314342771180699648"},
    {1e72, chars_format::fixed, "999999999999999943801810948794571024057224129020550531544123892056457216"},
    {1e73, chars_format::fixed, "9999999999999999830336967949613257980309080240684656321838454199566729216"},
    {1e74, chars_format::fixed, "99999999999999995164818811802792197885196090803013355167206819763650035712"},
    {1e75, chars_format::fixed, "999999999999999926539781176481198923508803215199467887262646419780362305536"},
    {1e76, chars_format::fixed, "10000000000000000470601344959054695891559601407866630764278709534898249531392"},
    {1e77, chars_format::fixed, "99999999999999998278261272554585856747747644714015897553975120217811154108416"},
    {1e78, chars_format::fixed, "1000000000000000008493621433689702976148869924598760615894999102702796905906176"},
    {1e79, chars_format::fixed, "9999999999999999673560075006595519222746403606649979913266024618633003221909504"},
    {1e80, chars_format::fixed, "100000000000000000026609864708367276537402401181200809098131977453489758916313088"},
    {1e81, chars_format::fixed, "999999999999999921281879895665782741935503249059183851809998224123064148429897728"},
    {1e82, chars_format::fixed, "9999999999999999634067965630886574211027143225273567793680363843427086501542887424"},
    {1e83, chars_format::fixed, "100000000000000003080666323096525690777025204007643346346089744069413985291331436544"},
    {1e84, chars_format::fixed,
        "1000000000000000057766609898115896702437267127096064137098041863234712334016924614656"},
    {1e85, chars_format::fixed,
        "10000000000000000146306952306748730309700429878646550592786107871697963642511482159104"},
    {1e86, chars_format::fixed,
        "100000000000000001463069523067487303097004298786465505927861078716979636425114821591040"},
    {1e87, chars_format::fixed,
        "999999999999999959416724456350362731491996089648451439669739009806703922950954425516032"},
    {1e88, chars_format::fixed,
        "9999999999999999594167244563503627314919960896484514396697390098067039229509544255160320"},
    {1e89, chars_format::fixed,
        "99999999999999999475366575191804932315794610450682175621941694731908308538307845136842752"},
    {1e90, chars_format::fixed,
        "999999999999999966484112715463900049825186092620125502979674597309179755437379230686511104"},
    {1e91, chars_format::fixed,
        "10000000000000000795623248612804971431562261401669105159386439973487930752201761134141767680"},
    {1e92, chars_format::fixed,
        "100000000000000004337729697461918607329029332495193931179177378933611681288968111094132375552"},
    {1e93, chars_format::fixed,
        "1000000000000000043377296974619186073290293324951939311791773789336116812889681110941323755520"},
    {1e94, chars_format::fixed,
        "10000000000000000202188791271559469885760963232143577411377768562080040049981643093586978275328"},
    {1e95, chars_format::fixed,
        "100000000000000002021887912715594698857609632321435774113777685620800400499816430935869782753280"},
    {1e96, chars_format::fixed,
        "1000000000000000049861653971908893017010268485438462151574892930611988399099305815384459015356416"},
    {1e97, chars_format::fixed,
        "10000000000000000735758738477112498397576062152177456799245857901351759143802190202050679656153088"},
    {1e98, chars_format::fixed,
        "99999999999999999769037024514370800696612547992403838920556863966097586548129676477911932478685184"},
    {1e99, chars_format::fixed,
        "999999999999999967336168804116691273849533185806555472917961779471295845921727862608739868455469056"},
    {1e100, chars_format::fixed,
        "10000000000000000159028911097599180468360808563945281389781327557747838772170381060813469985856815104"},
    {1e101, chars_format::fixed,
        "99999999999999997704951326524533662844684271992415000612999597473199345218078991130326129448151154688"},
    {1e102, chars_format::fixed,
        "999999999999999977049513265245336628446842719924150006129995974731993452180789911303261294481511546880"},
    {1e103, chars_format::fixed,
        "10000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328"},
    {1e104, chars_format::fixed,
        "10000000000000000019156750857346687362159551272651920111528035145993793242039887559612361451081803235328"
        "0"},
    {1e105, chars_format::fixed,
        "99999999999999993825830082528197854032702736447212447829441621253887149182459971363682052750390825530163"
        "2"},
    {1e106, chars_format::fixed,
        "1000000000000000091035999050368435010460453995175486557154545737484090289535133415215418009754161219056435"
        "2"},
    {1e107, chars_format::fixed,
        "9999999999999999688138404702992698343537126906127968940664421175279152513667064539525400239539588480525926"
        "4"},
    {1e108, chars_format::fixed,
        "1000000000000000033998991713002824594943974719712898047713430714837875271723200833292741616380733445921308"
        "672"},
    {1e109, chars_format::fixed,
        "9999999999999999818508707188399807864717650964328171247958398369899072554380053298205803424393137676263358"
        "464"},
    {1e110, chars_format::fixed,
        "1000000000000000023569367514170255833249532795056881863129912539268281668466161732598309361592449510262314"
        "10688"},
    {1e111, chars_format::fixed,
        "9999999999999999568197726416418157584051044772583782817953962156228826076211114881539429309474323220447488"
        "90112"},
    {1e112, chars_format::fixed,
        "9999999999999999301199346926304397284673331501389768492615896861647229832830913903761963586894254467577228"
        "034048"},
    {1e113, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "28086784"},
    {1e114, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "280867840"},
    {1e115, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "2808678400"},
    {1e116, chars_format::fixed,
        "1000000000000000015559416129466843024268201396921061433369770580430833781164755703264985389915047447676206"
        "28086784000"},
    {1e117, chars_format::fixed,
        "1000000000000000050555427725995033814228237030803003279020481474722232763977085405824233377105062219252417"
        "113236701184"},
    {1e118, chars_format::fixed,
        "9999999999999999665649998943273759183241515094863428494587753284228752052274941196820382078490267674695111"
        "155514343424"},
    {1e119, chars_format::fixed,
        "9999999999999999441675524725493338127497287038019000682423203560763798562276031100441194960474173136607361"
        "8283536318464"},
    {1e120, chars_format::fixed,
        "9999999999999999800034683473942011816688051928970085181886483118307724146274287254647894349299924397547760"
        "75181077037056"},
    {1e121, chars_format::fixed,
        "1000000000000000037340933747145988971939327575449182038102773041037800508067149710137861337142112641505239"
        "9029342192009216"},
    {1e122, chars_format::fixed,
        "1000000000000000014405947587245273855831118622428312630137123149354989270691261316268632576257264560805054"
        "37183296233537536"},
    {1e123, chars_format::fixed,
        "9999999999999999777099697314041296700579842975949215773920833226624912908898398860778665588415076316847575"
        "22070951350501376"},
    {1e124, chars_format::fixed,
        "9999999999999999483531874467312143214394768377282087351960514613084929070487027419252537449089020883885200"
        "422613425626021888"},
    {1e125, chars_format::fixed,
        "9999999999999999248677616189928820425446708698348384614392259722252941999757930266031634937628176537515300"
        "5841365553228283904"},
    {1e126, chars_format::fixed,
        "9999999999999999248677616189928820425446708698348384614392259722252941999757930266031634937628176537515300"
        "58413655532282839040"},
    {1e127, chars_format::fixed,
        "9999999999999999549291066784979473595300225087383524118479625982517885450291174622154390152298057300868772"
        "377386949310916067328"},
    {1e128, chars_format::fixed,
        "1000000000000000075174486916518208627471429064352408213482909102357765925242415204664541101097758035428265"
        "95503885252632667750400"},
    {1e129, chars_format::fixed,
        "9999999999999999982174435641852414159889288687594125004365433397299404019059046494971157661422685600097771"
        "75966751665376232210432"},
    {1e130, chars_format::fixed,
        "1000000000000000059783078246051615185174929025233809070873635949832200820575113093631056034106660140344568"
        "1992244323541365884452864"},
    {1e131, chars_format::fixed,
        "9999999999999999120255550095723181391285286496952573018246136855867758157690128277095993909921203475410697"
        "4340599870111173348163584"},
    {1e132, chars_format::fixed,
        "9999999999999999908295674023612765636866088499824849119840922265176691516655996362010429339865415703696022"
        "53175829982724989462249472"},
    {1e133, chars_format::fixed,
        "1000000000000000022351172359476859933509840930097375956047883642890026486024234359597620351184310059501015"
        "2570837624953702918544949248"},
    {1e134, chars_format::fixed,
        "9999999999999999214820364967069931500754982737297246150437511104984830160766032447285726161514508942804936"
        "4457837845490532419930947584"},
    {1e135, chars_format::fixed,
        "9999999999999999618296908418149398634492353362767851514454041234551004040556556906761917101645945603687022"
        "89580532071091311261383655424"},
    {1e136, chars_format::fixed,
        "1000000000000000058664061270074011975546204286389730438809371354550982135205381560950477535796139358980403"
        "0375857007499376802103616864256"},
    {1e137, chars_format::fixed,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "50478432243557864849063421149184"},
    {1e138, chars_format::fixed,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "504784322435578648490634211491840"},
    {1e139, chars_format::fixed,
        "1000000000000000032841562489204926078987012566359611695512313426258747006898787995544001315627727412683949"
        "5047843224355786484906342114918400"},
    {1e140, chars_format::fixed,
        "1000000000000000059283801240814870037063624887670453288648500744829995778284739806520232965080181245691517"
        "92237293382948229697163514582401024"},
    {1e141, chars_format::fixed,
        "1000000000000000016976219238238959704141045173573106739630601035115997744067216908958262325956255112879408"
        "454231155599236459402033650892537856"},
    {1e142, chars_format::fixed,
        "1000000000000000050822284840299687970479108944850983978844920802887196171441235227007838837255396019129096"
        "0287445781834331294577148468377157632"},
    {1e143, chars_format::fixed,
        "1000000000000000023745432358651105357408657927828682187473464988670237429542020572568177628216083294129345"
        "96913384011607579341316989008157343744"},
    {1e144, chars_format::fixed,
        "1000000000000000023745432358651105357408657927828682187473464988670237429542020572568177628216083294129345"
        "969133840116075793413169890081573437440"},
    {1e145, chars_format::fixed,
        "9999999999999999890870611821409196126784806260401358945180015464725302399110258148854112806457630061296658"
        "928320953898584032761523454337112604672"},
    {1e146, chars_format::fixed,
        "9999999999999999336336672997246224211101969431784618257892600389561987365014342025929851245332505453301777"
        "7074930382791057905692427399713177731072"},
    {1e147, chars_format::fixed,
        "9999999999999999779963824056576601743648238894678010807722532449692639392291074924269260494232605139697682"
        "68415537077468838432306731146395363835904"},
    {1e148, chars_format::fixed,
        "1000000000000000048976726575150520579572227003530743888745042374590168263593384756161231529247276463793113"
        "0646815102767620534329186625852171022761984"},
    {1e149, chars_format::fixed,
        "1000000000000000048976726575150520579572227003530743888745042374590168263593384756161231529247276463793113"
        "06468151027676205343291866258521710227619840"},
    {1e150, chars_format::fixed,
        "9999999999999999808355961724373745905731200140303187930911648101541001122036785829762982686162211519627020"
        "60266176005440567032331208403948233373515776"},
    {1e151, chars_format::fixed,
        "1000000000000000017177532387217719118039310408430545510773232844520003126278188542008262674286117318272254"
        "5959543542834786931126445173006249634549465088"},
    {1e152, chars_format::fixed,
        "1000000000000000046251081359041994740012262723950726884918887272012725537537796509233834198822034251319896"
        "62450489690590919397689516441796634752009109504"},
    {1e153, chars_format::fixed,
        "9999999999999999997334030041231537448555390191184366862858401880243696795224237616729197595645671584436693"
        "78824028710020392594094129030220133015859757056"},
    {1e154, chars_format::fixed,
        "1000000000000000036947545688058226540980917982984268845192277855215054365934721959721651310970540832744651"
        "1753687232667314337003349573404171046192448274432"},
    {1e155, chars_format::fixed,
        "1000000000000000007176231540910168304080614811891603118067127721462506616804883401282666069845761893303865"
        "73813296762136260081534229469225952733653677113344"},
    {1e156, chars_format::fixed,
        "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373"
        "88344363105067534507348164573733465510370326085632"},
    {1e157, chars_format::fixed,
        "9999999999999999833591802231917217145603722750174705363670076144604684175010125545314778769459387417512373"
        "883443631050675345073481645737334655103703260856320"},
    {1e158, chars_format::fixed,
        "9999999999999999528733545365121100799744618278185808317908538774978595223920578706899569900341651077638731"
        "0061494932420984963311567802202010637287727642443776"},
    {1e159, chars_format::fixed,
        "9999999999999999284846939871684207723057334700594690681299308879277724063048941236167402805047462005739816"
        "70431418299523701733729688780649419062882836695482368"},
    {1e160, chars_format::fixed,
        "1000000000000000006528407745068226556845664214888626711844884454552051177783818114251033750998886703581634"
        "2470187175785193750117648543530356184548650438281396224"},
    {1e161, chars_format::fixed,
        "1000000000000000037745893248228148870661636512820289769330865881201762686375387710504751139196542904784695"
        "27765363729011764432297892058199009821165792668120252416"},
    {1e162, chars_format::fixed,
        "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999"
        "79621894213003182527093908649335762989920701551401238528"},
    {1e163, chars_format::fixed,
        "9999999999999999378499396381163974664505251594389679853757253159226858588823650024928554969640430609348999"
        "796218942130031825270939086493357629899207015514012385280"},
    {1e164, chars_format::fixed,
        "1000000000000000001783349948587918365145636425603013927107015277701295028477899535620468707992842960998768"
        "97036220978235643807646031628623453753183252563447406133248"},
    {1e165, chars_format::fixed,
        "9999999999999998994898934518334849272334583997405404203369513388555203571250442826162875703467631208965785"
        "85177704871391229197474064067196498264773607101557544845312"},
    {1e166, chars_format::fixed,
        "9999999999999999404072760505352583023983296100855298230449769143938302256661863838179600254051950569374547"
        "392515068357773127490685649548117139715971745147241514401792"},
    {1e167, chars_format::fixed,
        "1000000000000000038608994287419514402794020514913504389544238295685773910164927426701973917545431703435557"
        "50902863155030391327289536708508823166797373630632400726786048"},
    {1e168, chars_format::fixed,
        "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145"
        "54599698521475539380813444812793279458505403728617494385000448"},
    {1e169, chars_format::fixed,
        "9999999999999999338604948347429745623719502164303315186116928223077006466996036476256924325958459471709145"
        "545996985214755393808134448127932794585054037286174943850004480"},
    {1e170, chars_format::fixed,
        "1000000000000000034419054309312452809177137702974177474706936476750650979626314475538922658147448273184971"
        "79085147422915077831721209019419643357959500300321574675254607872"},
    {1e171, chars_format::fixed,
        "9999999999999999539722067296568702117329877137391007098307415531962907132849458132083384777061664123737260"
        "01850053663010587168093173889073910282723323583537144858509574144"},
    {1e172, chars_format::fixed,
        "1000000000000000082687162857105802367643627696515223533632653430883267139431135672937273166412217389671719"
        "2642523265688348930066834399772699475577180106550229078889679814656"},
    {1e173, chars_format::fixed,
        "1000000000000000014039186255799705217824619705701291360938300429450213045486501081081841332435656868446122"
        "85763778101906192989276863139689872767772084421689716760605683089408"},
    {1e174, chars_format::fixed,
        "1000000000000000068957567536844582937679826098352437099093782830596656320642208754566186799616905285426599"
        "982929417458880300383900478261195703581718577367397759832385751351296"},
    {1e175, chars_format::fixed,
        "9999999999999999371534524623368764100273307559896873275206250678451924602685103382037576783819090846734548"
        "822294900033162112051840457868829614121240178061963384891963422539776"},
    {1e176, chars_format::fixed,
        "1000000000000000007448980502074319891441994938583153872359642541312639852467816160263719876373907058408465"
        "60260278464628372543383280977318309056924111623883709653889736043921408"},
    {1e177, chars_format::fixed,
        "1000000000000000007448980502074319891441994938583153872359642541312639852467816160263719876373907058408465"
        "602602784646283725433832809773183090569241116238837096538897360439214080"},
    {1e178, chars_format::fixed,
        "1000000000000000052438118447506283719547380015442972461056613724331806183475371886382095683088785761598872"
        "4636416932177829345401680187244151732297960592357271816907060120777654272"},
    {1e179, chars_format::fixed,
        "9999999999999999804554977348151415945787638924672627191414598315011400538632827245926943923449798364942214"
        "8597943950338419997003168440244384097290815044070304544781216945608327168"},
    {1e180, chars_format::fixed,
        "1000000000000000009248546019891598444566210341657546615907521388633406505708118389308454908642502206536081"
        "877044340989143693798086218131232373875663313958712699944969706504756133888"},
    {1e181, chars_format::fixed,
        "9999999999999999171107915076469365246063817042486381462561244058101538598046442622180212564904306224021286"
        "256366562347133135483117101991090685868467907010818055540655879490029748224"},
    {1e182, chars_format::fixed,
        "1000000000000000064531198727238395596542107524102891697698359578327358093250202865562715099933745157016453"
        "82788895184180192194795092289050635704895322791329123657951217763820802932736"},
    {1e183, chars_format::fixed,
        "9999999999999999465948729515652283389935268682194888565445714403135947064937559828869600251790935293249936"
        "66087115356131035228239552737388526279268078143523691759154905886843985723392"},
    {1e184, chars_format::fixed,
        "1000000000000000017356668416969128693522675261749530561236844323121852738547624112492413070031884505939869"
        "7631682172475335672600663748292592247410791680053842186513692689376624118857728"},
    {1e185, chars_format::fixed,
        "9999999999999999796170441687537151711071294518668416520676321189574484547855611100361714461103959850786025"
        "1139162957211888350975873638026151889477992007905860430885494197722591793250304"},
    {1e186, chars_format::fixed,
        "9999999999999999796170441687537151711071294518668416520676321189574484547855611100361714461103959850786025"
        "11391629572118883509758736380261518894779920079058604308854941977225917932503040"},
    {1e187, chars_format::fixed,
        "9999999999999999071569656121801212080692814968920789464627446869617922299624001453201875281811380250249693"
        "879805812353226907091680705581859236698853640605134247712274342131878495422251008"},
    {1e188, chars_format::fixed,
        "1000000000000000023093091302697871548929838224851699275430564578154842189679457688865761796867950761110782"
        "38543825857419659919011313587350687602971665369018571203143144663564875896666980352"},
    {1e189, chars_format::fixed,
        "1000000000000000023093091302697871548929838224851699275430564578154842189679457688865761796867950761110782"
        "385438258574196599190113135873506876029716653690185712031431446635648758966669803520"},
    {1e190, chars_format::fixed,
        "1000000000000000072559171597318778361030342428781137282456834398397210172492068907445206818174324195174062"
        "5976868675721161334753163637413771490365780039321792212624518252692320803210995433472"},
    {1e191, chars_format::fixed,
        "1000000000000000072559171597318778361030342428781137282456834398397210172492068907445206818174324195174062"
        "59768686757211613347531636374137714903657800393217922126245182526923208032109954334720"},
    {1e192, chars_format::fixed,
        "1000000000000000040900880208761398001286019738266296957960021713442094663491997727554362004538245197373563"
        "261847757813447631532786297905940174312186739777303375354598782943738754654264509857792"},
    {1e193, chars_format::fixed,
        "1000000000000000066227513319607302289081477890678169217557471861406187070692054671467037855447108395613962"
        "7305190456203824330868103505742897540916997511012040520808812168041334151877325366493184"},
    {1e194, chars_format::fixed,
        "9999999999999999446596743875469617076632787591011823714897111511785435161317813406861937710845650440600452"
        "8089686414709538562749489776621177115003729674648080379472553427423904462708600804999168"},
    {1e195, chars_format::fixed,
        "9999999999999999770777647694297191960414651941883788637744473405725817973478542288944188602479099378077566"
        "00796112539971931616645685181699233267813951241073670004367049615544210109925082343145472"},
    {1e196, chars_format::fixed,
        "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875"
        "448767138256706948253250552493092635735926276453993770366538373425000777236538229086224384"},
    {1e197, chars_format::fixed,
        "9999999999999999511432924639235132053389160461186216699466583890573511723749959183278387889172340228095875"
        "4487671382567069482532505524930926357359262764539937703665383734250007772365382290862243840"},
    {1e198, chars_format::fixed,
        "1000000000000000017535541566019400541537441865177200086145798104936341572305513193378283771523764365204900"
        "328030374534281861011105867876227585990799216050325567033999660761493056632508247061001404416"},
    {1e199, chars_format::fixed,
        "1000000000000000097206240488534465344975672848047494185584765763991130052222133923438817750651600776079275"
        "6678147673846152604340428430285295728914471221362369950308146488642846313231335560438561636352"},
    {1e200, chars_format::fixed,
        "9999999999999999697331222125103616594745032754550236264824175095034684843555407553419633840470625186802751"
        "2415973882408182135734368278484639385041047239877871023591066789981811181813306167128854888448"},
    {1e201, chars_format::fixed,
        "1000000000000000037718785293056550291741793714171007924670336578563554653884390444993619046236149589293075"
        "414109087389699655531583234914810756005630018925423128793192791080866922220799992003324610084864"},
    {1e202, chars_format::fixed,
        "9999999999999999017474591319641730272072128367390393282944984404433823148266910656903077218579754480674748"
        "342103902584639871831041306548820316951909258721342916786285447187693014154661313392524876840960"},
    {1e203, chars_format::fixed,
        "9999999999999999887691078750632944765093445982954992299750348488402926118236186684444269694600068984518592"
        "0534555642245481492613075738123641525387194542623914743194966239051177873087980216425864602058752"},
    {1e204, chars_format::fixed,
        "9999999999999999887691078750632944765093445982954992299750348488402926118236186684444269694600068984518592"
        "05345556422454814926130757381236415253871945426239147431949662390511778730879802164258646020587520"},
    {1e205, chars_format::fixed,
        "1000000000000000016616035472855013340286026761993566398512806499527303906862635501325745128692656962574862"
        "2041088095949318798038992779336698179926498716835527012730124200454693714718121768282606166882648064"},
    {1e206, chars_format::fixed,
        "1000000000000000038893577551088388431307372492952020133343023820076912942893848967630799656078777013873264"
        "60311941213291353170611409437561654018367221268940354434586262616943544566455807655946219322240663552"},
    {1e207, chars_format::fixed,
        "1000000000000000038893577551088388431307372492952020133343023820076912942893848967630799656078777013873264"
        "603119412132913531706114094375616540183672212689403544345862626169435445664558076559462193222406635520"},
    {1e208, chars_format::fixed,
        "9999999999999999818630698308109481982927274216983785721776674794699138106539424938898600659703096825493544"
        "616522696356805028364441642842329313746550197144253860793660984920822957311285732475861572950035529728"},
    {1e209, chars_format::fixed,
        "1000000000000000073111882183254852571116159535704205070042237624441112422237792851875363410143857412667610"
        "68799969763125334902791605243044670546908252847439043930576054277584733562461577854658781477884848504832"},
    {1e210, chars_format::fixed,
        "9999999999999999271137824193446055745986681532948826734589253924871946437036322790985580594661810444784007"
        "25843812838336795121561031396504666917998514458446354143529431921823271795036250068185162804696593727488"},
    {1e211, chars_format::fixed,
        "9999999999999999563134023721266549739021664297767471527755878388779781994104643936539191296017163181162427"
        "18274989796920105902832035603293074628215317261635171175975654092628084560952155763865693199526971991654"
        "4"},
    {1e212, chars_format::fixed,
        "9999999999999999095940104476753759350165691874057639858689279246527245102795330103653414173848598802956955"
        "303851066631868086527984288724316222918684327765330639240616986193403841354867066507768445677983667689881"
        "6"},
    {1e213, chars_format::fixed,
        "9999999999999999843450375267974223972335247751993370529195837874131304128890232236270657569318301808085710"
        "3100891967716008425285219964180994603002344795269643552712402737660070481623142523171900237856413512525414"
        "4"},
    {1e214, chars_format::fixed,
        "9999999999999999544446266951486038123467425400819078260993214423089680518452271383223760211130420606034208"
        "3075939447157077401283069133405861653476144188223108688589909587369657654393353779934213925425782778274775"
        "04"},
    {1e215, chars_format::fixed,
        "9999999999999999066039693645104940765278909638940210631869016901423082741751534018348724438029810682751805"
        "1036015414262787762879627804165648934234223216948652905993920546904997130825691790753915825536773603473752"
        "064"},
    {1e216, chars_format::fixed,
        "1000000000000000021421546958041957442493134746744949294176709095342291740583330369404881029347127449862957"
        "2793183309320908289504788699434215946041483354800734678422429424402018238738808056478663126527039562299620"
        "72064"},
    {1e217, chars_format::fixed,
        "9999999999999999601855055748251769806450047292244542376488118125689672251656359867008764503902493796828096"
        "6920730331104392157891482092914687179785174704776043382501428272225416917221473218635849697412463879250897"
        "79712"},
    {1e218, chars_format::fixed,
        "1000000000000000082657588341258737904341264764265444350704606378115616256001024752108885608304005520043104"
        "8894293585531377363220429189576963174104449239123865018594716021581494785755468791093741283312832736674151"
        "6615680"},
    {1e219, chars_format::fixed,
        "9999999999999999650843888854825194175928551306260938421710435951908331863990515373171968167067996252972214"
        "7801618552072767416863994485028884962235547412234547654639257549968998154834801806327912222841098418750522"
        "5498624"},
    {1e220, chars_format::fixed,
        "9999999999999999964372420736895110140590976995965873111133270039707753382929110612616471611327211972294570"
        "5439303166270369074288073794559750769917932739968974996321364927527918075560104767557112385584359471548120"
        "96741376"},
    {1e221, chars_format::fixed,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "8435495936"},
    {1e222, chars_format::fixed,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "84354959360"},
    {1e223, chars_format::fixed,
        "1000000000000000046601807174820697568405085809949376861420980458018682781323086299572767712214195712321033"
        "9765959854898653172616660068980913606220974926434405874301273673162218994872058950552383264597357715602427"
        "843549593600"},
    {1e224, chars_format::fixed,
        "9999999999999999695490351794831950209296480724474921121484247526010969488287371335268865457530508571403718"
        "2409224841134505892881183378706080253249519082903930108094789640533388351546084948006950326015738792668900"
        "564521713664"},
    {1e225, chars_format::fixed,
        "9999999999999999284542234486365269956094146124464869125363950430450511714984175783024165903071069343773520"
        "0942358863613425448462294146117783821804062986135861502805217858619360833053015850664613088704891665546032"
        "3666687950848"},
    {1e226, chars_format::fixed,
        "9999999999999999613300728333138614158656013804472910722260188106898877933626732224819925546638620725877678"
        "6115851645630289803997405532188420966960427863550316387036875284150582847847471128538482878553569367244326"
        "92495112994816"},
    {1e227, chars_format::fixed,
        "1000000000000000092833470372023199096890348452450507710984513881269234280819695799200296412090882625429431"
        "2680982277369774722613785107647096954758588737320813592396350498627547090702529224003396203794828017403750"
        "5158080469401600"},
    {1e228, chars_format::fixed,
        "9999999999999999245091215224752468651786722002863904133736401909276707768747069010008674745842963177921021"
        "0721539729771401725798080779789307364385299200846126916697418967555614191277681217319748713923050341342237"
        "0196749149011968"},
    {1e229, chars_format::fixed,
        "9999999999999999918388610622944277578633427011520373324179896670642961784527024602806390495869308408470337"
        "7156852947341939925933988898461972237665534469790930519603853375043556877576725626405434043533142274420344"
        "27503713670135808"},
    {1e230, chars_format::fixed,
        "1000000000000000099566444326005117186158815502537072402888948828882896820977495355128273569591146077734924"
        "4345335409545480104615144188833823603491391090010261628425414842702426517565519668094253057090928936734531"
        "5883616691581616128"},
    {1e231, chars_format::fixed,
        "1000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768"
        "1693475363620965659806446069238773051601456032797794197839403040623198185642380825912769195995883053017532"
        "72401848696295129088"},
    {1e232, chars_format::fixed,
        "1000000000000000056475411020520841414840626381983058374700565164155456563967578197189219761589459982979768"
        "1693475363620965659806446069238773051601456032797794197839403040623198185642380825912769195995883053017532"
        "724018486962951290880"},
    {1e233, chars_format::fixed,
        "9999999999999999737406270739910319339097032705193514405788685278787712705085372539462364502262226810498681"
        "4019040754458979257737456796162759919727807229498567311142603806310797883499542489243201826933949562808949"
        "044795771481474727936"},
    {1e234, chars_format::fixed,
        "1000000000000000017865845178806930323739528929966661805443773400559670093686692423675827549619949242079148"
        "1557408762472600717257852554081607757108074221535423380034336465960209600239248423318159656454721941207101"
        "74156699571604284243968"},
    {1e235, chars_format::fixed,
        "1000000000000000053166019662659649035603389457524510097335697298704389152229216559459500429134930490902572"
        "1681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067"
        "211236930570359138156544"},
    {1e236, chars_format::fixed,
        "1000000000000000053166019662659649035603389457524510097335697298704389152229216559459500429134930490902572"
        "1681812512093962950445138053653873169216309020403876699170397334223513449750683762833231235463783529148067"
        "2112369305703591381565440"},
    {1e237, chars_format::fixed,
        "9999999999999999402054613143309491576390357693393955632815408246412881648931393249517472146869904946676153"
        "2837205133056038042458244550226238504699576640248260779350025557809411313140906763850021826347864477369777"
        "0829313903654699186257920"},
    {1e238, chars_format::fixed,
        "1000000000000000048647597328726501040484815309997105515973531039741865112735773470079190300557012891053173"
        "8945888832142428584597165509708623196466454966148714674320981543085810557013220039375302073350623645891623"
        "631119178909006652304785408"},
    {1e239, chars_format::fixed,
        "9999999999999999908117914543822067029670662216463268745378029250215574072197019260112206547596676129808759"
        "9260657287627887017431169472094235452683230716826407562484594165232135299736843791138087983021771402091458"
        "056119576436948334022754304"},
    {1e240, chars_format::fixed,
        "1000000000000000013946113804119924437974165856986638331112094170909680489426130543638408513078605724209795"
        "1533994970114644654884736372209103405747575829469070323477468267148252340789498643218406108321555742482136"
        "93581484614981956096327942144"},
    {1e241, chars_format::fixed,
        "1000000000000000050961029563700272813985525273531136661630960164330677420956416331841909086388906702176065"
        "8106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922"
        "744139467759619125060885807104"},
    {1e242, chars_format::fixed,
        "1000000000000000050961029563700272813985525273531136661630960164330677420956416331841909086388906702176065"
        "8106681756277614179911327452208591182514380241927357631043882428148314438094801465785761804352561506118922"
        "7441394677596191250608858071040"},
    {1e243, chars_format::fixed,
        "1000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479"
        "0313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465"
        "66146722558989084608335389392896"},
    {1e244, chars_format::fixed,
        "1000000000000000074650575649831695774632795300119615593163034400120115457135799236292149453307499328074479"
        "0313201299421914675928345743408263359645135065900661507886387491188354180370195272228869449812405194846465"
        "661467225589890846083353893928960"},
    {1e245, chars_format::fixed,
        "1000000000000000044327956659583474385004289666086362560801979378309634770826189118595841783651700766924510"
        "1088856284197210041026562330672682972917768891214832545527981010497103310257691199981691663623805273275210"
        "7272876955671430431745947427930112"},
    {1e246, chars_format::fixed,
        "1000000000000000068586051851782051496707094173312964986690823395758019319873877212752887919376339615844485"
        "2468332296376973748947989060861147282299661830963495715414706195050104006347694457779433892574685210532214"
        "67463131958534128550160206370177024"},
    {1e247, chars_format::fixed,
        "9999999999999999521471949292288813605336325386252733424243721120057734844449743607990664678980731410286045"
        "8468474379141079509251407559565185972665757201699124999584253091957006651156788203502711936104615116985957"
        "27381924297989722331966923339726848"},
    {1e248, chars_format::fixed,
        "1000000000000000045298280467271417469472401846375426657837533139007570152788096642362123629080686320881309"
        "1144035324684400589343419399880221545293044608804779072323450017879223338101291330293601352781840470765490"
        "8851814405278709728676750356293615616"},
    {1e249, chars_format::fixed,
        "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364"
        "0811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306"
        "7478208555469597215339755257651527680"},
    {1e250, chars_format::fixed,
        "9999999999999999210968330832147026575540427693752222372866517696718412616639336002780474141705354144110364"
        "0811181423240104047857145413152842812577527572916236425034170729678597741204746503691611405533351920096306"
        "74782085554695972153397552576515276800"},
    {1e251, chars_format::fixed,
        "1000000000000000048279115204488778624958442464223431563930754291871627646175076555372141458238529942636595"
        "6593545337061049953772804316485780039629891613241094802639130808557096063636830930611787917875324597455631"
        "5302310250472271728848176952226298724352"},
    {1e252, chars_format::fixed,
        "1000000000000000099152028052998409011920202342162715294588395300751542199979533737409779075865727753926819"
        "3598516214955865773367640226553978342978747155620883266693416302792790579443373442708838628804120359634031"
        "87241060084423965317738575228107571068928"},
    {1e253, chars_format::fixed,
        "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035"
        "1826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507"
        "77435958293799716241167969694049028276224"},
    {1e254, chars_format::fixed,
        "9999999999999999363587069377675917736425707327570073564839440723358156278052707548893386994586947577981035"
        "1826094056924551506641653143357437722624094200055601817197027212385681288624374039982763538319739206631507"
        "774359582937997162411679696940490282762240"},
    {1e255, chars_format::fixed,
        "9999999999999999884525696946414532898914128477668338966773684654288481309010349092958796199089453165592925"
        "8756995846567465499292772862455788348916374954024635689112910673359193130483369363856562818230607811338327"
        "2782784390994049606075766012189756664840192"},
    {1e256, chars_format::fixed,
        "1000000000000000030127659900140542502890486539774695128832107979903274133377646232821112356269145763568243"
        "8430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378"
        "288141352402853119916429412464176397346144256"},
    {1e257, chars_format::fixed,
        "1000000000000000030127659900140542502890486539774695128832107979903274133377646232821112356269145763568243"
        "8430171727828179669341366863773446884995019955719986278664561744213800260397056562295560224215930269510378"
        "2881413524028531199164294124641763973461442560"},
    {1e258, chars_format::fixed,
        "1000000000000000056799717631659959599209893702659726317411141269166906774962677479877261307539674049653972"
        "6465033899457896865765104193391282437061184730323200812906654977415644066700237122877898747347366742071367"
        "44674199783831719918405933396323484899269935104"},
    {1e259, chars_format::fixed,
        "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743"
        "8976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194"
        "85458899748089618699435710767754281089234894848"},
    {1e260, chars_format::fixed,
        "1000000000000000065334776105746173070032103994782936297756431921731269220269887478935228971946243101201405"
        "8636189794379406368620700138868989813722357458196229463864124812040234084717254902264247074749426413290883"
        "9774942043776657045497009088429335535195969814528"},
    {1e261, chars_format::fixed,
        "9999999999999999287738405203667575368767393208115766122317814807014700953545274940077463414411382764424743"
        "8976954756352543229311650112256717871435938122277710485446074580467937964449704320826738363164716737786194"
        "8545889974808961869943571076775428108923489484800"},
    {1e262, chars_format::fixed,
        "1000000000000000016172839295009583478096172712153246810967557762960541535300357884361335224964405364288190"
        "5330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468"
        "760361494711018313643605437535869015444666630275072"},
    {1e263, chars_format::fixed,
        "1000000000000000016172839295009583478096172712153246810967557762960541535300357884361335224964405364288190"
        "5330331839631511632172467492917395324154002545647584434349098564602595580939232492998880708913562707066468"
        "7603614947110183136436054375358690154446666302750720"},
    {1e264, chars_format::fixed,
        "1000000000000000044140518902895287779286391397382581274563006173283444396083023609274483667691850832398819"
        "6988775476110313971129684287058746855997333340341924717806535718700452151977396352492066908144631837718580"
        "52833032509915549602573975010166573043840478561173504"},
    {1e265, chars_format::fixed,
        "1000000000000000066514662589203851220238566345566048845439364901541766684709156189205002421873807206887323"
        "0315530385293355842295457722371828081471997976097396944572485441978737408807927440086615867529487142240269"
        "942705389409665241931447200154303102433395309881065472"},
    {1e266, chars_format::fixed,
        "1000000000000000030716032691110149714715086428472500732037190936328451022907344061316172415182677007705717"
        "6992722530600488848430220225870898120712534558888641381746965884733480997879077699935337532513718655005566"
        "8797052865128496484823152800700833072414104710501367808"},
    {1e267, chars_format::fixed,
        "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491"
        "6762299630919016582458402314694101834973930913546324812261345931410707403929181156932921964884890754300419"
        "7890512187794469896370420793533163493423472892065087488"},
    {1e268, chars_format::fixed,
        "9999999999999999734382248541602273058775185611228237505937125919871459640244446566940444044768686890151491"
        "6762299630919016582458402314694101834973930913546324812261345931410707403929181156932921964884890754300419"
        "78905121877944698963704207935331634934234728920650874880"},
    {1e269, chars_format::fixed,
        "1000000000000000046753818885456127989189605431330410286841364872744016439394555894610368258180303336939076"
        "8881340449502893261681846624303314743132774169798163873892798646379355869975202383523110226600782937286713"
        "8519293326106230343475263802678137754874196788463928344576"},
    {1e270, chars_format::fixed,
        "1000000000000000046753818885456127989189605431330410286841364872744016439394555894610368258180303336939076"
        "8881340449502893261681846624303314743132774169798163873892798646379355869975202383523110226600782937286713"
        "85192933261062303434752638026781377548741967884639283445760"},
    {1e271, chars_format::fixed,
        "9999999999999999529098585253973751145501342374646995204443699533752222309208135100774737254399069875964494"
        "0587990268968240092837584414759169067994863893904436912794686582343509041098785207009431480570467941101738"
        "54458342872794765056233999682236635579342942941443126198272"},
    {1e272, chars_format::fixed,
        "1000000000000000065522610957467878564117499670103552440120763856617775281089304371516947164728382606807602"
        "3845848734024107112161464260868794310399431725879707910415464644008356863148267156087543642309530165922021"
        "8514235305581886882057848563849292034690350260273827761094656"},
    {1e273, chars_format::fixed,
        "9999999999999999454023416965926748845789765419554426591326103598257186942429141193148421628206752796490392"
        "0729957130883384690919113868497250798928233669578260766704022591827505068406526116751697817735479026560506"
        "5466066369376850351293060923539046438669680406904714953752576"},
    {1e274, chars_format::fixed,
        "9999999999999999213782878444176341486712719163258207029349796604673073768736360688744211624391338142173265"
        "7184251089011847404780008120459112337915016951734497099213897822176292355791297027926950096663514500028564"
        "15308090320884466574359759805482716570229159677380024223137792"},
    {1e275, chars_format::fixed,
        "9999999999999999598167740078976993261235993173332158328511887794407654846644809495790947630496001589080667"
        "8857380756006307062602577317320133875536163700284518967198097453618232695975663570046546450378657742479671"
        "982722077174989256760731188933351130765773907040474247261585408"},
    {1e276, chars_format::fixed,
        "1000000000000000052069140800249855752009185079750964144650090664977064943362508663270311404514719386165843"
        "3087289195679301024137674338978658556582691589680457145036017656907888951241814327113357769929500152436233"
        "07738608946937362752018518070418086469181314516804918593340833792"},
    {1e277, chars_format::fixed,
        "1000000000000000002867878510995372324870206006461498378357342992691038565390227215968329195733322464961695"
        "8313128598304010187936385481780447799767184805866054345934040104083320587698215409722049436653961817402491"
        "275192019201707119869992081071729797163687409453914913289541779456"},
    {1e278, chars_format::fixed,
        "9999999999999999635068686795917855831590227478299257653231448548622174630124020581267434287082049279983778"
        "4938001204037775189753543960218791943147793788145321066524580618236658968633362758090027700335311493754978"
        "334367629875739137498376013657689431411868208826074951744485326848"},
    {1e279, chars_format::fixed,
        "1000000000000000057973292274960393763265862568545700036605220385651388108719182436946549269568487016710341"
        "0060188467364335924481829001842443847400552403738185480928254963246837154867046197200314769922564752640282"
        "09364937790149360843820835266007499279518823345374529865067232493568"},
    {1e280, chars_format::fixed,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "290926013924448356521309485648260046220787856768108551057012647002112"},
    {1e281, chars_format::fixed,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "2909260139244483565213094856482600462207878567681085510570126470021120"},
    {1e282, chars_format::fixed,
        "1000000000000000032782245982862098248570705283021493564263333577440942603197374335927934378672411793053817"
        "4975818241508187016346769106956959939911012930425211247788042456200658152732723551495964903285489125103006"
        "29092601392444835652130948564826004622078785676810855105701264700211200"},
    {1e283, chars_format::fixed,
        "9999999999999999553953517735361344274271821018911312812290573026184540102343798495987494338396687059809772"
        "7966329076780975705558651098687533761031476684077544035813096345547962581760843838922021129763927973084950"
        "24959839786965342632596166187964530344229899589832462449290116390191104"},
    {1e284, chars_format::fixed,
        "1000000000000000079214382508457676541256819191699710934083899342334435758975171027725445345572057645297521"
        "6283329441806240683821311505209883878195732087635685354312082149188175289466707052058222577470946921779713"
        "0505057184069381648545374773244373557467226310750742042216461653692645376"},
    {1e285, chars_format::fixed,
        "9999999999999999801591579205204428501931095198528472118000257105616503599825380852240886161861464938442861"
        "4939722145037261932089543889369794765216645522533405937274641374814720644342089175254062058753036222027386"
        "3006901551095990707698442841525909542472844588688081080376132618600579072"},
    {1e286, chars_format::fixed,
        "1000000000000000032988611034086967485427088011504507863684758314173802572778608987891478871858632441286011"
        "7381629402398400588202211517615861824081167237790591132705927077058380451118207922609574937392980048643791"
        "654301923722148311225012721166820834263125344653917287293299907083743789056"},
    {1e287, chars_format::fixed,
        "1000000000000000075252173524940187193614270804825836385192544397063524343015465710025391076396621199239392"
        "2091755152714140104196817220558967702128769386220391563888697428719907160465407126676909922607121189796634"
        "0736882502910990345434353553680702253338428636675464684849307718019341877248"},
    {1e288, chars_format::fixed,
        "1000000000000000007630473539575035660514778335511710750780086664439969510636494954611131549135839186513983"
        "4555553952208956878605448095849998297252605948732710873996264866061464425509888400169173946264495363952086"
        "20267012778077787723395914064607119962069483324573977857832138825282954985472"},
    {1e289, chars_format::fixed,
        "1000000000000000061727833527867156886994372310963011258310052850538813376539671558942539170944464796694310"
        "4584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724"
        "499484625789034803081540112423670420191213257583185130503608895092113260150784"},
    {1e290, chars_format::fixed,
        "1000000000000000061727833527867156886994372310963011258310052850538813376539671558942539170944464796694310"
        "4584514912613103459078543395617173821153536698722855425910210916188218613474303381375362727338596024627724"
        "4994846257890348030815401124236704201912132575831851305036088950921132601507840"},
    {1e291, chars_format::fixed,
        "9999999999999999578609023503462841321535518780965142838525177732290331540055724786262365370719036251480826"
        "1289098686371420245702004200641968152637496587417778862354344999448505725826266174594802676763227561304989"
        "6960078961318150545418464661067991669581788285529005480705688196068853638234112"},
    {1e292, chars_format::fixed,
        "1000000000000000013256598978357416268068656108958646003563203147794249272690425321461597941803936249972737"
        "4638565892090988122974650007025784551738302746731685907395315255274646861058187558214617579496201832662352"
        "585538835573636597522107561710941518560028749376834095178551288964115055725510656"},
    {1e293, chars_format::fixed,
        "9999999999999999246234843735396048506044893395792352520261065484899034827946607729250196942326840502532897"
        "0231162545648343655275306678872441733790178059478330735395060467469727994972900530063978805843953102113868"
        "000379620369084502134308975505229555772913629423636305841602377586326247764393984"},
    {1e294, chars_format::fixed,
        "1000000000000000066436467741248103118547156170586292454485461107376856746627884050583544890346687569804406"
        "1207835674606680377442921610508908778753873711201997607708800780391251297994726061339549398843285746132932"
        "05683935969567348590731356020719265634967118123751637393518591968740451429495341056"},
    {1e295, chars_format::fixed,
        "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362"
        "6970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049"
        "02758521100414464490983962613190835886243290260424727924570510530141380583845003264"},
    {1e296, chars_format::fixed,
        "9999999999999999813486777206230041577815560719820581330098483720446847883279500839884297726782854580737362"
        "6970040225815727702936870449359100155289601680494988872072239402046841988962644563396584878879514845800049"
        "027585211004144644909839626131908358862432902604247279245705105301413805838450032640"},
    {1e297, chars_format::fixed,
        "1000000000000000017652801462756379714374878780719864776839443139119744823869255243069012222883470359078822"
        "0728292194112285349344027126247056154504923279794565007954563392017619494511608074472945276562227436175920"
        "48849967890105831362861792425329827928397252374398383022243308510390698430058459037696"},
    {1e298, chars_format::fixed,
        "9999999999999999595662034753429788238255624467393741467120915117996487670031669885400803025551745174706847"
        "8782311196631452228634829961492223321433823010024592147588202691169230215270582854596864146833859136224555"
        "51313826420028155008403585629126369847605750170289266545852965785882018353801250996224"},
    {1e299, chars_format::fixed,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "4508111903896764088007465274278014249457925878882005684283811566947219638686545940054016"},
    {1e300, chars_format::fixed,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "45081119038967640880074652742780142494579258788820056842838115669472196386865459400540160"},
    {1e301, chars_format::fixed,
        "1000000000000000052504760255204420248704468581108159154915854115511802457988908195786371375080447864043704"
        "4438328838781769425232353604305756447921847867069828483872009265758037378302337947880900593689532349707999"
        "450811190389676408800746527427801424945792587888200568428381156694721963868654594005401600"},
    {1e302, chars_format::fixed,
        "1000000000000000076297030790848949253473468551506568117016017342062113802881257944841421889646917840766397"
        "4757713854876137221038784479993829181561135051983075016764985648898162653636809541460731423515105837345898"
        "6890825155659063617715863205282622390509284183439858617103083735673849899204570498157510656"},
    {1e303, chars_format::fixed,
        "1000000000000000000161765076786456438212668646231659438295495017101117499225738747865260243034213915253779"
        "7735681803374160274458205677791996433915416060260686111507461222849761772566500442005272768073270676904621"
        "12661427500197051226489898260678763391449376088547292320814127957486330655468919122263277568"},
    {1e304, chars_format::fixed,
        "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856"
        "1180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990"
        "76639682550821832659549112269607949805346034918662572406407604380845959862074904348138143744"},
    {1e305, chars_format::fixed,
        "9999999999999999392535525055364621860040287220117324953190771571323204563013233902843309257440507748436856"
        "1180561621725787171937426360305302357988408668827749873014416820110410677102531624409058437198025485515990"
        "766396825508218326595491122696079498053460349186625724064076043808459598620749043481381437440"},
    {1e306, chars_format::fixed,
        "1000000000000000017216064596736454828831087825013238982328892017892380671244575047987920451875459594568606"
        "1388616982910603110492255329485206969388057114406501226285146694284603569926249680283295506892241752843467"
        "30060716088829214255439694630119794546505512415617982143262670862918816362862119154749127262208"},
    {1e307, chars_format::fixed,
        "9999999999999999860310597602564577717002641838126363875249660735883565852672743849064846414228960666786379"
        "2803926546153933531728502521033362759523706153970107306916646893751785690398510731463396416232660711267200"
        "11020169553304018596457812688561947201171488461172921822139066929851282122002676667750021070848"},
    {1e308, chars_format::fixed,
        "1000000000000000010979063629440455417404923096773118463368106829031575854049114915371633289784946888990612"
        "4966972117251561159028374314008832830700919814604603127166450293302718569748969958855904333838446616500117"
        "8426897626212945177628091195786707458122783970171784415105291802893207873272974885715430223118336"},

    // These numbers have odd mantissas (unaffected by shifting)
    // that are barely within the "max shifted mantissa" limit.
    // They're exactly-representable multiples of powers of 10, and can use Ryu with zero-filling.
    {1801439850948197e1, chars_format::fixed, "18014398509481970"},
    {360287970189639e2, chars_format::fixed, "36028797018963900"},
    {72057594037927e3, chars_format::fixed, "72057594037927000"},
    {14411518807585e4, chars_format::fixed, "144115188075850000"},
    {2882303761517e5, chars_format::fixed, "288230376151700000"},
    {576460752303e6, chars_format::fixed, "576460752303000000"},
    {115292150459e7, chars_format::fixed, "1152921504590000000"},
    {23058430091e8, chars_format::fixed, "2305843009100000000"},
    {4611686017e9, chars_format::fixed, "4611686017000000000"},
    {922337203e10, chars_format::fixed, "9223372030000000000"},
    {184467439e11, chars_format::fixed, "18446743900000000000"},
    {36893487e12, chars_format::fixed, "36893487000000000000"},
    {7378697e13, chars_format::fixed, "73786970000000000000"},
    {1475739e14, chars_format::fixed, "147573900000000000000"},
    {295147e15, chars_format::fixed, "295147000000000000000"},
    {59029e16, chars_format::fixed, "590290000000000000000"},
    {11805e17, chars_format::fixed, "1180500000000000000000"},
    {2361e18, chars_format::fixed, "2361000000000000000000"},
    {471e19, chars_format::fixed, "4710000000000000000000"},
    {93e20, chars_format::fixed, "9300000000000000000000"},
    {17e21, chars_format::fixed, "17000000000000000000000"},
    {3e22, chars_format::fixed, "30000000000000000000000"},

    // These numbers have odd mantissas (unaffected by shifting)
    // that are barely above the "max shifted mantissa" limit.
    // This activates the non-Ryu fallback for large integers.
    {1801439850948199e1, chars_format::fixed, "18014398509481992"},
    {360287970189641e2, chars_format::fixed, "36028797018964096"},
    {72057594037929e3, chars_format::fixed, "72057594037928992"},
    {14411518807587e4, chars_format::fixed, "144115188075870016"},
    {2882303761519e5, chars_format::fixed, "288230376151900032"},
    {576460752305e6, chars_format::fixed, "576460752304999936"},
    {115292150461e7, chars_format::fixed, "1152921504609999872"},
    {23058430093e8, chars_format::fixed, "2305843009299999744"},
    {4611686019e9, chars_format::fixed, "4611686019000000512"},
    {922337205e10, chars_format::fixed, "9223372049999998976"},
    {184467441e11, chars_format::fixed, "18446744099999997952"},
    {36893489e12, chars_format::fixed, "36893488999999995904"},
    {7378699e13, chars_format::fixed, "73786990000000008192"},
    {1475741e14, chars_format::fixed, "147574099999999983616"},
    {295149e15, chars_format::fixed, "295148999999999967232"},
    {59031e16, chars_format::fixed, "590310000000000065536"},
    {11807e17, chars_format::fixed, "1180700000000000131072"},
    {2363e18, chars_format::fixed, "2363000000000000262144"},
    {473e19, chars_format::fixed, "4729999999999999475712"},
    {95e20, chars_format::fixed, "9500000000000001048576"},
    {19e21, chars_format::fixed, "19000000000000002097152"},
    {5e22, chars_format::fixed, "49999999999999995805696"},

    // Test the mantissa shifting logic.
    // Also test a large shift, because 32-bit platforms need to simulate _BitScanForward64().
    {302230528e15, chars_format::fixed, "302230528000000000000000"}, // 295147 * 2^10
    {302232576e15, chars_format::fixed, "302232575999999966445568"}, // 295149 * 2^10
    {81123342286848e18, chars_format::fixed, "81123342286848000000000000000000"}, // 2361 * 2^35
    {81192061763584e18, chars_format::fixed, "81192061763584009007199254740992"}, // 2363 * 2^35

    // Inspect all of those numbers in scientific notation.
    // For the within-limit numbers, this verifies that Ryu is actually being used with zero-filling above.
    // For the above-limit numbers, this tests Ryu's trimming.
    {1801439850948197e1, chars_format::scientific, "1.801439850948197e+16"},
    {360287970189639e2, chars_format::scientific, "3.60287970189639e+16"},
    {72057594037927e3, chars_format::scientific, "7.2057594037927e+16"},
    {14411518807585e4, chars_format::scientific, "1.4411518807585e+17"},
    {2882303761517e5, chars_format::scientific, "2.882303761517e+17"},
    {576460752303e6, chars_format::scientific, "5.76460752303e+17"},
    {115292150459e7, chars_format::scientific, "1.15292150459e+18"},
    {23058430091e8, chars_format::scientific, "2.3058430091e+18"},
    {4611686017e9, chars_format::scientific, "4.611686017e+18"},
    {922337203e10, chars_format::scientific, "9.22337203e+18"},
    {184467439e11, chars_format::scientific, "1.84467439e+19"},
    {36893487e12, chars_format::scientific, "3.6893487e+19"},
    {7378697e13, chars_format::scientific, "7.378697e+19"},
    {1475739e14, chars_format::scientific, "1.475739e+20"},
    {295147e15, chars_format::scientific, "2.95147e+20"},
    {59029e16, chars_format::scientific, "5.9029e+20"},
    {11805e17, chars_format::scientific, "1.1805e+21"},
    {2361e18, chars_format::scientific, "2.361e+21"},
    {471e19, chars_format::scientific, "4.71e+21"},
    {93e20, chars_format::scientific, "9.3e+21"},
    {17e21, chars_format::scientific, "1.7e+22"},
    {3e22, chars_format::scientific, "3e+22"},
    {1801439850948199e1, chars_format::scientific, "1.801439850948199e+16"},
    {360287970189641e2, chars_format::scientific, "3.60287970189641e+16"},
    {72057594037929e3, chars_format::scientific, "7.2057594037929e+16"},
    {14411518807587e4, chars_format::scientific, "1.4411518807587e+17"},
    {2882303761519e5, chars_format::scientific, "2.882303761519e+17"},
    {576460752305e6, chars_format::scientific, "5.76460752305e+17"},
    {115292150461e7, chars_format::scientific, "1.15292150461e+18"},
    {23058430093e8, chars_format::scientific, "2.3058430093e+18"},
    {4611686019e9, chars_format::scientific, "4.611686019e+18"},
    {922337205e10, chars_format::scientific, "9.22337205e+18"},
    {184467441e11, chars_format::scientific, "1.84467441e+19"},
    {36893489e12, chars_format::scientific, "3.6893489e+19"},
    {7378699e13, chars_format::scientific, "7.378699e+19"},
    {1475741e14, chars_format::scientific, "1.475741e+20"},
    {295149e15, chars_format::scientific, "2.95149e+20"},
    {59031e16, chars_format::scientific, "5.9031e+20"},
    {11807e17, chars_format::scientific, "1.1807e+21"},
    {2363e18, chars_format::scientific, "2.363e+21"},
    {473e19, chars_format::scientific, "4.73e+21"},
    {95e20, chars_format::scientific, "9.5e+21"},
    {19e21, chars_format::scientific, "1.9e+22"},
    {5e22, chars_format::scientific, "5e+22"},
    {302230528e15, chars_format::scientific, "3.02230528e+23"},
    {302232576e15, chars_format::scientific, "3.02232576e+23"},
    {81123342286848e18, chars_format::scientific, "8.1123342286848e+31"},
    {81192061763584e18, chars_format::scientific, "8.1192061763584e+31"},

    // Test the switching logic of chars_format::general.
    // C11 7.21.6.1 "The fprintf function"/8:
    // "Let P equal [...] 6 if the precision is omitted [...].
    // Then, if a conversion with style E would have an exponent of X:
    // - if P > X >= -4, the conversion is with style f [...].
    // - otherwise, the conversion is with style e [...]."
    {1e-6, chars_format::general, "1e-06"},
    {1e-5, chars_format::general, "1e-05"},
    {1e-4, chars_format::general, "0.0001"},
    {1e-3, chars_format::general, "0.001"},
    {1e-2, chars_format::general, "0.01"},
    {1e-1, chars_format::general, "0.1"},
    {1e0, chars_format::general, "1"},
    {1e1, chars_format::general, "10"},
    {1e2, chars_format::general, "100"},
    {1e3, chars_format::general, "1000"},
    {1e4, chars_format::general, "10000"},
    {1e5, chars_format::general, "100000"},
    {1e6, chars_format::general, "1e+06"},
    {1e7, chars_format::general, "1e+07"},
    {1.234e-6, chars_format::general, "1.234e-06"},
    {1.234e-5, chars_format::general, "1.234e-05"},
    {1.234e-4, chars_format::general, "0.0001234"},
    {1.234e-3, chars_format::general, "0.001234"},
    {1.234e-2, chars_format::general, "0.01234"},
    {1.234e-1, chars_format::general, "0.1234"},
    {1.234e0, chars_format::general, "1.234"},
    {1.234e1, chars_format::general, "12.34"},
    {1.234e2, chars_format::general, "123.4"},
    {1.234e3, chars_format::general, "1234"},
    {1.234e4, chars_format::general, "12340"},
    {1.234e5, chars_format::general, "123400"},
    {1.234e6, chars_format::general, "1.234e+06"},
    {1.234e7, chars_format::general, "1.234e+07"},
    {1.234e8, chars_format::general, "1.234e+08"},
    {1.234e9, chars_format::general, "1.234e+09"},
    {1.234e10, chars_format::general, "1.234e+10"},

    // Test the switching logic of the plain overload.
    // N4762 19.19.2 [charconv.to.chars]/8:
    // "The conversion specifier is f or e, chosen according to the requirement
    // for a shortest representation (see above); a tie is resolved in favor of f."
    {1e-6, chars_format{}, "1e-06"},
    {1e-5, chars_format{}, "1e-05"},
    {1e-4, chars_format{}, "1e-04"},
    {1e-3, chars_format{}, "0.001"},
    {1e-2, chars_format{}, "0.01"},
    {1e-1, chars_format{}, "0.1"},
    {1e0, chars_format{}, "1"},
    {1e1, chars_format{}, "10"},
    {1e2, chars_format{}, "100"},
    {1e3, chars_format{}, "1000"},
    {1e4, chars_format{}, "10000"},
    {1e5, chars_format{}, "1e+05"},
    {1e6, chars_format{}, "1e+06"},
    {1e7, chars_format{}, "1e+07"},
    {1.234e-6, chars_format{}, "1.234e-06"},
    {1.234e-5, chars_format{}, "1.234e-05"},
    {1.234e-4, chars_format{}, "0.0001234"},
    {1.234e-3, chars_format{}, "0.001234"},
    {1.234e-2, chars_format{}, "0.01234"},
    {1.234e-1, chars_format{}, "0.1234"},
    {1.234e0, chars_format{}, "1.234"},
    {1.234e1, chars_format{}, "12.34"},
    {1.234e2, chars_format{}, "123.4"},
    {1.234e3, chars_format{}, "1234"},
    {1.234e4, chars_format{}, "12340"},
    {1.234e5, chars_format{}, "123400"},
    {1.234e6, chars_format{}, "1234000"},
    {1.234e7, chars_format{}, "12340000"},
    {1.234e8, chars_format{}, "123400000"},
    {1.234e9, chars_format{}, "1.234e+09"},
    {1.234e10, chars_format{}, "1.234e+10"},

    // Exact value is 1.9156918820264798304697...e-56, incorrectly rounded by dtoa_milo() (Grisu2).
    {0x1.e0ffed391517ep-186, chars_format::scientific, "1.9156918820264798e-56"},

    // Exact value is 6.6564021122018745286598...e+264, incorrectly rounded by dtoa_milo() (Grisu2).
    {0x1.a6c767640cd71p+879, chars_format::scientific, "6.6564021122018745e+264"},

    // Incorrectly handled by dtoa_milo() (Grisu2), which doesn't achieve shortest round-trip.
    {4.91e-6, chars_format::scientific, "4.91e-06"},
    {5.547e-6, chars_format::scientific, "5.547e-06"},

    // Test hexfloat corner cases.
    {0x1.728p+0, chars_format::hex, "1.728p+0"}, // instead of "2.e5p-1"
    {0x0.0000000000001p-1022, chars_format::hex, "0.0000000000001p-1022"}, // instead of "1p-1074", min subnormal
    {0x0.fffffffffffffp-1022, chars_format::hex, "0.fffffffffffffp-1022"}, // max subnormal
    {0x1p-1022, chars_format::hex, "1p-1022"}, // min normal
    {0x1.fffffffffffffp+1023, chars_format::hex, "1.fffffffffffffp+1023"}, // max normal

    // Test hexfloat exponents.
    {0x1p-1009, chars_format::hex, "1p-1009"},
    {0x1p-999, chars_format::hex, "1p-999"},
    {0x1p-99, chars_format::hex, "1p-99"},
    {0x1p-9, chars_format::hex, "1p-9"},
    {0x1p+0, chars_format::hex, "1p+0"},
    {0x1p+9, chars_format::hex, "1p+9"},
    {0x1p+99, chars_format::hex, "1p+99"},
    {0x1p+999, chars_format::hex, "1p+999"},
    {0x1p+1009, chars_format::hex, "1p+1009"},

    // Test hexfloat hexits.
    {0x1.01234567p+0, chars_format::hex, "1.01234567p+0"},
    {0x1.89abcdefp+0, chars_format::hex, "1.89abcdefp+0"},

    // Test hexfloat trimming.
    {0x1.000000000000ap+0, chars_format::hex, "1.000000000000ap+0"},
    {0x1.00000000000ap+0, chars_format::hex, "1.00000000000ap+0"},
    {0x1.0000000000ap+0, chars_format::hex, "1.0000000000ap+0"},
    {0x1.000000000ap+0, chars_format::hex, "1.000000000ap+0"},
    {0x1.00000000ap+0, chars_format::hex, "1.00000000ap+0"},
    {0x1.0000000ap+0, chars_format::hex, "1.0000000ap+0"},
    {0x1.000000ap+0, chars_format::hex, "1.000000ap+0"},
    {0x1.00000ap+0, chars_format::hex, "1.00000ap+0"},
    {0x1.0000ap+0, chars_format::hex, "1.0000ap+0"},
    {0x1.000ap+0, chars_format::hex, "1.000ap+0"},
    {0x1.00ap+0, chars_format::hex, "1.00ap+0"},
    {0x1.0ap+0, chars_format::hex, "1.0ap+0"},
    {0x1.ap+0, chars_format::hex, "1.ap+0"},
    {0x1p+0, chars_format::hex, "1p+0"},

    // https://www.exploringbinary.com/the-shortest-decimal-string-that-round-trips-may-not-be-the-nearest/
    // This is an exhaustive list of anomalous values.

    // Because math, these values have shortest-round-trip decimal representations containing 16 significant digits,
    // but those decimal digits aren't what would be printed by "%.15e". For ordinary values, shortest-round-trip
    // behaves as if it can magically pick a precision for "%.*e", finding the smallest precision that round-trips.
    // (That is, start with the exact decimal representation, and then round it as much as possible.) These anomalous
    // values demonstrate an exception to that mental model. They aren't being "incorrectly rounded"; instead, having
    // the shortest output that round-trips is being prioritized. (This differs by 1 in the least significant decimal
    // digit printed, so it's a very small difference.)

    // N4835 20.19.2 [charconv.to.chars]/2 demands this behavior:
    // "The functions that take a floating-point value but not a precision parameter ensure that the string
    // representation consists of the smallest number of characters such that there is at least one digit before the
    // radix point (if present) and parsing the representation using the corresponding from_chars function recovers
    // value exactly. [...] If there are several such representations, the representation with the smallest difference
    // from the floating-point argument value is chosen, resolving any remaining ties using rounding according to
    // round_to_nearest (17.3.4.1)."
    {0x1p976, chars_format::scientific, "6.386688990511104e+293"},
    {0x1p896, chars_format::scientific, "5.282945311356653e+269"},
    {0x1p863, chars_format::scientific, "6.150157786156811e+259"},
    {0x1p803, chars_format::scientific, "5.334411546303884e+241"},
    {0x1p710, chars_format::scientific, "5.386379163185535e+213"},
    {0x1p594, chars_format::scientific, "6.483618076376552e+178"},
    {0x1p574, chars_format::scientific, "6.183260036827614e+172"},
    {0x1p554, chars_format::scientific, "5.896816288783659e+166"},
    {0x1p544, chars_format::scientific, "5.758609657015292e+163"},
    {0x1p534, chars_format::scientific, "5.623642243178996e+160"},
    {0x1p481, chars_format::scientific, "6.243497100631985e+144"},
    {0x1p405, chars_format::scientific, "8.263199609878108e+121"},
    {0x1p398, chars_format::scientific, "6.455624695217272e+119"},
    {0x1p378, chars_format::scientific, "6.156563468186638e+113"},
    {0x1p345, chars_format::scientific, "7.167183174968974e+103"},
    {0x1p305, chars_format::scientific, "6.518515124270356e+91"},
    {0x1p275, chars_format::scientific, "6.070840288205404e+82"},
    {0x1p182, chars_format::scientific, "6.129982163463556e+54"},
    {0x1p172, chars_format::scientific, "5.986310706507379e+51"},
    {0x1p132, chars_format::scientific, "5.444517870735016e+39"},
    {0x1p122, chars_format::scientific, "5.316911983139664e+36"},
    {0x1p89, chars_format::scientific, "6.189700196426902e+26"},
    {0x1p-24, chars_format::scientific, "5.960464477539063e-08"},
    {0x1p-44, chars_format::scientific, "5.684341886080802e-14"},
    {0x1p-77, chars_format::scientific, "6.617444900424222e-24"},
    {0x1p-97, chars_format::scientific, "6.310887241768095e-30"},
    {0x1p-140, chars_format::scientific, "7.174648137343064e-43"},
    {0x1p-296, chars_format::scientific, "7.854549544476363e-90"},
    {0x1p-366, chars_format::scientific, "6.653062250012736e-111"},
    {0x1p-383, chars_format::scientific, "5.075883674631299e-116"},
    {0x1p-489, chars_format::scientific, "6.256509672447191e-148"},
    {0x1p-496, chars_format::scientific, "4.887898181599368e-150"},
    {0x1p-509, chars_format::scientific, "5.966672584960166e-154"},
    {0x1p-549, chars_format::scientific, "5.426657103235053e-166"},
    {0x1p-652, chars_format::scientific, "5.351097043477547e-197"},
    {0x1p-662, chars_format::scientific, "5.225680706521042e-200"},
    {0x1p-695, chars_format::scientific, "6.083493012144512e-210"},
    {0x1p-705, chars_format::scientific, "5.940911144672375e-213"},
    {0x1p-778, chars_format::scientific, "6.290184345309701e-235"},
    {0x1p-788, chars_format::scientific, "6.142758149716505e-238"},
    {0x1p-791, chars_format::scientific, "7.678447687145631e-239"},
    {0x1p-808, chars_format::scientific, "5.858190679279809e-244"},
    {0x1p-921, chars_format::scientific, "5.641232424577593e-278"},
    {0x1p-957, chars_format::scientific, "8.209073602596753e-289"},
    {0x1p-1007, chars_format::scientific, "7.291122019556398e-304"},
    {0x1p-1017, chars_format::scientific, "7.120236347223045e-307"},

    // This is an exhaustive list of almost-but-not-quite-anomalous values.
    {0x1p966, chars_format::scientific, "6.237000967296e+290"},
    {0x1p956, chars_format::scientific, "6.090821257125e+287"},
    {0x1p890, chars_format::scientific, "8.25460204899477e+267"},
    {0x1p740, chars_format::scientific, "5.78358058743443e+222"},
    {0x1p149, chars_format::scientific, "7.1362384635298e+44"},
    {0x1p-499, chars_format::scientific, "6.10987272699921e-151"},
    {0x1p-569, chars_format::scientific, "5.17526350329881e-172"},
    {0x1p-645, chars_format::scientific, "6.84940421565126e-195"},
};

#endif // DOUBLE_TO_CHARS_TEST_CASES_HPP
