// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/ad_group_criterion_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AdGroupCriterionService.GetAdGroupCriterion][google.ads.googleads.v3.services.AdGroupCriterionService.GetAdGroupCriterion].
type GetAdGroupCriterionRequest struct {
	// Required. The resource name of the criterion to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdGroupCriterionRequest) Reset()         { *m = GetAdGroupCriterionRequest{} }
func (m *GetAdGroupCriterionRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdGroupCriterionRequest) ProtoMessage()    {}
func (*GetAdGroupCriterionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_112a602b3a19937a, []int{0}
}

func (m *GetAdGroupCriterionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdGroupCriterionRequest.Unmarshal(m, b)
}
func (m *GetAdGroupCriterionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdGroupCriterionRequest.Marshal(b, m, deterministic)
}
func (m *GetAdGroupCriterionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdGroupCriterionRequest.Merge(m, src)
}
func (m *GetAdGroupCriterionRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdGroupCriterionRequest.Size(m)
}
func (m *GetAdGroupCriterionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdGroupCriterionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdGroupCriterionRequest proto.InternalMessageInfo

func (m *GetAdGroupCriterionRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdGroupCriterionService.MutateAdGroupCriteria][google.ads.googleads.v3.services.AdGroupCriterionService.MutateAdGroupCriteria].
type MutateAdGroupCriteriaRequest struct {
	// Required. ID of the customer whose criteria are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual criteria.
	Operations []*AdGroupCriterionOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupCriteriaRequest) Reset()         { *m = MutateAdGroupCriteriaRequest{} }
func (m *MutateAdGroupCriteriaRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupCriteriaRequest) ProtoMessage()    {}
func (*MutateAdGroupCriteriaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_112a602b3a19937a, []int{1}
}

func (m *MutateAdGroupCriteriaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupCriteriaRequest.Unmarshal(m, b)
}
func (m *MutateAdGroupCriteriaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupCriteriaRequest.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupCriteriaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupCriteriaRequest.Merge(m, src)
}
func (m *MutateAdGroupCriteriaRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupCriteriaRequest.Size(m)
}
func (m *MutateAdGroupCriteriaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupCriteriaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupCriteriaRequest proto.InternalMessageInfo

func (m *MutateAdGroupCriteriaRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdGroupCriteriaRequest) GetOperations() []*AdGroupCriterionOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateAdGroupCriteriaRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateAdGroupCriteriaRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, remove, update) on an ad group criterion.
type AdGroupCriterionOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The list of policy violation keys that should not cause a
	// PolicyViolationError to be reported. Not all policy violations are
	// exemptable, please refer to the is_exemptible field in the returned
	// PolicyViolationError.
	//
	// Resources violating these polices will be saved, but will not be eligible
	// to serve. They may begin serving at a later time due to a change in
	// policies, re-review of the resource, or a change in advertiser
	// certificates.
	ExemptPolicyViolationKeys []*common.PolicyViolationKey `protobuf:"bytes,5,rep,name=exempt_policy_violation_keys,json=exemptPolicyViolationKeys,proto3" json:"exempt_policy_violation_keys,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdGroupCriterionOperation_Create
	//	*AdGroupCriterionOperation_Update
	//	*AdGroupCriterionOperation_Remove
	Operation            isAdGroupCriterionOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *AdGroupCriterionOperation) Reset()         { *m = AdGroupCriterionOperation{} }
func (m *AdGroupCriterionOperation) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterionOperation) ProtoMessage()    {}
func (*AdGroupCriterionOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_112a602b3a19937a, []int{2}
}

func (m *AdGroupCriterionOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterionOperation.Unmarshal(m, b)
}
func (m *AdGroupCriterionOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterionOperation.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterionOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterionOperation.Merge(m, src)
}
func (m *AdGroupCriterionOperation) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterionOperation.Size(m)
}
func (m *AdGroupCriterionOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterionOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterionOperation proto.InternalMessageInfo

func (m *AdGroupCriterionOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *AdGroupCriterionOperation) GetExemptPolicyViolationKeys() []*common.PolicyViolationKey {
	if m != nil {
		return m.ExemptPolicyViolationKeys
	}
	return nil
}

type isAdGroupCriterionOperation_Operation interface {
	isAdGroupCriterionOperation_Operation()
}

type AdGroupCriterionOperation_Create struct {
	Create *resources.AdGroupCriterion `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdGroupCriterionOperation_Update struct {
	Update *resources.AdGroupCriterion `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type AdGroupCriterionOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*AdGroupCriterionOperation_Create) isAdGroupCriterionOperation_Operation() {}

func (*AdGroupCriterionOperation_Update) isAdGroupCriterionOperation_Operation() {}

func (*AdGroupCriterionOperation_Remove) isAdGroupCriterionOperation_Operation() {}

func (m *AdGroupCriterionOperation) GetOperation() isAdGroupCriterionOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdGroupCriterionOperation) GetCreate() *resources.AdGroupCriterion {
	if x, ok := m.GetOperation().(*AdGroupCriterionOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdGroupCriterionOperation) GetUpdate() *resources.AdGroupCriterion {
	if x, ok := m.GetOperation().(*AdGroupCriterionOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *AdGroupCriterionOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdGroupCriterionOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupCriterionOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupCriterionOperation_Create)(nil),
		(*AdGroupCriterionOperation_Update)(nil),
		(*AdGroupCriterionOperation_Remove)(nil),
	}
}

// Response message for an ad group criterion mutate.
type MutateAdGroupCriteriaResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateAdGroupCriterionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *MutateAdGroupCriteriaResponse) Reset()         { *m = MutateAdGroupCriteriaResponse{} }
func (m *MutateAdGroupCriteriaResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupCriteriaResponse) ProtoMessage()    {}
func (*MutateAdGroupCriteriaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_112a602b3a19937a, []int{3}
}

func (m *MutateAdGroupCriteriaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupCriteriaResponse.Unmarshal(m, b)
}
func (m *MutateAdGroupCriteriaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupCriteriaResponse.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupCriteriaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupCriteriaResponse.Merge(m, src)
}
func (m *MutateAdGroupCriteriaResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupCriteriaResponse.Size(m)
}
func (m *MutateAdGroupCriteriaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupCriteriaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupCriteriaResponse proto.InternalMessageInfo

func (m *MutateAdGroupCriteriaResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateAdGroupCriteriaResponse) GetResults() []*MutateAdGroupCriterionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the criterion mutate.
type MutateAdGroupCriterionResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdGroupCriterionResult) Reset()         { *m = MutateAdGroupCriterionResult{} }
func (m *MutateAdGroupCriterionResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdGroupCriterionResult) ProtoMessage()    {}
func (*MutateAdGroupCriterionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_112a602b3a19937a, []int{4}
}

func (m *MutateAdGroupCriterionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdGroupCriterionResult.Unmarshal(m, b)
}
func (m *MutateAdGroupCriterionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdGroupCriterionResult.Marshal(b, m, deterministic)
}
func (m *MutateAdGroupCriterionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdGroupCriterionResult.Merge(m, src)
}
func (m *MutateAdGroupCriterionResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdGroupCriterionResult.Size(m)
}
func (m *MutateAdGroupCriterionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdGroupCriterionResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdGroupCriterionResult proto.InternalMessageInfo

func (m *MutateAdGroupCriterionResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdGroupCriterionRequest)(nil), "google.ads.googleads.v3.services.GetAdGroupCriterionRequest")
	proto.RegisterType((*MutateAdGroupCriteriaRequest)(nil), "google.ads.googleads.v3.services.MutateAdGroupCriteriaRequest")
	proto.RegisterType((*AdGroupCriterionOperation)(nil), "google.ads.googleads.v3.services.AdGroupCriterionOperation")
	proto.RegisterType((*MutateAdGroupCriteriaResponse)(nil), "google.ads.googleads.v3.services.MutateAdGroupCriteriaResponse")
	proto.RegisterType((*MutateAdGroupCriterionResult)(nil), "google.ads.googleads.v3.services.MutateAdGroupCriterionResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/ad_group_criterion_service.proto", fileDescriptor_112a602b3a19937a)
}

var fileDescriptor_112a602b3a19937a = []byte{
	// 851 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xc7, 0xce, 0x52, 0xe8, 0x64, 0x17, 0xa4, 0x59, 0x2d, 0xeb, 0x86, 0x20, 0x22, 0x53, 0x89,
	0x92, 0x45, 0xb6, 0x36, 0xe6, 0x82, 0xcb, 0x82, 0x9c, 0x15, 0xcd, 0xae, 0x50, 0xd9, 0xca, 0x2b,
	0x45, 0x2b, 0x14, 0xc9, 0x4c, 0xed, 0x69, 0xb0, 0x6a, 0x7b, 0xcc, 0xcc, 0x38, 0x22, 0xaa, 0x7a,
	0x00, 0xbe, 0x01, 0x7c, 0x03, 0x8e, 0x7c, 0x0b, 0xae, 0xbd, 0xf6, 0xd6, 0x53, 0x0f, 0x9c, 0x38,
	0x22, 0x4e, 0x9c, 0x90, 0x3d, 0x33, 0xf9, 0xd7, 0x58, 0x91, 0xca, 0xed, 0x79, 0xde, 0xef, 0xfd,
	0xde, 0xff, 0x67, 0xe0, 0x8d, 0x09, 0x19, 0x27, 0xd8, 0x46, 0x11, 0xb3, 0x85, 0x58, 0x4a, 0x13,
	0xc7, 0x66, 0x98, 0x4e, 0xe2, 0x10, 0x33, 0x1b, 0x45, 0xc1, 0x98, 0x92, 0x22, 0x0f, 0x42, 0x1a,
	0x73, 0x4c, 0x63, 0x92, 0x05, 0x52, 0x67, 0xe5, 0x94, 0x70, 0x02, 0x3b, 0xc2, 0xce, 0x42, 0x11,
	0xb3, 0x66, 0x14, 0xd6, 0xc4, 0xb1, 0x14, 0x45, 0xeb, 0x51, 0x9d, 0x93, 0x90, 0xa4, 0x29, 0xc9,
	0xec, 0x9c, 0x24, 0x71, 0x38, 0x15, 0x74, 0x2d, 0xb7, 0x0e, 0x4c, 0x31, 0x23, 0x05, 0x5d, 0x1f,
	0x92, 0xb4, 0x6d, 0x2b, 0xdb, 0x3c, 0xb6, 0x51, 0x96, 0x11, 0x8e, 0x78, 0x4c, 0x32, 0x26, 0xb5,
	0x0f, 0x17, 0xb4, 0x61, 0x12, 0xe3, 0x8c, 0x4b, 0xc5, 0xfb, 0x0b, 0x8a, 0x93, 0x18, 0x27, 0x51,
	0x70, 0x8c, 0xbf, 0x43, 0x93, 0x98, 0x50, 0x09, 0xd8, 0x59, 0x00, 0xa8, 0x30, 0xa4, 0x4a, 0x66,
	0x6f, 0x57, 0x5f, 0xc7, 0xc5, 0x89, 0x24, 0x48, 0x11, 0x3b, 0x5d, 0x71, 0x4b, 0xf3, 0xd0, 0x66,
	0x1c, 0xf1, 0x42, 0xc6, 0x63, 0x72, 0xd0, 0x1a, 0x60, 0xee, 0x45, 0x83, 0x32, 0x97, 0xa7, 0x2a,
	0x15, 0x1f, 0x7f, 0x5f, 0x60, 0xc6, 0xe1, 0x10, 0xdc, 0x53, 0xae, 0x82, 0x0c, 0xa5, 0xd8, 0xd0,
	0x3a, 0xda, 0xde, 0x76, 0xff, 0xf1, 0xb5, 0xa7, 0xff, 0xeb, 0x3d, 0x02, 0x1f, 0xcd, 0x4b, 0x2d,
	0xa5, 0x3c, 0x66, 0x56, 0x48, 0x52, 0xfb, 0x06, 0xe1, 0x5d, 0xc5, 0xf3, 0x35, 0x4a, 0xb1, 0xf9,
	0x8f, 0x06, 0xda, 0x87, 0x05, 0x47, 0x1c, 0x2f, 0x03, 0x91, 0x72, 0xbc, 0x0b, 0x9a, 0x61, 0xc1,
	0x38, 0x49, 0x31, 0x0d, 0xe2, 0x48, 0xba, 0x6d, 0x5c, 0x7b, 0xba, 0x0f, 0xd4, 0xfb, 0xf3, 0x08,
	0x7e, 0x0b, 0x00, 0xc9, 0x31, 0x15, 0x05, 0x36, 0xf4, 0x4e, 0x63, 0xaf, 0xd9, 0xdb, 0xb7, 0x36,
	0x8d, 0x82, 0xb5, 0x1a, 0xdc, 0x0b, 0xc5, 0x21, 0x3d, 0xcc, 0x39, 0xe1, 0x87, 0xe0, 0xed, 0x1c,
	0x51, 0x1e, 0xa3, 0x24, 0x38, 0x41, 0x71, 0x52, 0x50, 0x6c, 0x34, 0x3a, 0xda, 0xde, 0x9b, 0xfe,
	0x5b, 0xf2, 0xf9, 0x40, 0xbc, 0xc2, 0x0f, 0xc0, 0xbd, 0x09, 0x4a, 0xe2, 0x08, 0x71, 0x1c, 0x90,
	0x2c, 0x99, 0x1a, 0x77, 0x2a, 0xd8, 0x5d, 0xf5, 0xf8, 0x22, 0x4b, 0xa6, 0xe6, 0x2f, 0x0d, 0xb0,
	0x53, 0xeb, 0x1c, 0xee, 0x83, 0x66, 0x91, 0x57, 0x04, 0x65, 0xe3, 0x2a, 0x82, 0x66, 0xaf, 0xa5,
	0xd2, 0x51, 0xbd, 0xb5, 0x0e, 0xca, 0xde, 0x1e, 0x22, 0x76, 0xea, 0x03, 0x01, 0x2f, 0x65, 0xc8,
	0x40, 0x1b, 0xff, 0x80, 0xd3, 0x9c, 0x07, 0x62, 0x90, 0x83, 0x49, 0x4c, 0x92, 0x8a, 0x37, 0x38,
	0xc5, 0x53, 0x66, 0xbc, 0x5e, 0x15, 0xa7, 0x57, 0x5b, 0x1c, 0xb1, 0x05, 0xd6, 0x51, 0x65, 0x3c,
	0x54, 0xb6, 0x5f, 0xe1, 0xa9, 0xbf, 0x23, 0x78, 0x6f, 0x6a, 0x18, 0x3c, 0x04, 0x5b, 0x21, 0xc5,
	0x88, 0x8b, 0xb9, 0x68, 0xf6, 0x9c, 0x5a, 0xfa, 0xd9, 0xde, 0xdc, 0x28, 0xfe, 0xb3, 0xd7, 0x7c,
	0x49, 0x52, 0xd2, 0x89, 0x8c, 0x0c, 0xfd, 0x7f, 0xd1, 0x09, 0x12, 0x68, 0x80, 0x2d, 0x8a, 0x53,
	0x32, 0x11, 0x2d, 0xdb, 0x2e, 0x35, 0xe2, 0xbb, 0xdf, 0x04, 0xdb, 0xb3, 0x1e, 0x9b, 0x7f, 0x68,
	0xe0, 0xbd, 0x9a, 0x59, 0x64, 0x39, 0xc9, 0x18, 0x86, 0x07, 0xe0, 0xc1, 0xca, 0x10, 0x04, 0x98,
	0x52, 0x42, 0x2b, 0xde, 0x66, 0x0f, 0xaa, 0x30, 0x69, 0x1e, 0x5a, 0x2f, 0xab, 0xe5, 0xf2, 0xef,
	0x2f, 0x8f, 0xc7, 0x97, 0x25, 0x1c, 0xbe, 0x02, 0x6f, 0x50, 0xcc, 0x8a, 0x84, 0xab, 0x59, 0xfd,
	0x7c, 0xf3, 0xac, 0xae, 0x8b, 0xac, 0xdc, 0xcf, 0x92, 0xc6, 0x57, 0x74, 0xe6, 0xd3, 0xf5, 0xeb,
	0xa4, 0x80, 0xe5, 0x74, 0xae, 0xd9, 0xe3, 0xe5, 0xa5, 0xec, 0xfd, 0x78, 0x07, 0x3c, 0x5c, 0xb5,
	0x7f, 0x29, 0xe2, 0x80, 0x97, 0x1a, 0xb8, 0xbf, 0xe6, 0x4e, 0xc0, 0xcf, 0x36, 0x67, 0x50, 0x7f,
	0x5e, 0x5a, 0xb7, 0x69, 0xb0, 0xf9, 0xfc, 0xca, 0x5b, 0x4e, 0xe6, 0xa7, 0xcb, 0x3f, 0x7f, 0xd5,
	0x1d, 0xf8, 0xb8, 0xbc, 0xcf, 0x67, 0x4b, 0x9a, 0x27, 0xea, 0x56, 0x30, 0xbb, 0x6b, 0xa3, 0xe5,
	0xee, 0xda, 0xdd, 0x73, 0xf8, 0xb7, 0x06, 0x1e, 0xac, 0x6d, 0x3d, 0xbc, 0x65, 0x67, 0xd4, 0xfd,
	0x6a, 0x7d, 0x71, 0x6b, 0x7b, 0x31, 0x73, 0xe6, 0xab, 0x2b, 0xef, 0x9d, 0x85, 0x0b, 0xf8, 0xf1,
	0xfc, 0x26, 0x55, 0xe9, 0x7e, 0x6a, 0x7e, 0x52, 0xfd, 0xbb, 0x66, 0xf9, 0x9d, 0x2d, 0x80, 0x9f,
	0x74, 0xcf, 0x57, 0xb3, 0x75, 0xd3, 0xca, 0x9b, 0xab, 0x75, 0x5b, 0xef, 0x5e, 0x78, 0x46, 0xdd,
	0xdd, 0xee, 0xff, 0xac, 0x83, 0xdd, 0x90, 0xa4, 0x1b, 0xa3, 0xef, 0xb7, 0x6b, 0x26, 0xe5, 0xa8,
	0x3c, 0x53, 0x47, 0xda, 0x37, 0xcf, 0x24, 0xc3, 0x98, 0x24, 0x28, 0x1b, 0x5b, 0x84, 0x8e, 0xed,
	0x31, 0xce, 0xaa, 0x23, 0x66, 0xcf, 0x7d, 0xd6, 0xff, 0xf2, 0xf7, 0x95, 0xf0, 0x9b, 0xde, 0x18,
	0x78, 0xde, 0xef, 0x7a, 0x67, 0x20, 0x08, 0xbd, 0x88, 0x59, 0x42, 0x2c, 0xa5, 0xa1, 0x63, 0x49,
	0xc7, 0xec, 0x42, 0x41, 0x46, 0x5e, 0xc4, 0x46, 0x33, 0xc8, 0x68, 0xe8, 0x8c, 0x14, 0xe4, 0x2f,
	0x7d, 0x57, 0xbc, 0xbb, 0xae, 0x17, 0x31, 0xd7, 0x9d, 0x81, 0x5c, 0x77, 0xe8, 0xb8, 0xae, 0x82,
	0x1d, 0x6f, 0x55, 0x71, 0x3a, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xc2, 0xb4, 0x95, 0x37, 0x99,
	0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AdGroupCriterionServiceClient is the client API for AdGroupCriterionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdGroupCriterionServiceClient interface {
	// Returns the requested criterion in full detail.
	GetAdGroupCriterion(ctx context.Context, in *GetAdGroupCriterionRequest, opts ...grpc.CallOption) (*resources.AdGroupCriterion, error)
	// Creates, updates, or removes criteria. Operation statuses are returned.
	MutateAdGroupCriteria(ctx context.Context, in *MutateAdGroupCriteriaRequest, opts ...grpc.CallOption) (*MutateAdGroupCriteriaResponse, error)
}

type adGroupCriterionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAdGroupCriterionServiceClient(cc grpc.ClientConnInterface) AdGroupCriterionServiceClient {
	return &adGroupCriterionServiceClient{cc}
}

func (c *adGroupCriterionServiceClient) GetAdGroupCriterion(ctx context.Context, in *GetAdGroupCriterionRequest, opts ...grpc.CallOption) (*resources.AdGroupCriterion, error) {
	out := new(resources.AdGroupCriterion)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.AdGroupCriterionService/GetAdGroupCriterion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adGroupCriterionServiceClient) MutateAdGroupCriteria(ctx context.Context, in *MutateAdGroupCriteriaRequest, opts ...grpc.CallOption) (*MutateAdGroupCriteriaResponse, error) {
	out := new(MutateAdGroupCriteriaResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.AdGroupCriterionService/MutateAdGroupCriteria", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdGroupCriterionServiceServer is the server API for AdGroupCriterionService service.
type AdGroupCriterionServiceServer interface {
	// Returns the requested criterion in full detail.
	GetAdGroupCriterion(context.Context, *GetAdGroupCriterionRequest) (*resources.AdGroupCriterion, error)
	// Creates, updates, or removes criteria. Operation statuses are returned.
	MutateAdGroupCriteria(context.Context, *MutateAdGroupCriteriaRequest) (*MutateAdGroupCriteriaResponse, error)
}

// UnimplementedAdGroupCriterionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAdGroupCriterionServiceServer struct {
}

func (*UnimplementedAdGroupCriterionServiceServer) GetAdGroupCriterion(ctx context.Context, req *GetAdGroupCriterionRequest) (*resources.AdGroupCriterion, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAdGroupCriterion not implemented")
}
func (*UnimplementedAdGroupCriterionServiceServer) MutateAdGroupCriteria(ctx context.Context, req *MutateAdGroupCriteriaRequest) (*MutateAdGroupCriteriaResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateAdGroupCriteria not implemented")
}

func RegisterAdGroupCriterionServiceServer(s *grpc.Server, srv AdGroupCriterionServiceServer) {
	s.RegisterService(&_AdGroupCriterionService_serviceDesc, srv)
}

func _AdGroupCriterionService_GetAdGroupCriterion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdGroupCriterionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupCriterionServiceServer).GetAdGroupCriterion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.AdGroupCriterionService/GetAdGroupCriterion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupCriterionServiceServer).GetAdGroupCriterion(ctx, req.(*GetAdGroupCriterionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdGroupCriterionService_MutateAdGroupCriteria_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdGroupCriteriaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdGroupCriterionServiceServer).MutateAdGroupCriteria(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.AdGroupCriterionService/MutateAdGroupCriteria",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdGroupCriterionServiceServer).MutateAdGroupCriteria(ctx, req.(*MutateAdGroupCriteriaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdGroupCriterionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.AdGroupCriterionService",
	HandlerType: (*AdGroupCriterionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdGroupCriterion",
			Handler:    _AdGroupCriterionService_GetAdGroupCriterion_Handler,
		},
		{
			MethodName: "MutateAdGroupCriteria",
			Handler:    _AdGroupCriterionService_MutateAdGroupCriteria_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/ad_group_criterion_service.proto",
}
