// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/actions/sdk/v2/interactionmodel/prompt/content/static_canvas_prompt.proto

package prompt

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a Interactive Canvas response to be sent to the user.
// This can be used in conjunction with the `first_simple` field in the
// containing prompt to speak to the user in addition to displaying a
// interactive canvas response.
type StaticCanvasPrompt struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. URL of the web view to load.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Optional. JSON data to be passed through to the immersive experience web page as an
	// event. If the `override` field in the containing prompt is `false` data
	// values defined in this Canvas prompt will be added after data values
	// defined in previous Canvas prompts.
	Data []*structpb.Value `protobuf:"bytes,2,rep,name=data,proto3" json:"data,omitempty"`
	// Optional. A true value means that the mic won't be opened for capturing input after
	// this immersive response is presented to the user.
	SuppressMic bool `protobuf:"varint,3,opt,name=suppress_mic,json=suppressMic,proto3" json:"suppress_mic,omitempty"`
	// Optional. If `true`, conversation related metadata is included and send back to the
	// canvas application.
	SendStateDataToCanvasApp bool `protobuf:"varint,5,opt,name=send_state_data_to_canvas_app,json=sendStateDataToCanvasApp,proto3" json:"send_state_data_to_canvas_app,omitempty"`
	// Optional. If `true` the canvas application occupies the full screen and won't
	// have a header at the top. A toast message will also be displayed on the
	// loading screen that includes the Action's display name, the developer's
	// name, and instructions for exiting the Action. Default value: `false`.
	EnableFullScreen bool `protobuf:"varint,6,opt,name=enable_full_screen,json=enableFullScreen,proto3" json:"enable_full_screen,omitempty"`
}

func (x *StaticCanvasPrompt) Reset() {
	*x = StaticCanvasPrompt{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticCanvasPrompt) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticCanvasPrompt) ProtoMessage() {}

func (x *StaticCanvasPrompt) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticCanvasPrompt.ProtoReflect.Descriptor instead.
func (*StaticCanvasPrompt) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescGZIP(), []int{0}
}

func (x *StaticCanvasPrompt) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *StaticCanvasPrompt) GetData() []*structpb.Value {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *StaticCanvasPrompt) GetSuppressMic() bool {
	if x != nil {
		return x.SuppressMic
	}
	return false
}

func (x *StaticCanvasPrompt) GetSendStateDataToCanvasApp() bool {
	if x != nil {
		return x.SendStateDataToCanvasApp
	}
	return false
}

func (x *StaticCanvasPrompt) GetEnableFullScreen() bool {
	if x != nil {
		return x.EnableFullScreen
	}
	return false
}

var File_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDesc = []byte{
	0x0a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x63,
	0x61, 0x6e, 0x76, 0x61, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xfd, 0x01, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x43, 0x61, 0x6e, 0x76, 0x61,
	0x73, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x2f,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x26, 0x0a, 0x0c, 0x73, 0x75, 0x70, 0x70, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x69, 0x63, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x75, 0x70, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x4d, 0x69, 0x63, 0x12, 0x44, 0x0a, 0x1d, 0x73, 0x65, 0x6e, 0x64, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x6f, 0x5f, 0x63, 0x61,
	0x6e, 0x76, 0x61, 0x73, 0x5f, 0x61, 0x70, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x65, 0x6e, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x54, 0x6f, 0x43, 0x61, 0x6e, 0x76, 0x61, 0x73, 0x41, 0x70, 0x70, 0x12, 0x31, 0x0a,
	0x12, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x73, 0x63, 0x72,
	0x65, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x75, 0x6c, 0x6c, 0x53, 0x63, 0x72, 0x65, 0x65, 0x6e,
	0x42, 0xa3, 0x01, 0x0a, 0x31, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x42, 0x17, 0x53, 0x74, 0x61, 0x74, 0x69, 0x63, 0x43, 0x61,
	0x6e, 0x76, 0x61, 0x73, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x53, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x3b,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescData = file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDesc
)

func file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDescData
}

var file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_goTypes = []interface{}{
	(*StaticCanvasPrompt)(nil), // 0: google.actions.sdk.v2.interactionmodel.prompt.StaticCanvasPrompt
	(*structpb.Value)(nil),     // 1: google.protobuf.Value
}
var file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_depIdxs = []int32{
	1, // 0: google.actions.sdk.v2.interactionmodel.prompt.StaticCanvasPrompt.data:type_name -> google.protobuf.Value
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() {
	file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_init()
}
func file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_init() {
	if File_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StaticCanvasPrompt); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto = out.File
	file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_rawDesc = nil
	file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_goTypes = nil
	file_google_actions_sdk_v2_interactionmodel_prompt_content_static_canvas_prompt_proto_depIdxs = nil
}
