// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/devtools/testing/v1/application_details.proto

package testing

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Android application details based on application manifest and apk archive
// contents.
type ApkDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	ApkManifest *ApkManifest `protobuf:"bytes,1,opt,name=apk_manifest,json=apkManifest,proto3" json:"apk_manifest,omitempty"`
}

func (x *ApkDetail) Reset() {
	*x = ApkDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApkDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApkDetail) ProtoMessage() {}

func (x *ApkDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApkDetail.ProtoReflect.Descriptor instead.
func (*ApkDetail) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_application_details_proto_rawDescGZIP(), []int{0}
}

func (x *ApkDetail) GetApkManifest() *ApkManifest {
	if x != nil {
		return x.ApkManifest
	}
	return nil
}

// An Android app manifest. See
// http://developer.android.com/guide/topics/manifest/manifest-intro.html
type ApkManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full Java-style package name for this application, e.g.
	// "com.example.foo".
	PackageName string `protobuf:"bytes,1,opt,name=package_name,json=packageName,proto3" json:"package_name,omitempty"`
	// Minimum API level required for the application to run.
	MinSdkVersion int32 `protobuf:"varint,2,opt,name=min_sdk_version,json=minSdkVersion,proto3" json:"min_sdk_version,omitempty"`
	// Maximum API level on which the application is designed to run.
	MaxSdkVersion int32 `protobuf:"varint,3,opt,name=max_sdk_version,json=maxSdkVersion,proto3" json:"max_sdk_version,omitempty"`
	// Specifies the API Level on which the application is designed to run.
	TargetSdkVersion int32 `protobuf:"varint,6,opt,name=target_sdk_version,json=targetSdkVersion,proto3" json:"target_sdk_version,omitempty"`
	// User-readable name for the application.
	ApplicationLabel string          `protobuf:"bytes,4,opt,name=application_label,json=applicationLabel,proto3" json:"application_label,omitempty"`
	IntentFilters    []*IntentFilter `protobuf:"bytes,5,rep,name=intent_filters,json=intentFilters,proto3" json:"intent_filters,omitempty"`
	// Permissions declared to be used by the application
	UsesPermission []string `protobuf:"bytes,7,rep,name=uses_permission,json=usesPermission,proto3" json:"uses_permission,omitempty"`
}

func (x *ApkManifest) Reset() {
	*x = ApkManifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApkManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApkManifest) ProtoMessage() {}

func (x *ApkManifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApkManifest.ProtoReflect.Descriptor instead.
func (*ApkManifest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_application_details_proto_rawDescGZIP(), []int{1}
}

func (x *ApkManifest) GetPackageName() string {
	if x != nil {
		return x.PackageName
	}
	return ""
}

func (x *ApkManifest) GetMinSdkVersion() int32 {
	if x != nil {
		return x.MinSdkVersion
	}
	return 0
}

func (x *ApkManifest) GetMaxSdkVersion() int32 {
	if x != nil {
		return x.MaxSdkVersion
	}
	return 0
}

func (x *ApkManifest) GetTargetSdkVersion() int32 {
	if x != nil {
		return x.TargetSdkVersion
	}
	return 0
}

func (x *ApkManifest) GetApplicationLabel() string {
	if x != nil {
		return x.ApplicationLabel
	}
	return ""
}

func (x *ApkManifest) GetIntentFilters() []*IntentFilter {
	if x != nil {
		return x.IntentFilters
	}
	return nil
}

func (x *ApkManifest) GetUsesPermission() []string {
	if x != nil {
		return x.UsesPermission
	}
	return nil
}

// The <intent-filter> section of an <activity> tag.
// https://developer.android.com/guide/topics/manifest/intent-filter-element.html
type IntentFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The android:name value of the <action> tag.
	ActionNames []string `protobuf:"bytes,1,rep,name=action_names,json=actionNames,proto3" json:"action_names,omitempty"`
	// The android:name value of the <category> tag.
	CategoryNames []string `protobuf:"bytes,2,rep,name=category_names,json=categoryNames,proto3" json:"category_names,omitempty"`
	// The android:mimeType value of the <data> tag.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *IntentFilter) Reset() {
	*x = IntentFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IntentFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentFilter) ProtoMessage() {}

func (x *IntentFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentFilter.ProtoReflect.Descriptor instead.
func (*IntentFilter) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_application_details_proto_rawDescGZIP(), []int{2}
}

func (x *IntentFilter) GetActionNames() []string {
	if x != nil {
		return x.ActionNames
	}
	return nil
}

func (x *IntentFilter) GetCategoryNames() []string {
	if x != nil {
		return x.CategoryNames
	}
	return nil
}

func (x *IntentFilter) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// A request to get the details of an Android application APK.
type GetApkDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The APK to be parsed for details.
	Location *FileReference `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *GetApkDetailsRequest) Reset() {
	*x = GetApkDetailsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApkDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApkDetailsRequest) ProtoMessage() {}

func (x *GetApkDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApkDetailsRequest.ProtoReflect.Descriptor instead.
func (*GetApkDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_application_details_proto_rawDescGZIP(), []int{3}
}

func (x *GetApkDetailsRequest) GetLocation() *FileReference {
	if x != nil {
		return x.Location
	}
	return nil
}

// Response containing the details of the specified Android application APK.
type GetApkDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the Android APK.
	ApkDetail *ApkDetail `protobuf:"bytes,1,opt,name=apk_detail,json=apkDetail,proto3" json:"apk_detail,omitempty"`
}

func (x *GetApkDetailsResponse) Reset() {
	*x = GetApkDetailsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetApkDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetApkDetailsResponse) ProtoMessage() {}

func (x *GetApkDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_testing_v1_application_details_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetApkDetailsResponse.ProtoReflect.Descriptor instead.
func (*GetApkDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_testing_v1_application_details_proto_rawDescGZIP(), []int{4}
}

func (x *GetApkDetailsResponse) GetApkDetail() *ApkDetail {
	if x != nil {
		return x.ApkDetail
	}
	return nil
}

var File_google_devtools_testing_v1_application_details_proto protoreflect.FileDescriptor

var file_google_devtools_testing_v1_application_details_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x57, 0x0a, 0x09, 0x41, 0x70,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x4a, 0x0a, 0x0c, 0x61, 0x70, 0x6b, 0x5f, 0x6d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x6b, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x52, 0x0b, 0x61, 0x70, 0x6b, 0x4d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x22, 0xd5, 0x02, 0x0a, 0x0b, 0x41, 0x70, 0x6b, 0x4d, 0x61, 0x6e, 0x69, 0x66,
	0x65, 0x73, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x64,
	0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0d, 0x6d, 0x69, 0x6e, 0x53, 0x64, 0x6b, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x26,
	0x0a, 0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x64, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x53, 0x64, 0x6b, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x73, 0x64, 0x6b, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x64, 0x6b, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x12, 0x4f, 0x0a, 0x0e, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x75, 0x73, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x75, 0x73, 0x65,
	0x73, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x75, 0x0a, 0x0c, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x5d, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x70, 0x6b, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x5d, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x41, 0x70, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0a, 0x61, 0x70,
	0x6b, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x6b, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x09, 0x61, 0x70, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x32, 0x9b, 0x02, 0x0a, 0x18, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb2, 0x01,
	0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x70, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x41, 0x70, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x41, 0x70, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x22, 0x2a, 0x2f, 0x76,
	0x31, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2f, 0x67, 0x65, 0x74, 0x41, 0x70,
	0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x3a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x4a, 0xca, 0x41, 0x16, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x7d,
	0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x42, 0x16, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x74, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_testing_v1_application_details_proto_rawDescOnce sync.Once
	file_google_devtools_testing_v1_application_details_proto_rawDescData = file_google_devtools_testing_v1_application_details_proto_rawDesc
)

func file_google_devtools_testing_v1_application_details_proto_rawDescGZIP() []byte {
	file_google_devtools_testing_v1_application_details_proto_rawDescOnce.Do(func() {
		file_google_devtools_testing_v1_application_details_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_testing_v1_application_details_proto_rawDescData)
	})
	return file_google_devtools_testing_v1_application_details_proto_rawDescData
}

var file_google_devtools_testing_v1_application_details_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_devtools_testing_v1_application_details_proto_goTypes = []interface{}{
	(*ApkDetail)(nil),             // 0: google.devtools.testing.v1.ApkDetail
	(*ApkManifest)(nil),           // 1: google.devtools.testing.v1.ApkManifest
	(*IntentFilter)(nil),          // 2: google.devtools.testing.v1.IntentFilter
	(*GetApkDetailsRequest)(nil),  // 3: google.devtools.testing.v1.GetApkDetailsRequest
	(*GetApkDetailsResponse)(nil), // 4: google.devtools.testing.v1.GetApkDetailsResponse
	(*FileReference)(nil),         // 5: google.devtools.testing.v1.FileReference
}
var file_google_devtools_testing_v1_application_details_proto_depIdxs = []int32{
	1, // 0: google.devtools.testing.v1.ApkDetail.apk_manifest:type_name -> google.devtools.testing.v1.ApkManifest
	2, // 1: google.devtools.testing.v1.ApkManifest.intent_filters:type_name -> google.devtools.testing.v1.IntentFilter
	5, // 2: google.devtools.testing.v1.GetApkDetailsRequest.location:type_name -> google.devtools.testing.v1.FileReference
	0, // 3: google.devtools.testing.v1.GetApkDetailsResponse.apk_detail:type_name -> google.devtools.testing.v1.ApkDetail
	3, // 4: google.devtools.testing.v1.ApplicationDetailService.GetApkDetails:input_type -> google.devtools.testing.v1.GetApkDetailsRequest
	4, // 5: google.devtools.testing.v1.ApplicationDetailService.GetApkDetails:output_type -> google.devtools.testing.v1.GetApkDetailsResponse
	5, // [5:6] is the sub-list for method output_type
	4, // [4:5] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_devtools_testing_v1_application_details_proto_init() }
func file_google_devtools_testing_v1_application_details_proto_init() {
	if File_google_devtools_testing_v1_application_details_proto != nil {
		return
	}
	file_google_devtools_testing_v1_test_execution_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_testing_v1_application_details_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApkDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_application_details_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApkManifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_application_details_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IntentFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_application_details_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApkDetailsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_testing_v1_application_details_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetApkDetailsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_testing_v1_application_details_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_testing_v1_application_details_proto_goTypes,
		DependencyIndexes: file_google_devtools_testing_v1_application_details_proto_depIdxs,
		MessageInfos:      file_google_devtools_testing_v1_application_details_proto_msgTypes,
	}.Build()
	File_google_devtools_testing_v1_application_details_proto = out.File
	file_google_devtools_testing_v1_application_details_proto_rawDesc = nil
	file_google_devtools_testing_v1_application_details_proto_goTypes = nil
	file_google_devtools_testing_v1_application_details_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ApplicationDetailServiceClient is the client API for ApplicationDetailService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ApplicationDetailServiceClient interface {
	// Gets the details of an Android application APK.
	GetApkDetails(ctx context.Context, in *GetApkDetailsRequest, opts ...grpc.CallOption) (*GetApkDetailsResponse, error)
}

type applicationDetailServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewApplicationDetailServiceClient(cc grpc.ClientConnInterface) ApplicationDetailServiceClient {
	return &applicationDetailServiceClient{cc}
}

func (c *applicationDetailServiceClient) GetApkDetails(ctx context.Context, in *GetApkDetailsRequest, opts ...grpc.CallOption) (*GetApkDetailsResponse, error) {
	out := new(GetApkDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.testing.v1.ApplicationDetailService/GetApkDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ApplicationDetailServiceServer is the server API for ApplicationDetailService service.
type ApplicationDetailServiceServer interface {
	// Gets the details of an Android application APK.
	GetApkDetails(context.Context, *GetApkDetailsRequest) (*GetApkDetailsResponse, error)
}

// UnimplementedApplicationDetailServiceServer can be embedded to have forward compatible implementations.
type UnimplementedApplicationDetailServiceServer struct {
}

func (*UnimplementedApplicationDetailServiceServer) GetApkDetails(context.Context, *GetApkDetailsRequest) (*GetApkDetailsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetApkDetails not implemented")
}

func RegisterApplicationDetailServiceServer(s *grpc.Server, srv ApplicationDetailServiceServer) {
	s.RegisterService(&_ApplicationDetailService_serviceDesc, srv)
}

func _ApplicationDetailService_GetApkDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApkDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationDetailServiceServer).GetApkDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.testing.v1.ApplicationDetailService/GetApkDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationDetailServiceServer).GetApkDetails(ctx, req.(*GetApkDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ApplicationDetailService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.testing.v1.ApplicationDetailService",
	HandlerType: (*ApplicationDetailServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetApkDetails",
			Handler:    _ApplicationDetailService_GetApkDetails_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/testing/v1/application_details.proto",
}
